/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class ADThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    private ILogger logger;
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    protected final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet<Worker> workers = new HashSet();
    private volatile long keepAliveTime;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();

    void reject(Runnable command) {
    }

    private Thread addThread(Runnable firstTask) {
        Worker w = new Worker(firstTask);
        Thread t = this.threadFactory.newThread(w);
        if (t != null) {
            w.thread = t;
            this.workers.add(w);
            int nt = ++this.poolSize;
            if (nt > this.largestPoolSize) {
                this.largestPoolSize = nt;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfUnderCorePoolSize(Runnable firstTask) {
        Thread t = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.corePoolSize) {
                t = this.addThread(firstTask);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (t == null) {
            return false;
        }
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable addIfUnderMaximumPoolSize(Runnable firstTask) {
        Thread t = null;
        Runnable next = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize) {
                next = (Runnable)this.workQueue.poll();
                if (next == null) {
                    next = firstTask;
                }
                t = this.addThread(next);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (t == null) {
            return null;
        }
        t.start();
        return next;
    }

    Runnable getTask() throws InterruptedException {
        block7: while (true) {
            switch (this.runState) {
                case 0: {
                    if (this.poolSize <= this.corePoolSize) {
                        return this.workQueue.take();
                    }
                    long timeout = this.keepAliveTime;
                    if (timeout <= 0L) {
                        return null;
                    }
                    Runnable r = this.workQueue.poll(timeout, TimeUnit.NANOSECONDS);
                    if (r != null) {
                        return r;
                    }
                    if (this.poolSize <= this.corePoolSize) continue block7;
                    return null;
                }
                case 1: {
                    Runnable r = (Runnable)this.workQueue.poll();
                    if (r != null) {
                        return r;
                    }
                    if (this.workQueue.isEmpty()) {
                        this.interruptIdleWorkers();
                        return null;
                    }
                    try {
                        return this.workQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        continue block7;
                    }
                }
                case 2: {
                    return null;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                w.interruptIfIdle();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerDone(Worker w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += (long)w.completedTasks.get();
            this.workers.remove(w);
            if (--this.poolSize > 0) {
                return;
            }
            int state = this.runState;
            assert (state != 3);
            if (state != 2) {
                if (!this.workQueue.isEmpty()) {
                    Thread t = this.addThread(null);
                    if (t != null) {
                        t.start();
                    }
                    return;
                }
                if (state == 0) {
                    return;
                }
            }
            this.termination.signalAll();
            this.runState = 3;
        }
        finally {
            mainLock.unlock();
        }
        assert (this.runState == 3);
        this.terminated();
    }

    public ADThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ADThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ADThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ADThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    @Override
    public void execute(Runnable command) {
        Runnable r;
        if (command == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(command);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(command)) {
                return;
            }
            if (this.workQueue.offer(command)) {
                return;
            }
            r = this.addIfUnderMaximumPoolSize(command);
            if (r != command) continue;
            return;
        } while (r != null);
        this.reject(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        boolean fullyTerminated;
        block12: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(shutdownPerm);
            }
            fullyTerminated = false;
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.workers.size() > 0) {
                    int state;
                    if (sm != null) {
                        for (Worker worker : this.workers) {
                            sm.checkAccess(worker.thread);
                        }
                    }
                    if ((state = this.runState) == 0) {
                        this.runState = 1;
                    }
                    try {
                        for (Worker w : this.workers) {
                            w.interruptIfIdle();
                        }
                        break block12;
                    }
                    catch (SecurityException securityException) {
                        this.runState = state;
                        throw securityException;
                    }
                }
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            finally {
                mainLock.unlock();
            }
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        boolean fullyTerminated;
        block12: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(shutdownPerm);
            }
            fullyTerminated = false;
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.workers.size() > 0) {
                    int state;
                    if (sm != null) {
                        for (Worker worker : this.workers) {
                            sm.checkAccess(worker.thread);
                        }
                    }
                    if ((state = this.runState) != 3) {
                        this.runState = 2;
                    }
                    try {
                        for (Worker w : this.workers) {
                            w.interruptNow();
                        }
                        break block12;
                    }
                    catch (SecurityException securityException) {
                        this.runState = state;
                        throw securityException;
                    }
                }
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            finally {
                mainLock.unlock();
            }
        }
        if (fullyTerminated) {
            this.terminated();
        }
        return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        return this.runState == 2;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            while (true) {
                if (this.runState == 3) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        return this.getQueue().remove(task);
    }

    public void purge() {
        try {
            Iterator it = this.getQueue().iterator();
            while (it.hasNext()) {
                Future c;
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int extra = this.corePoolSize - corePoolSize;
            this.corePoolSize = corePoolSize;
            if (extra < 0) {
                Thread t;
                int n = this.workQueue.size();
                while (extra++ < 0 && n-- > 0 && this.poolSize < corePoolSize && (t = this.addThread(null)) != null) {
                    t.start();
                }
            } else if (extra > 0 && this.poolSize > corePoolSize) {
                Iterator<Worker> it = this.workers.iterator();
                while (it.hasNext() && extra-- > 0 && this.poolSize > corePoolSize && this.workQueue.remainingCapacity() == 0) {
                    it.next().interruptIfIdle();
                }
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int extra;
            this.maximumPoolSize = maximumPoolSize;
            if (extra > 0 && this.poolSize > maximumPoolSize) {
                Iterator<Worker> it = this.workers.iterator();
                for (extra = this.maximumPoolSize - maximumPoolSize; it.hasNext() && extra > 0 && this.poolSize > maximumPoolSize; --extra) {
                    it.next().interruptIfIdle();
                }
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            for (Worker w : this.workers) {
                if (!w.isActive()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += (long)w.completedTasks.get();
                if (!w.isActive()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += (long)w.completedTasks.get();
            }
            long l = n;
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    private class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        final IAgentAtomicInteger completedTasks;
        Thread thread;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
            this.completedTasks = new AgentAtomicIntegerImpl(0);
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (runLock.tryLock()) {
                try {
                    this.thread.interrupt();
                }
                finally {
                    runLock.unlock();
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Runnable task) {
            ReentrantLock runLock;
            block13: {
                runLock = this.runLock;
                if (ADThreadPoolExecutor.this.logger != null && ADThreadPoolExecutor.this.logger.isTraceEnabled()) {
                    ADThreadPoolExecutor.this.logger.trace(String.format("runTask(%s) called for %s", task, this));
                }
                runLock.lock();
                if (ADThreadPoolExecutor.this.logger != null && ADThreadPoolExecutor.this.logger.isTraceEnabled()) {
                    ADThreadPoolExecutor.this.logger.trace(String.format("Acquired runLog for %s", this));
                }
                try {
                    if (ADThreadPoolExecutor.this.runState != 2) break block13;
                    runLock.unlock();
                }
                catch (Throwable throwable) {
                    runLock.unlock();
                    if (ADThreadPoolExecutor.this.logger != null && ADThreadPoolExecutor.this.logger.isTraceEnabled()) {
                        ADThreadPoolExecutor.this.logger.trace(String.format("Released runLog for %s", this));
                    }
                    throw throwable;
                }
                if (ADThreadPoolExecutor.this.logger != null && ADThreadPoolExecutor.this.logger.isTraceEnabled()) {
                    ADThreadPoolExecutor.this.logger.trace(String.format("Released runLog for %s", this));
                }
                return;
            }
            Thread.interrupted();
            boolean ran = false;
            ADThreadPoolExecutor.this.beforeExecute(this.thread, task);
            try {
                if (ADThreadPoolExecutor.this.logger != null && ADThreadPoolExecutor.this.logger.isTraceEnabled()) {
                    ADThreadPoolExecutor.this.logger.trace(String.format("About to run task %s within for %s", task, this));
                }
                task.run();
                if (ADThreadPoolExecutor.this.logger != null && ADThreadPoolExecutor.this.logger.isTraceEnabled()) {
                    ADThreadPoolExecutor.this.logger.trace(String.format("Finished runnig task %s within for %s", task, this));
                }
                ran = true;
                ADThreadPoolExecutor.this.afterExecute(task, null);
                this.completedTasks.getAndIncrement();
            }
            catch (RuntimeException ex) {
                if (!ran) {
                    ADThreadPoolExecutor.this.afterExecute(task, ex);
                }
                throw ex;
            }
            runLock.unlock();
            if (ADThreadPoolExecutor.this.logger != null && ADThreadPoolExecutor.this.logger.isTraceEnabled()) {
                ADThreadPoolExecutor.this.logger.trace(String.format("Released runLog for %s", this));
            }
        }

        @Override
        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                while (task != null || (task = ADThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(task);
                    task = null;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                ADThreadPoolExecutor.this.workerDone(this);
            }
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }
}

