/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.SharedBoundedDelayQueue;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.atomic.AgentVolatileLongImpl;
import com.singularity.ee.util.javaspecific.scheduler.ADFutureTask;
import com.singularity.ee.util.javaspecific.scheduler.ADNanoTimeAdjuster;
import com.singularity.ee.util.javaspecific.scheduler.ADThreadPoolExecutor;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentVolatileLong;
import com.singularity.ee.util.system.SystemUtils;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class ADScheduledThreadPoolExecutor
extends ADThreadPoolExecutor
implements ScheduledExecutorService {
    private static final String NANO_TIME_ADJUSTER_REQD_PROP_NAME = "appdynamics.scheduler.time.adjuster.required";
    private static final String SCHEDULER_POOL_SIZE_LOG_ENABLE_PROP_NAME = "appdynamics.scheduler.pool.size.log.enable";
    private static final long MINIMUM_TIME_BETWEEN_POOL_LOG = 120000L;
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private volatile ILogger logger;
    private static ADNanoTimeAdjuster.RunType nanoTimeAdjusterRunType;
    private static final long NANO_ORIGIN;
    private ADNanoTimeAdjuster nanoTimeAdjuster;
    private boolean isSchedulerPoolLogEnable = false;
    private final IAgentVolatileLong lastSchedulerPoolLogAt = new AgentVolatileLongImpl();

    final long now() {
        if (this.nanoTimeAdjuster == null) {
            return (System.currentTimeMillis() - NANO_ORIGIN) * 1000000L;
        }
        return this.nanoTimeAdjuster.getCurrentNanoTime();
    }

    private Runnable delayedExecute(Runnable command) {
        if (this.isShutdown()) {
            this.reject(command);
            return null;
        }
        if (this.getPoolSize() < this.getCorePoolSize()) {
            this.prestartCoreThread();
        }
        BlockingQueue<Runnable> queue = super.getQueue();
        if (this.logger != null && this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Adding Runnable %s to DelayQueue %s", command, queue));
        }
        if (!queue.offer(command)) {
            this.reject(command);
            return null;
        }
        return command;
    }

    private void cancelUnwantedTasks() {
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            super.getQueue().clear();
        } else if (keepDelayed || keepPeriodic) {
            Object[] entries = super.getQueue().toArray();
            for (int i = 0; i < entries.length; ++i) {
                ADScheduledFutureTask t;
                Object e = entries[i];
                if (!(e instanceof ADScheduledFutureTask) || !((t = (ADScheduledFutureTask)e).isPeriodic() ? !keepPeriodic : !keepDelayed)) continue;
                t.cancel(false);
            }
            entries = null;
            this.purge();
        }
    }

    @Override
    public boolean remove(Runnable task) {
        if (!(task instanceof ADScheduledFutureTask)) {
            return false;
        }
        return this.getQueue().remove(task);
    }

    public ADScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
        this.isSchedulerPoolLogEnable = this.isSchedulerPoolLogEnable();
    }

    public ADScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), threadFactory);
        this.isSchedulerPoolLogEnable = this.isSchedulerPoolLogEnable();
    }

    public ADScheduledThreadPoolExecutor(int corePoolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(maxTasksAllowed, policy, customAction), threadFactory);
        this.isSchedulerPoolLogEnable = this.isSchedulerPoolLogEnable();
    }

    public ADScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), handler);
        this.isSchedulerPoolLogEnable = this.isSchedulerPoolLogEnable();
    }

    public ADScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, handler);
        this.isSchedulerPoolLogEnable = this.isSchedulerPoolLogEnable();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        ADScheduledFutureTask t = new ADScheduledFutureTask(command, null, triggerTime);
        t.setLogger(this.logger);
        t = (ADScheduledFutureTask)this.delayedExecute(t);
        return t;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        ADScheduledFutureTask t = new ADScheduledFutureTask(callable, triggerTime);
        t.setLogger(this.logger);
        t = (ADScheduledFutureTask)this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        ADScheduledFutureTask t = new ADScheduledFutureTask(command, null, triggerTime, unit.toNanos(period));
        t.setLogger(this.logger);
        t = (ADScheduledFutureTask)this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        ADScheduledFutureTask t = new ADScheduledFutureTask(command, null, triggerTime, unit.toNanos(-delay));
        t.setLogger(this.logger);
        t = (ADScheduledFutureTask)this.delayedExecute(t);
        return t;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    @Override
    public void shutdown() {
        this.cancelUnwantedTasks();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    public void log(ILogger logger) {
        BlockingQueue<Runnable> queue = this.getQueue();
        if (queue != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\nContents of ADScheduledThreadPoolExecutor %s follows:", this.toString()));
            boolean foundOne = false;
            for (Runnable next : queue) {
                foundOne = true;
                sb.append(String.format("\n  %s", next.toString()));
            }
            if (foundOne) {
                logger.info(sb.toString());
            } else {
                logger.info(String.format("\n  Queue for ADScheduledThreadPoolExecutor %s is empty", this.toString()));
            }
        } else {
            logger.info(String.format("\nQueue for ADScheduledThreadPoolExecutor %s is missing", this.toString()));
        }
    }

    @Override
    public void setLogger(ILogger logger) {
        this.logger = logger;
        if (this.workQueue instanceof DelayedWorkQueue) {
            ((DelayedWorkQueue)this.workQueue).setLogger(logger);
        }
        if (this.nanoTimeAdjuster != null) {
            this.nanoTimeAdjuster.setLogger(logger);
        }
    }

    void setQueueLimit(int limit) {
        if (this.workQueue instanceof DelayedWorkQueue) {
            ((DelayedWorkQueue)this.workQueue).setNewLimit(limit);
        }
    }

    void setGuardAgainstNanoTimeInconsistencies() {
        if (nanoTimeAdjusterRunType != null) {
            this.nanoTimeAdjuster = new ADNanoTimeAdjuster(nanoTimeAdjusterRunType);
            this.nanoTimeAdjuster.setLogger(this.logger);
        }
    }

    public boolean isSchedulerPoolLogEnable() {
        String propValue = System.getProperty(SCHEDULER_POOL_SIZE_LOG_ENABLE_PROP_NAME);
        return Boolean.parseBoolean(propValue);
    }

    static {
        NANO_ORIGIN = System.currentTimeMillis();
        String nanoTimeAdjusterRequired = SystemUtils.getProperty(NANO_TIME_ADJUSTER_REQD_PROP_NAME);
        if (nanoTimeAdjusterRequired != null) {
            if (nanoTimeAdjusterRequired.equalsIgnoreCase(ADNanoTimeAdjuster.RunType.SYNC.name())) {
                nanoTimeAdjusterRunType = ADNanoTimeAdjuster.RunType.SYNC;
            } else if (nanoTimeAdjusterRequired.equalsIgnoreCase(ADNanoTimeAdjuster.RunType.ASYNC.name())) {
                nanoTimeAdjusterRunType = ADNanoTimeAdjuster.RunType.ASYNC;
            }
        }
    }

    private class ADScheduledFutureTask<V>
    extends ADFutureTask<V>
    implements ScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        ADScheduledFutureTask(Runnable r, V result, long ns) {
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ADScheduledFutureTask(Runnable r, V result, long ns, long period) {
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ADScheduledFutureTask(Callable<V> callable, long ns) {
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long d = this._getDelay(unit);
            return d;
        }

        private long _getDelay(TimeUnit unit) {
            long d = unit.convert(this.time - ADScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return d;
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            ADScheduledFutureTask x = (ADScheduledFutureTask)other;
            long diff = this.time - x.time;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            if (this.sequenceNumber < x.sequenceNumber) {
                return -1;
            }
            return 1;
        }

        boolean isPeriodic() {
            return this.period != 0L;
        }

        private void runPeriodic() {
            long currentMillis;
            boolean ok = ADScheduledFutureTask.super.runAndReset();
            if (this.logger != null && this.logger.isTraceEnabled()) {
                this.logger.trace(String.format("ScheduledFutureTask: %s runAndReset() returns %s", this.toString(), Boolean.valueOf(ok).toString()));
            }
            boolean down = ADScheduledThreadPoolExecutor.this.isShutdown();
            if (ok && (!down || ADScheduledThreadPoolExecutor.this.getContinueExistingPeriodicTasksAfterShutdownPolicy() && !ADScheduledThreadPoolExecutor.this.isTerminating())) {
                long p = this.period;
                this.time = p > 0L ? (this.time += p) : ADScheduledThreadPoolExecutor.this.now() - p;
                ADScheduledThreadPoolExecutor.super.getQueue().add(this);
            } else if (down) {
                ADScheduledThreadPoolExecutor.this.interruptIdleWorkers();
            }
            if (ADScheduledThreadPoolExecutor.this.isSchedulerPoolLogEnable && (currentMillis = System.currentTimeMillis()) - ADScheduledThreadPoolExecutor.this.lastSchedulerPoolLogAt.get() > 120000L) {
                this.logger.debug("QueueSize: " + ADScheduledThreadPoolExecutor.this.getQueue().size() + ", currentPoolSize: " + ADScheduledThreadPoolExecutor.this.getPoolSize() + ", corePoolSize: " + ADScheduledThreadPoolExecutor.this.getCorePoolSize());
                ADScheduledThreadPoolExecutor.this.lastSchedulerPoolLogAt.set(currentMillis);
            }
        }

        @Override
        public void run() {
            if (this.isPeriodic()) {
                this.runPeriodic();
            } else {
                ADScheduledFutureTask.super.run();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Sync object is %s.  time = %d   period = %d delay = %d isTerminating = %s  terminated = %s", ((Object)this.sync).toString(), this.time, this.period, this._getDelay(TimeUnit.NANOSECONDS), Boolean.valueOf(ADScheduledThreadPoolExecutor.this.isTerminating()).toString(), Boolean.valueOf(ADScheduledThreadPoolExecutor.this.isTerminated()).toString()));
            return sb.toString();
        }
    }

    static class DelayedWorkQueue
    extends AbstractCollection<Runnable>
    implements BlockingQueue<Runnable> {
        private ILogger logger;
        private IAgentAtomicInteger queueSize = new AgentAtomicIntegerImpl();
        private final SharedBoundedDelayQueue<ADScheduledFutureTask> futureTasks;

        DelayedWorkQueue() {
            this.futureTasks = new SharedBoundedDelayQueue(500);
        }

        DelayedWorkQueue(int upperLimit, BoundsPolicy policy, ICustomAction customAction) {
            this.futureTasks = new SharedBoundedDelayQueue(upperLimit, policy, customAction);
        }

        @Override
        public Runnable poll() {
            Runnable returnObject = (Runnable)this.futureTasks.poll();
            if (returnObject != null) {
                this.queueSize.decrementAndGet();
            }
            return returnObject;
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.futureTasks.peek();
        }

        @Override
        public Runnable take() throws InterruptedException {
            if (this.logger != null && this.logger.isTraceEnabled()) {
                this.logger.trace(String.format("Attempting to obtain Runnable from DelayQueue %s  approximate queue size is %d", this.toString(), this.queueSize.get()));
                Runnable peek = (Runnable)this.futureTasks.peek();
                if (peek != null) {
                    this.logger.trace(String.format("Peeked object is %s", peek));
                }
            }
            Runnable returnObject = (Runnable)this.futureTasks.take();
            this.queueSize.decrementAndGet();
            if (this.logger != null && this.logger.isTraceEnabled()) {
                this.logger.trace(String.format("Obtained Runnable %s from DelayQueue %s", returnObject.toString(), this.toString()));
            }
            return returnObject;
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            Runnable returnObject = (Runnable)this.futureTasks.poll(timeout, unit);
            if (returnObject != null) {
                this.queueSize.decrementAndGet();
            }
            return returnObject;
        }

        @Override
        public boolean add(Runnable x) {
            this.queueSize.incrementAndGet();
            return this.futureTasks.add((ADScheduledFutureTask)x);
        }

        @Override
        public boolean offer(Runnable x) {
            this.queueSize.incrementAndGet();
            return this.futureTasks.offer((ADScheduledFutureTask)x);
        }

        @Override
        public void put(Runnable x) {
            this.queueSize.incrementAndGet();
            this.futureTasks.put((ADScheduledFutureTask)x);
        }

        @Override
        public boolean offer(Runnable x, long timeout, TimeUnit unit) {
            this.queueSize.incrementAndGet();
            return this.futureTasks.offer((ADScheduledFutureTask)x, timeout, unit);
        }

        @Override
        public Runnable remove() {
            Runnable returnObject = (Runnable)this.futureTasks.remove();
            if (returnObject != null) {
                this.queueSize.decrementAndGet();
            }
            return returnObject;
        }

        @Override
        public Runnable element() {
            return (Runnable)this.futureTasks.element();
        }

        @Override
        public void clear() {
            this.queueSize.set(0);
            this.futureTasks.clear();
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            this.queueSize.set(0);
            return this.futureTasks.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            int numDrained = this.futureTasks.drainTo(c, maxElements);
            this.queueSize.decrementValueAndGet(numDrained);
            return numDrained;
        }

        @Override
        public int remainingCapacity() {
            return this.futureTasks.remainingCapacity();
        }

        @Override
        public boolean remove(Object x) {
            boolean bReturn = this.futureTasks.remove(x);
            if (bReturn) {
                this.queueSize.decrementAndGet();
            }
            return bReturn;
        }

        @Override
        public boolean contains(Object x) {
            return this.futureTasks.contains(x);
        }

        @Override
        public int size() {
            return this.futureTasks.size();
        }

        public int approximateSize() {
            return this.queueSize.get();
        }

        @Override
        public boolean isEmpty() {
            return this.futureTasks.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.futureTasks.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.futureTasks.toArray(array);
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Iterator<Runnable>(){
                private Iterator<ADScheduledFutureTask> it;
                {
                    this.it = DelayedWorkQueue.this.futureTasks.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Runnable next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        public void setLogger(ILogger logger) {
            this.logger = logger;
            this.futureTasks.setILogger(logger);
        }

        public void setNewLimit(int upperLimit) {
            this.futureTasks.setNewUpperBound(upperLimit);
        }

        public void setNewPolicy(BoundsPolicy policy) {
            this.futureTasks.setNewPolicy(policy);
        }
    }
}

