/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicLong;

class ADNanoTimeAdjuster {
    static final long WAKEUP_INTERVAL = 10L;
    static final long WAKEUP_INTERVAL_NANOS = 10L;
    static final long CLOCK_JUMP_AHEAD_TOLERANCE = 10000L;
    static final long SYNC_CLOCK_JUMP_AHEAD_TOLERANCE = 300000L;
    private RunType runType;
    private volatile long currentTimeInNanos;
    private IAgentAtomicLong lastTime;
    private IAgentAtomicLong startTime;
    private ILogger logger;

    ADNanoTimeAdjuster(RunType runType) {
        this.runType = runType;
        if (runType == RunType.ASYNC) {
            new AsyncThread().start();
        } else {
            long startTime = System.currentTimeMillis();
            this.startTime = new AgentAtomicLongImpl(startTime);
            this.lastTime = new AgentAtomicLongImpl(startTime);
        }
    }

    long getCurrentNanoTime() {
        if (this.runType == RunType.ASYNC) {
            return this.currentTimeInNanos;
        }
        return this.getCurrentNanoTimeSync();
    }

    private long getCurrentNanoTimeSync() {
        long newStartTime;
        long newTime;
        while (true) {
            newTime = System.currentTimeMillis();
            long lastTime = this.lastTime.get();
            long startTime = this.startTime.get();
            long diff = newTime - lastTime;
            long newLastTime = newTime;
            if (diff < 0L || diff > 300000L) {
                newStartTime = startTime + diff;
                if (this.logger != null) {
                    this.logger.warn(String.format("ADNanoTimeAdjuster detected time difference %d not as expected - initial time adjusted", diff));
                }
            } else {
                newStartTime = startTime;
            }
            if (!this.startTime.compareAndSet(startTime, newStartTime)) continue;
            if (this.lastTime.compareAndSet(lastTime, newLastTime)) break;
            if (this.startTime.compareAndSet(newStartTime, startTime) || this.logger == null) continue;
            this.logger.warn(String.format("Possible inconsistency between startTime %d and lastTime %d", newStartTime, lastTime));
        }
        return (newTime - newStartTime) * 1000000L;
    }

    void asyncRun() {
        try {
            long initialTimeInNanos;
            long lastTime = initialTimeInNanos = System.nanoTime();
            while (true) {
                Thread.sleep(10L);
                long newTime = System.currentTimeMillis();
                long expectedTime = lastTime + 10L;
                long diff = newTime - expectedTime;
                if (diff < 0L) {
                    initialTimeInNanos = this.getAdjustment(diff, initialTimeInNanos);
                    if (this.logger != null) {
                        this.logger.warn(String.format("ADNanoTimeAdjuster detected time difference %d less than expected - initial time adjusted", diff));
                    }
                } else if (diff > 10000L) {
                    initialTimeInNanos += diff;
                    if (this.logger != null) {
                        this.logger.warn(String.format("ADNanoTimeAdjuster detected time difference %d greater than expected - initial time adjusted", diff));
                    }
                }
                this.currentTimeInNanos = (newTime - initialTimeInNanos) * 1000000L;
                lastTime = newTime;
            }
        }
        catch (InterruptedException e) {
            if (this.logger != null) {
                this.logger.error(String.format("Exception %s thrown in ADNanoTimeAdjuster.run()", e.toString()), e);
            }
            return;
        }
    }

    void setLogger(ILogger logger) {
        this.logger = logger;
    }

    private long getAdjustment(long diff, long initialTimeInNanos) {
        return initialTimeInNanos - (10L - diff);
    }

    static enum RunType {
        SYNC,
        ASYNC;

    }

    private class AsyncThread
    extends Thread {
        AsyncThread() {
            super("ADNanoTimeAdjuster");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ADNanoTimeAdjuster.this.asyncRun();
        }
    }
}

