/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.logging.ILogger;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class ADFutureTask<V>
implements Future<V>,
Runnable {
    protected final Sync sync;
    protected ILogger logger;

    public ADFutureTask(Callable<V> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.sync = new Sync(callable);
    }

    public ADFutureTask(Runnable runnable, V result) {
        this.sync = new Sync(Executors.callable(runnable, result));
    }

    @Override
    public boolean isCancelled() {
        return this.sync.innerIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this.sync.innerIsDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.sync.innerCancel(mayInterruptIfRunning, 0);
    }

    public boolean cancel(int waitTimeoutIfRunning) {
        return this.sync.innerCancel(false, waitTimeoutIfRunning);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.sync.innerGet();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.sync.innerGet(unit.toNanos(timeout));
    }

    protected void done() {
    }

    protected void set(V v) {
        this.sync.innerSet(v);
    }

    protected void setException(Throwable t) {
        this.sync.innerSetException(t);
    }

    @Override
    public void run() {
        this.sync.innerRun();
    }

    protected boolean runAndReset() {
        return this.sync.innerRunAndReset();
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
        if (this.sync != null) {
            this.sync.setLogger(logger);
        }
    }

    private final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int RUNNING = 1;
        private static final int RAN = 2;
        private static final int CANCELLED = 4;
        private final Callable<V> callable;
        private V result;
        private Throwable exception;
        private ILogger logger;
        private volatile Thread runner;

        Sync(Callable<V> callable) {
            this.callable = callable;
        }

        private boolean ranOrCancelled(int state) {
            return (state & 6) != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            this.runner = null;
            return true;
        }

        boolean innerIsCancelled() {
            return this.getState() == 4;
        }

        boolean innerIsDone() {
            return this.ranOrCancelled(this.getState()) && this.runner == null;
        }

        V innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        V innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        void innerSet(V v) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
            this.result = v;
            this.releaseShared(0);
            ADFutureTask.this.done();
        }

        void innerSetException(Throwable t) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
            this.exception = t;
            this.result = null;
            this.releaseShared(0);
            ADFutureTask.this.done();
        }

        boolean innerCancel(boolean mayInterruptIfRunning, int waitTimeoutIfRunning) {
            Thread r;
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 4));
            if ((mayInterruptIfRunning || waitTimeoutIfRunning > 0) && (r = this.runner) != null) {
                if (mayInterruptIfRunning) {
                    r.interrupt();
                } else {
                    try {
                        r.join(waitTimeoutIfRunning);
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
            }
            this.releaseShared(0);
            ADFutureTask.this.done();
            return true;
        }

        void innerRun() {
            if (!this.compareAndSetState(0, 1)) {
                return;
            }
            try {
                this.runner = Thread.currentThread();
                this.innerSet(this.callable.call());
            }
            catch (Throwable ex) {
                this.innerSetException(ex);
            }
        }

        boolean innerRunAndReset() {
            if (!this.compareAndSetState(0, 1)) {
                if (this.logger != null && this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("Sync.innerRunAndReset() %s returns false", this.toString()));
                }
                return false;
            }
            try {
                this.runner = Thread.currentThread();
                this.callable.call();
                this.runner = null;
                return this.compareAndSetState(1, 0);
            }
            catch (Throwable ex) {
                this.innerSetException(ex);
                return false;
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Sync state is %d  ", this.getState()));
            Object task = this.getTaskFromCallable();
            if (task != null) {
                sb.append(task.toString());
            } else {
                sb.append(this.callable.toString());
            }
            return sb.toString();
        }

        private Object getTaskFromCallable() {
            Object returnObject;
            block2: {
                returnObject = null;
                try {
                    Class<?> clazz = this.callable.getClass();
                    Field taskField = clazz.getDeclaredField("task");
                    taskField.setAccessible(true);
                    returnObject = taskField.get(this.callable);
                }
                catch (Exception e) {
                    if (this.logger == null) break block2;
                    this.logger.error(e.toString(), e);
                }
            }
            return returnObject;
        }

        void setLogger(ILogger logger) {
            this.logger = logger;
        }
    }
}

