/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.collections;

import java.lang.reflect.Array;
import java.util.Date;

public class ADArrayMap<T> {
    public static final int DEFAULT_INCREMENT = 10;
    public static final int DEFAULT_INITIAL_SIZE = 10;
    T[] array = null;
    private final int initialSize;
    private final int increment;

    public ADArrayMap() {
        this(10);
    }

    public ADArrayMap(int initialSize) {
        this(initialSize, 10);
    }

    public ADArrayMap(int initialSize, int increment) {
        this.initialSize = initialSize;
        this.increment = increment;
    }

    public synchronized void reset(int index) {
        if (this.array != null && index < this.array.length) {
            this.array[index] = null;
        }
    }

    public synchronized void put(int index, T value) {
        if (value == null) {
            this.reset(index);
        } else {
            if (this.array == null || index >= this.array.length) {
                this.expandArray(index, value);
            }
            this.array[index] = value;
        }
    }

    public T get(int index) {
        return this.array[index];
    }

    private void expandArray(int index, T value) {
        if (this.array == null) {
            this.array = this.createEmptyArray(value.getClass(), this.initialSize);
        } else if (index >= this.array.length) {
            int newSize = index + this.increment - (index + this.increment) % this.increment;
            T[] newArray = this.createEmptyArray(value.getClass(), newSize);
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
    }

    private T[] createEmptyArray(Class valueClass, int size) {
        Object[] newArray = (Object[])Array.newInstance(valueClass, size);
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = null;
        }
        return newArray;
    }

    public static void main(String[] args) {
        ADArrayMap<Date> map = new ADArrayMap<Date>();
        map.put(0, new Date(0L));
        map.put(10, new Date(1L));
        map.put(10, new Date(3L));
        map.put(33, new Date(4L));
        if (((Date[])map.array).length != 40) {
            throw new AssertionError((Object)"Map length not 40");
        }
        if (((Date)map.get(0)).getTime() != 0L) {
            throw new AssertionError((Object)"Fail");
        }
        if (((Date)map.get(10)).getTime() != 3L) {
            throw new AssertionError((Object)"Fail");
        }
        if (((Date)map.get(33)).getTime() != 4L) {
            throw new AssertionError((Object)"Fail");
        }
    }
}

