/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class UnsynchronizedByteArrayOutputStream
extends ByteArrayOutputStream {
    public UnsynchronizedByteArrayOutputStream() {
    }

    public UnsynchronizedByteArrayOutputStream(int size) {
        super(size);
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charsetName);
    }

    @Override
    @Deprecated
    public String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.count);
    }

    private byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

