/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.io;

import java.io.InputStream;
import java.io.OutputStream;

public class StreamGobbler {
    private final InputStream is;
    private final String name;
    private OutputStream outStream;
    private Thread gobbler;

    public StreamGobbler(InputStream inputStream, String name) {
        if (inputStream == null) {
            throw new NullPointerException("the input stream is null");
        }
        if (name == null) {
            throw new NullPointerException("the name is null");
        }
        this.is = inputStream;
        this.name = name;
    }

    public void doCaptureData(OutputStream outputStream) {
        this.outStream = outputStream;
    }

    public void start() {
        this.gobbler = new Thread(this.name){

            @Override
            public void run() {
                StreamGobbler.this.gobble();
            }
        };
        this.gobbler.setDaemon(true);
        this.gobbler.start();
    }

    public void waitForCompletion() throws InterruptedException {
        if (this.gobbler != null) {
            this.gobbler.join();
        }
    }

    private void gobble() {
        InputStream input = this.is;
        try {
            int read;
            while ((read = input.read()) != -1) {
                if (this.outStream == null) continue;
                this.outStream.write(read);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }
}

