/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.exceptionop;

import com.singularity.ee.util.logging.ILogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ExceptionOperations {
    private static final StackTraceElement[] EMPTY_ARRAY = new StackTraceElement[0];
    private static Method getOurStackTrace;
    private static Method getStackTraceElement;
    private static Method getStackTraceDepth;
    private static Field stackTraceField;
    private static volatile boolean gotMethods;

    private ExceptionOperations() {
    }

    private static boolean getMethods(ILogger logger) {
        boolean success;
        block4: {
            success = false;
            if (!gotMethods) {
                gotMethods = true;
                try {
                    getOurStackTrace = Throwable.class.getDeclaredMethod("getOurStackTrace", new Class[0]);
                    getOurStackTrace.setAccessible(true);
                    getStackTraceElement = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
                    getStackTraceElement.setAccessible(true);
                    getStackTraceDepth = Throwable.class.getDeclaredMethod("getStackTraceDepth", new Class[0]);
                    getStackTraceDepth.setAccessible(true);
                    stackTraceField = Throwable.class.getDeclaredField("stackTrace");
                    stackTraceField.setAccessible(true);
                    success = true;
                }
                catch (Throwable t) {
                    if (logger == null) break block4;
                    String message = String.format("%s caught trying to reflect Throwable methods", t);
                    if (logger.isDebugEnabled()) {
                        logger.debug(message, t);
                    }
                    logger.warn(message);
                }
            }
        }
        return success;
    }

    public static void printStackTrace(Throwable e) {
        e.printStackTrace(System.out);
    }

    public static void printStackTrace(Throwable t, PrintWriter writer) {
        t.printStackTrace(writer);
    }

    public static void printStackTrace(Throwable t, StringBuilder builder) {
        PrintWriter writer = new PrintWriter(new StringWriter());
        ExceptionOperations.printStackTrace(t, writer);
        builder.append(writer);
    }

    public static String getMessage(Throwable t) {
        try {
            return t.getMessage();
        }
        catch (Throwable e) {
            if (t != null) {
                return t.getClass().getName();
            }
            return "";
        }
    }

    public static StackTraceElement[] getStackTrace(Throwable t) {
        return ExceptionOperations.getStackTrace(t, null);
    }

    public static StackTraceElement[] getStackTrace(Throwable t, ILogger logger) {
        return ExceptionOperations.getStackTraceOptimized(t, Integer.MAX_VALUE, logger);
    }

    public static StackTraceElement[] getStackTraceOptimized(Throwable t, int stackDepth) {
        return ExceptionOperations.getStackTraceOptimized(t, stackDepth, null);
    }

    public static StackTraceElement[] getStackTraceOptimized(Throwable t, int stackDepth, ILogger logger) {
        if (!gotMethods) {
            ExceptionOperations.getMethods(logger);
        }
        if (getOurStackTrace != null && getStackTraceDepth != null && getStackTraceElement != null && stackTraceField != null) {
            try {
                StackTraceElement[] stackTraceElements = (StackTraceElement[])stackTraceField.get(t);
                if (stackTraceElements != null && stackTraceElements.length > 0) {
                    return ExceptionOperations.cloneWithDepth(stackTraceElements, stackDepth);
                }
                StackTraceElement[] elements = (StackTraceElement[])getOurStackTrace.invoke((Object)t, new Object[0]);
                return ExceptionOperations.cloneWithDepth(elements, stackDepth);
            }
            catch (Throwable t1) {
                if (logger != null) {
                    logger.error(String.format("%s caught in getStackTraceOptimized", t1), t1);
                }
                getOurStackTrace = null;
                return ExceptionOperations.cloneWithDepth(t.getStackTrace(), stackDepth);
            }
        }
        return ExceptionOperations.cloneWithDepth(t.getStackTrace(), stackDepth);
    }

    private static StackTraceElement[] cloneWithDepth(StackTraceElement[] elements, int stackDepth) {
        if (elements == null) {
            return EMPTY_ARRAY;
        }
        if (elements.length <= stackDepth) {
            return elements;
        }
        int len = stackDepth + 1;
        StackTraceElement[] clonedElements = new StackTraceElement[len];
        System.arraycopy(elements, 0, clonedElements, 0, stackDepth);
        clonedElements[stackDepth] = new StackTraceElement("Exception limited to " + stackDepth + " frames", "", "", 0);
        return clonedElements;
    }
}

