/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.compress;

import com.singularity.ee.util.compress.CompressedObject;
import com.singularity.ee.util.logging.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CompressionUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractArchive(String archivePath, String outputDir, ILogger logger) throws IOException {
        logger.debug("Extract Archive - Archive Path[" + archivePath + "] + To Directory [" + outputDir + "]");
        if (!new File(outputDir).exists()) {
            throw new IOException("Extract directory " + outputDir + " does not exist");
        }
        ZipInputStream zis = null;
        zis = new ZipInputStream(new FileInputStream(archivePath));
        try {
            ZipEntry entry;
            int BUFFER = 2048;
            byte[] data = new byte[2048];
            while ((entry = zis.getNextEntry()) != null) {
                block15: {
                    logger.debug("Extracting Entry: " + entry);
                    String entryName = entry.getName();
                    try {
                        File file;
                        if (entry.isDirectory()) {
                            file = new File(outputDir, entryName);
                            if (!file.exists()) {
                                file.mkdirs();
                            }
                            break block15;
                        }
                        file = new File(outputDir, entryName);
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        try (FileOutputStream fos = new FileOutputStream(file);){
                            int bytesRead;
                            while ((bytesRead = zis.read(data, 0, 2048)) != -1) {
                                fos.write(data, 0, bytesRead);
                            }
                            fos.flush();
                        }
                    }
                    finally {
                        zis.closeEntry();
                    }
                }
                logger.debug("Extracted Entry: " + entry);
            }
        }
        finally {
            zis.close();
        }
    }

    public static CompressedObject compressString(String inputString) throws UnsupportedEncodingException {
        byte[] input = inputString.getBytes("UTF-8");
        byte[] output = new byte[inputString.length()];
        Deflater compresser = new Deflater();
        compresser.setInput(input);
        compresser.finish();
        int compressedDataLength = compresser.deflate(output);
        compresser.end();
        byte[] compressedBytes = new byte[compressedDataLength];
        System.arraycopy(output, 0, compressedBytes, 0, compressedDataLength);
        return new CompressedObject(inputString.length(), compressedDataLength, compressedBytes);
    }

    public static CompressedObject compressBytes(byte[] input) {
        byte[] output = new byte[input.length];
        Deflater compresser = new Deflater();
        compresser.setInput(input);
        compresser.finish();
        int compressedDataLength = compresser.deflate(output);
        compresser.end();
        byte[] compressedBytes = new byte[compressedDataLength];
        System.arraycopy(output, 0, compressedBytes, 0, compressedDataLength);
        return new CompressedObject(input.length, compressedDataLength, compressedBytes);
    }

    public static CompressedObject compressObject(Object obj) throws IOException {
        byte[] bytes = CompressionUtility.objectToBytes(obj);
        if (bytes == null) {
            return null;
        }
        return CompressionUtility.compressBytes(bytes);
    }

    public static byte[] objectToBytes(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = null;){
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
        }
        return baos.toByteArray();
    }

    public static String uncompressString(CompressedObject compressedString) throws UnsupportedEncodingException, DataFormatException {
        Inflater decompresser = new Inflater();
        decompresser.setInput(compressedString.getCompressedBytes(), 0, compressedString.getCompressedLength());
        byte[] result = new byte[compressedString.getOriginalLength()];
        int resultLength = decompresser.inflate(result);
        decompresser.end();
        return new String(result, 0, resultLength, "UTF-8");
    }

    public static byte[] uncompressBinary(CompressedObject compressedBytes) throws DataFormatException {
        Inflater decompresser = new Inflater();
        decompresser.setInput(compressedBytes.getCompressedBytes(), 0, compressedBytes.getCompressedLength());
        byte[] result = new byte[compressedBytes.getOriginalLength()];
        decompresser.inflate(result);
        decompresser.end();
        return result;
    }

    public static final ZipEntry getEntryOfName(ZipInputStream zipIn, String fileName) throws IOException {
        ZipEntry entry;
        while ((entry = zipIn.getNextEntry()) != null) {
            if (entry.getName().equals(fileName)) {
                return entry;
            }
            zipIn.closeEntry();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void searchForClass(String dir, String pattern) throws IOException {
        File[] jarFiles;
        for (File jarFile : jarFiles = new File(dir).listFiles()) {
            ZipInputStream zis = null;
            try {
                ZipEntry entry;
                if (!jarFile.getName().endsWith(".jar")) continue;
                zis = new ZipInputStream(new FileInputStream(jarFile));
                while ((entry = zis.getNextEntry()) != null) {
                    if (!entry.getName().contains(pattern)) continue;
                    System.out.println("Found Pattern -" + pattern);
                    System.out.println("Entry Name -" + entry.getName());
                    System.out.println("File -" + jarFile.getAbsolutePath());
                }
            }
            finally {
                try {
                    if (zis != null) {
                        zis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

