/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections.bounded;

import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.collections.bounded.BoundedCollectionLimits;
import com.singularity.ee.util.collections.bounded.BoundsExceededException;
import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.IBoundsMonitor;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.javaspecific.atomic.AgentVolatileLongImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.NoOpLogger;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import com.singularity.ee.util.spi.IAgentVolatileLong;
import com.singularity.ee.util.system.SystemUtils;

public class SharedBoundsEnforcer {
    private static final long MINIMUM_TIME_BETWEEN_WARNINGS = 120000L;
    private static final ILogger NOOP_LOGGER = new NoOpLogger();
    private static IBoundsMonitor boundsMonitor;
    private ILogger logger = NOOP_LOGGER;
    public static final int DEFAULT_UPPER_LIMIT = 500;
    public static final BoundsPolicy DEFAULT_POLICY;
    private static BoundsPolicy overridePolicy;
    private static final BoundsPolicy[] allPolicies;
    private static final String DEFAULT_POLICY_PROP_NAME = "com.appdynamics.bounded.collections.default.policy";
    private static final int MIN_UPPER_LIMIT_FOR_WARNING = 10;
    protected volatile int upperLimit;
    protected volatile int warnLimit;
    protected volatile int specifiedLimit;
    protected BoundsPolicy policy;
    private volatile boolean upperLimitExceededMessageIssued;
    private volatile boolean warningIssued;
    private volatile boolean shouldIssue80PercentWarning;
    protected final IBoundedCollection collection;
    protected final ICustomAction action;
    private float bufferPct = 0.0f;
    private final IAgentVolatileLong timeOfLastResizeMessage = new AgentVolatileLongImpl();
    private IAgentVolatileLong timeOfLastWarningMessage = new AgentVolatileLongImpl();
    private RuntimeException runtimeExceptionForBoundsExceeded = null;

    public static void setBoundsMonitor(IBoundsMonitor newBoundsMonitor) {
        boundsMonitor = newBoundsMonitor;
    }

    protected SharedBoundsEnforcer(IBoundedCollection collection, int upperLimit) {
        this(collection, upperLimit, DEFAULT_POLICY, null);
    }

    public SharedBoundsEnforcer(IBoundedCollection collection, int upperLimit, BoundsPolicy policy) {
        this(collection, upperLimit, policy, null);
    }

    public SharedBoundsEnforcer(IBoundedCollection collection, int upperLimit, BoundsPolicy policy, ICustomAction action) {
        this.specifiedLimit = upperLimit;
        this.upperLimit = this.calculateTrueUpperLimit(upperLimit);
        this.policy = policy;
        this.collection = collection;
        this.action = action;
        this.shouldIssue80PercentWarning = false;
        if (policy.equals((Object)BoundsPolicy.CALL_ACTION_IF_BOUND_EXCEEDED) && this.action == null) {
            throw new IllegalArgumentException("ICustomAction is null while policy is set to " + (Object)((Object)BoundsPolicy.CALL_ACTION_IF_BOUND_EXCEEDED));
        }
        this.setWarnLimit();
        SharedBoundsEnforcer.registerWithMonitor(this);
    }

    public void setLogger(ILogger logger) {
        this.logger = logger != null ? logger : NOOP_LOGGER;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public BoundsPolicy getPolicy() {
        return this.policy;
    }

    public ICustomAction getAction() {
        return this.action;
    }

    public IBoundedCollection getCollection() {
        return this.collection;
    }

    public void setNewPolicy(BoundsPolicy newPolicy) {
        if (newPolicy != null && newPolicy != this.policy) {
            this.policy = newPolicy;
        }
    }

    public void setNewLimit(int newLimit) {
        if (newLimit != this.specifiedLimit) {
            this.specifiedLimit = newLimit;
            int newCalculatedLimit = this.calculateTrueUpperLimit(newLimit);
            this.newActualLimitDefined(newCalculatedLimit);
        }
    }

    private void newActualLimitDefined(int newActualLimit) {
        if (newActualLimit < this.upperLimit) {
            if (this.policy != BoundsPolicy.WARN_IF_BOUND_EXCEEDED) {
                this.collection._resize(newActualLimit);
            } else if (this.collection.getCurrentSize() > newActualLimit) {
                this.warnUpperLimitExceeded(this.getPolicyToUse());
            }
        } else {
            this.upperLimitExceededMessageIssued = false;
        }
        this.upperLimit = newActualLimit;
        this.setWarnLimit();
    }

    public void setBufferPct(float bufferPct) {
        this.bufferPct = bufferPct;
        int newCalculatedLimit = this.calculateTrueUpperLimit(this.specifiedLimit);
        this.newActualLimitDefined(newCalculatedLimit);
    }

    protected boolean warnUpperLimitExceeded(BoundsPolicy policy) {
        long currentTime;
        boolean bReturn = false;
        if (!this.upperLimitExceededMessageIssued && this.logger != null && (currentTime = ClockUtils.getCurrentTime()) - this.timeOfLastWarningMessage.get() > 120000L) {
            this.logger.warn(this.toString() + " has exceeded maximum size of " + Integer.toString(this.upperLimit) + " entries." + (this.getPolicyToUse() != BoundsPolicy.WARN_IF_BOUND_EXCEEDED ? "  New element not added" : ""));
            bReturn = true;
            this.upperLimitExceededMessageIssued = true;
            this.timeOfLastWarningMessage.set(currentTime);
        }
        return bReturn;
    }

    public boolean checkCapacity(int numToAdd) {
        boolean bReturn = true;
        BoundsPolicy policy = this.getPolicyToUse();
        boolean capacityExceeded = false;
        int currentSize = this.collection.getCurrentSize();
        if (currentSize + numToAdd > this.upperLimit) {
            long currentTime;
            int sizeTarget = this.upperLimit * 80 / 100;
            this.collection._resize(sizeTarget - numToAdd);
            currentSize = this.collection.getCurrentSize();
            if (this.logger != null && this.logger.isDebugEnabled() && (currentTime = ClockUtils.getCurrentTime()) - this.timeOfLastResizeMessage.get() > 120000L) {
                this.logger.debug("SharedEnforcer " + this.toString() + " has called _resize() method. Collection size is now " + Integer.toString(currentSize));
                this.timeOfLastResizeMessage.set(currentTime);
            }
            if (currentSize + numToAdd > this.upperLimit) {
                this.warnUpperLimitExceeded(policy);
                switch (policy) {
                    case SILENT_FAIL_BOUND_EXCEEDED: {
                        bReturn = false;
                        break;
                    }
                    case EXCEPTION_IF_BOUND_EXCEEDED: {
                        if (this.runtimeExceptionForBoundsExceeded == null) {
                            BoundsExceededException bee = new BoundsExceededException("Capacity of collection exceeded");
                            this.runtimeExceptionForBoundsExceeded = new RuntimeException(bee.getMessage(), bee);
                        }
                        throw this.runtimeExceptionForBoundsExceeded;
                    }
                    case CALL_ACTION_IF_BOUND_EXCEEDED: {
                        this.action.aboveCapacity(this.collection);
                        break;
                    }
                }
                capacityExceeded = true;
            }
        }
        if (!capacityExceeded && this.shouldIssue80PercentWarning && this.upperLimit >= 10 && this.collection.getCurrentSize() + numToAdd >= this.warnLimit) {
            if (!this.warningIssued && this.logger != null) {
                this.logger.warn("Warning - " + this.toString() + " has exceeded 80% maximum size of " + Integer.toString(this.upperLimit) + " entries.");
                this.warningIssued = true;
            }
        } else {
            this.warningIssued = false;
            this.upperLimitExceededMessageIssued = false;
        }
        return bReturn;
    }

    public BoundsPolicy getPolicyToUse() {
        return overridePolicy != null ? overridePolicy : this.policy;
    }

    protected static BoundsPolicy parseBoundsPolicyString(String policy) {
        BoundsPolicy returnObject = null;
        for (BoundsPolicy nextPolicy : allPolicies) {
            if (!policy.equals(nextPolicy.toString())) continue;
            returnObject = nextPolicy;
            break;
        }
        return returnObject;
    }

    private void setWarnLimit() {
        this.warnLimit = this.upperLimit * 80 / 100;
    }

    private static void registerWithMonitor(SharedBoundsEnforcer boundsEnforcer) {
        if (boundsMonitor != null) {
            boundsMonitor.registerCollection(boundsEnforcer);
        }
    }

    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.shouldIssue80PercentWarning = shouldIssue80PercentWarning;
    }

    public String getBoundsPropertyName() {
        return null;
    }

    public String getBoundsServiceName() {
        return null;
    }

    private int calculateTrueUpperLimit(int definedUpperLimit) {
        int returnUpperLimit = definedUpperLimit + (int)((float)definedUpperLimit * this.bufferPct);
        return returnUpperLimit;
    }

    protected static void setOverridePolicy(BoundsPolicy newPolicy) {
        overridePolicy = newPolicy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BoundsEnforcer for collection ").append(ReflectionUtilityCommon.getName(this.collection.getClass()));
        return sb.toString();
    }

    static {
        DEFAULT_POLICY = BoundedCollectionLimits.DEFAULT_BOUNDS_POLICY;
        allPolicies = (BoundsPolicy[])EnumHelper.getValues(BoundsPolicy.class);
        String defaultPolicyString = SystemUtils.getProperty(DEFAULT_POLICY_PROP_NAME);
        if (defaultPolicyString != null) {
            overridePolicy = SharedBoundsEnforcer.parseBoundsPolicyString(defaultPolicyString);
        }
    }
}

