/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections.bounded;

import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.IBoundedCollection;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;

public class SharedBoundedArrayList<E>
extends ArrayList<E>
implements IBoundedCollection {
    private static final long serialVersionUID = 1L;
    private final SharedBoundsEnforcer boundsEnforcer;

    public SharedBoundedArrayList(int initialCapacity, int upperLimit) {
        super(initialCapacity);
        this.boundsEnforcer = new SharedBoundsEnforcer(this, upperLimit);
    }

    public SharedBoundedArrayList(int upperLimit) {
        this.boundsEnforcer = new SharedBoundsEnforcer(this, upperLimit);
    }

    public SharedBoundedArrayList(int upperLimit, BoundsPolicy policy) {
        this(upperLimit, policy, null);
    }

    public SharedBoundedArrayList(int upperLimit, BoundsPolicy policy, ICustomAction action) {
        this.boundsEnforcer = new SharedBoundsEnforcer(this, upperLimit, policy, action);
    }

    public void setILogger(ILogger logger) {
        this.boundsEnforcer.setLogger(logger);
    }

    @Override
    public void _resize(int newLimit) {
    }

    @Override
    public boolean add(E e) {
        boolean bReturn = false;
        if (this.boundsEnforcer.checkCapacity(1)) {
            bReturn = super.add(e);
        }
        return bReturn;
    }

    @Override
    public void add(int index, E element) {
        if (this.boundsEnforcer.checkCapacity(1)) {
            super.add(index, element);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean bReturn = false;
        if (this.boundsEnforcer.checkCapacity(c.size())) {
            bReturn = super.addAll(index, c);
        }
        return bReturn;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean bReturn = false;
        if (this.boundsEnforcer.checkCapacity(c.size())) {
            bReturn = super.addAll(c);
        }
        return bReturn;
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public void setNewUpperBound(int newUpperBound) {
        this.boundsEnforcer.setNewLimit(newUpperBound);
    }

    @Override
    public void setNewPolicy(BoundsPolicy policy) {
        this.boundsEnforcer.setNewPolicy(policy);
    }

    @Override
    public SharedBoundsEnforcer getBoundsEnforcer() {
        return this.boundsEnforcer;
    }

    @Override
    public void setShouldIssue80PercentWarning(boolean shouldIssue80PercentWarning) {
        this.boundsEnforcer.setShouldIssue80PercentWarning(shouldIssue80PercentWarning);
    }
}

