/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class EqualsUtilHelper {
    static boolean compareRefs(Object o1, Object o2) {
        return o1 == o2;
    }

    static <E> boolean collectionEquals(Collection<E> c1, Collection<E> c2) {
        if (c1 == null) {
            return c2 == null;
        }
        return c1.equals(c2);
    }

    public static boolean arrayEquals(Object[] first, Object[] second) {
        return Arrays.equals(first, second);
    }

    public static boolean arrayEquals(char[] first, char[] second) {
        return Arrays.equals(first, second);
    }

    static <T, U> boolean mapEquals(Map<T, U> map1, Map<T, U> map2) {
        if (map1 == null) {
            return map2 == null;
        }
        return map1.equals(map2);
    }

    static boolean stringMapEqualsIgnoreCase(Map<String, String> m1, Map<String, String> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<String, String> e : m1.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (!(value == null ? m2.get(key) != null || !m2.containsKey(key) : !value.equalsIgnoreCase(m2.get(key)))) continue;
            return false;
        }
        return true;
    }

    public static boolean doubleEquals(double d1, double d2) {
        return Double.compare(d1, d2) == 0;
    }

    public static boolean floatEquals(float f1, float f2) {
        return Float.compare(f1, f2) == 0;
    }
}

