/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections;

import com.singularity.ee.util.collections.EqualsUtilHelper;
import java.util.Collection;
import java.util.Map;

public class EqualsUtil {
    public static boolean compareObjectTypes(Object obj1, Object obj2) {
        if (EqualsUtilHelper.compareRefs(obj1, obj2)) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return EqualsUtilHelper.compareRefs(obj1.getClass(), obj2.getClass());
    }

    public static boolean compareObjectFields(Object[] obj1Fields, Object[] obj2Fields) {
        if (EqualsUtilHelper.compareRefs(obj1Fields, obj2Fields)) {
            return true;
        }
        if (obj1Fields == null || obj2Fields == null) {
            return false;
        }
        if (obj1Fields.length != obj2Fields.length) {
            return false;
        }
        for (int i = 0; i < obj1Fields.length; ++i) {
            Object field1 = obj1Fields[i];
            Object field2 = obj2Fields[i];
            if (field1 == null && field2 != null) {
                return false;
            }
            if (field2 == null) {
                return false;
            }
            if (field1.equals(field2)) continue;
            return false;
        }
        return true;
    }

    public static boolean safeCompareStrings(String s1, String s2) {
        if (EqualsUtilHelper.compareRefs(s1, s2)) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean safeCompareObjects(Object s1, Object s2) {
        if (EqualsUtilHelper.compareRefs(s1, s2)) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static <E> boolean safeCompareCollections(Collection<E> c1, Collection<E> c2) {
        if (EqualsUtilHelper.compareRefs(c1, c2)) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return EqualsUtilHelper.collectionEquals(c1, c2);
    }

    public static <T, U> boolean safeCompareMaps(Map<T, U> m1, Map<T, U> m2) {
        if (EqualsUtilHelper.compareRefs(m1, m2)) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return EqualsUtilHelper.mapEquals(m1, m2);
    }

    public static boolean safeCompareStringMapEqualsValueIgnoreCase(Map<String, String> m1, Map<String, String> m2) {
        if (EqualsUtilHelper.compareRefs(m1, m2)) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return EqualsUtilHelper.stringMapEqualsIgnoreCase(m1, m2);
    }

    public static boolean safeCompareArrays(Object[] first, Object[] second) {
        if (EqualsUtilHelper.compareRefs(first, second)) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return EqualsUtilHelper.arrayEquals(first, second);
    }

    public static boolean checkBothNull(Object obj1, Object obj2) {
        return obj1 == null && obj2 == null;
    }

    public static boolean safeCompareRefs(Object o1, Object o2) {
        return EqualsUtilHelper.compareRefs(o1, o2);
    }
}

