/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.collections;

import com.singularity.ee.util.collections.CopyOnWriteMap;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.collections.ADImmutableObjectList;
import com.singularity.ee.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;

public class CollectionHelper {
    private CollectionHelper() {
    }

    public static <T> int queueSize(Queue<T> queue) {
        return queue.size();
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        return Collections.synchronizedList(list);
    }

    public static <T> Collection<T> createSyncronizedCollection() {
        return new ConcurrentLinkedQueue();
    }

    public static <K, V> Set<K> getAllKeys(Map<K, V> map) {
        return map.keySet();
    }

    public static <K, V> Collection<K> getAllKeysAsSimpleCollection(Map<K, V> map) {
        return map.keySet();
    }

    public static <K> HashSet<K> createHashSet(int size) {
        return new HashSet(size);
    }

    public static <K> Set<K> createSynchronizedHashSet(K[] ks) {
        return CollectionHelper.createSynchronizedHashSet(CollectionHelper.createHashSet(ks));
    }

    public static <K> Set<K> createSingletonSet(K item) {
        return Collections.singleton(item);
    }

    public static <K> Set<K> createSynchronizedHashSet(Set<K> ks) {
        return Collections.synchronizedSet(ks);
    }

    public static <K> Set<K> createUnmodifiableSet(Set<K> ks) {
        return Collections.unmodifiableSet(ks);
    }

    public static <K> Set<K> createHashSet(K[] ks) {
        HashSet<K> kSet = new HashSet<K>(ks.length, 1.0f);
        kSet.addAll(Arrays.asList(ks));
        return kSet;
    }

    public static <K, V> Map<K, V> createHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> createHashMap(int size) {
        return new HashMap(size, 1.0f);
    }

    public static <K> List<K> createLinkedList() {
        return new LinkedList();
    }

    public static <K> void addAll(Collection<K> destination, Collection<? extends K> toBeAdded) {
        if (destination != null && toBeAdded != null) {
            destination.addAll(toBeAdded);
        }
    }

    public static <K> void addAll(Collection<K> destination, K[] toBeAdded) {
        if (destination != null && toBeAdded != null) {
            Collections.addAll(destination, toBeAdded);
        }
    }

    public static <K> void addAllToArray(K[] destination, Collection<K> toBeAdded) {
        if (destination != null && toBeAdded != null) {
            int inx = 0;
            for (K k : toBeAdded) {
                destination[inx] = k;
                ++inx;
            }
        }
    }

    public static <K> List<K> asList(K ... input) {
        if (input == null) {
            return null;
        }
        return Arrays.asList(input);
    }

    public static <T> T[] collectionToArray(Collection<T> l, T[] a) {
        return l.toArray(a);
    }

    public static <K, V> void putAll(Map<K, V> source, Map<K, V> newItems) {
        source.putAll(newItems);
    }

    public static <T> CopyOnWriteArrayList<T> createCopyOnWriteList() {
        return new CopyOnWriteArrayList();
    }

    public static <K, V> CopyOnWriteMap<K, V> createCopyOnWriteMap() {
        return new CopyOnWriteMap();
    }

    public static <T> List<T> subList(List<T> list, int len) {
        return list.subList(0, len);
    }

    public static <T> List<T> subList(List<T> list, int from, int to) {
        return list.subList(from, to);
    }

    public static void reverse(List<?> list) {
        Collections.reverse(list);
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        Collections.sort(list);
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        Collections.sort(list, c);
    }

    public static <T> void sort(T[] list, Comparator<T> comp) {
        Arrays.sort(list, comp);
    }

    public static <T> boolean remove(List<T> list, T value) {
        return list.remove(value);
    }

    public static <T> T removeAt(List<T> list, int pos) {
        return list.remove(pos);
    }

    public static <T> String arrayToString(T[] array) {
        return Arrays.toString(array);
    }

    public static <K, V> String mapToString(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return map.toString();
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> orig) {
        return Collections.unmodifiableMap(orig);
    }

    public static <T> Set<T> unmodifiableSet(Set<T> orig) {
        return Collections.unmodifiableSet(orig);
    }

    public static <T> List<T> unmodifiableList(List<T> orig) {
        return Collections.unmodifiableList(orig);
    }

    public static boolean arrayEquals(byte[] a1, byte[] a2) {
        return Arrays.equals(a1, a2);
    }

    public static <T> boolean arrayEquals(T[] a1, T[] a2) {
        return Arrays.equals(a1, a2);
    }

    public static <T> String collectionToString(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toString();
    }

    public static <E> int getJavaAlgorithmCollectionHashCode(Collection<E> col) {
        if (col == null) {
            return 0;
        }
        if (col instanceof ADImmutableObjectList) {
            return col.hashCode();
        }
        if (col instanceof ArrayList || col instanceof Vector) {
            int result = 1;
            List l = (List)col;
            for (int i = 0; i < col.size(); ++i) {
                Object e = l.get(i);
                result = 31 * result + (e == null ? 0 : e.hashCode());
            }
            return result;
        }
        if (col.size() == 0) {
            return 0;
        }
        return col.hashCode();
    }

    public static int getJavaAlgorithmArrayHashCode(byte[] a) {
        return Arrays.hashCode(a);
    }

    public static int getJavaAlgorithmArrayHashCode(Object[] a) {
        return Arrays.hashCode(a);
    }

    public static <T, U extends T> ArrayList<T> getNewList(List<U> input) {
        return new ArrayList<U>(input);
    }

    public static <T> void addToCollection(Collection<T> col, T elem) {
        col.add(elem);
    }

    public static <K, V> Collection<V> getAllValues(ADConcurrentHashMap<K, V> map) {
        return map.values();
    }

    public static <T> Set<T> getElementsOfMaxSize(Set<T> elements, int maxNumber) {
        LinkedHashSet<T> maxIds = new LinkedHashSet<T>();
        if (maxNumber <= 0) {
            return maxIds;
        }
        for (T id : elements) {
            maxIds.add(id);
            if (--maxNumber > 0) continue;
            break;
        }
        elements.removeAll(maxIds);
        return maxIds;
    }

    public static void main(String[] args) {
        HashSet<Long> ids = new HashSet<Long>(Arrays.asList(2L, 3L));
        System.out.println(CollectionHelper.getElementsOfMaxSize(ids, 1));
        System.out.println(ids);
    }

    public static <T, U> int getJavaAlgorithmMapHashCode(Map<T, U> map) {
        if (map == null || map.size() == 0) {
            return 0;
        }
        return map.hashCode();
    }

    public static String intArrayToString(int[] intArray) {
        return Arrays.toString(intArray);
    }

    public static String longArrayToString(long[] longArray) {
        return Arrays.toString(longArray);
    }

    public static <T> Set<T> emptySerializableSet() {
        return Collections.emptySet();
    }

    public static <T> List<T> emptySerializableList() {
        return Collections.emptyList();
    }

    public static <K, V> Map<K, V> emptySerializableMap() {
        return Collections.emptyMap();
    }

    public static int calculateCaseInsensitiveValueStringVsStringMapHash(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        int result = 0;
        for (Map.Entry<String, String> next : map.entrySet()) {
            int entryHash = (next.getKey() == null ? 0 : next.getKey().hashCode()) ^ (next.getValue() == null ? 0 : next.getValue().toLowerCase().hashCode());
            result += entryHash;
        }
        return result;
    }

    public static long[] collectionToLongArray(Collection<Long> allKeys) {
        if (allKeys == null) {
            return null;
        }
        long[] values = new long[allKeys.size()];
        int count = 0;
        for (Long allKey : allKeys) {
            values[count++] = allKey;
        }
        return values;
    }

    public static Set<String> asSet(String[] names) {
        HashSet<String> set = CollectionHelper.createHashSet(names.length);
        Collections.addAll(set, names);
        return set;
    }

    public static <E> List<E> getListNoNull(List<E> list) {
        return list == null ? new ArrayList() : list;
    }

    public static boolean IsArrayListInstance(Object object) {
        return object instanceof ArrayList;
    }

    public static <E> boolean addIsAccepted(ArrayList<E> list, E e) {
        return list.add(e);
    }

    public static <T> void logElements(Collection<T> collection, ILogger logger, LogType logType, int maxElementLength) {
        for (T nextElement : collection) {
            String stringRep = nextElement.toString();
            if (maxElementLength > 0 && stringRep.length() > maxElementLength) {
                stringRep = stringRep.substring(0, maxElementLength) + "...";
            }
            switch (logType) {
                case DEBUG: {
                    logger.debug(stringRep);
                    break;
                }
                case INFO: {
                    logger.info(stringRep);
                    break;
                }
                case WARN: {
                    logger.warn(stringRep);
                    break;
                }
                case ERROR: {
                    logger.error(stringRep);
                }
            }
        }
    }

    public static enum LogType {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

