/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.clock;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ClockUtilsHelper {
    private static long currentTime = 0L;

    public static long getCurrentTime() {
        return currentTime == 0L ? System.currentTimeMillis() : currentTime;
    }

    static void setCurrentTime(long currentTimestamp) {
        if (currentTimestamp <= 0L) {
            throw new IllegalArgumentException("invalid current timestamp: " + currentTimestamp);
        }
        currentTime = currentTimestamp;
    }

    static void clearCurrentTime() {
        currentTime = 0L;
    }

    static long getTime(Date date) {
        return date.getTime();
    }

    static void getCalendarFormattedTime(StringBuilder sb) {
        Calendar calendar = Calendar.getInstance();
        sb.append(calendar.get(1)).append("_").append(calendar.get(2)).append("_");
        sb.append(calendar.get(5)).append("_AT_");
        sb.append(calendar.get(10)).append("_").append(calendar.get(12)).append("_").append(calendar.get(13)).append("_").append(calendar.get(14)).append("_");
        if (calendar.get(9) == 0) {
            sb.append("AM");
        } else {
            sb.append("PM");
        }
    }

    public static Date getDateRoundedToMinute(long timeInMillis) {
        Calendar cal = ClockUtilsHelper.getCalendar(timeInMillis);
        return cal.getTime();
    }

    public static int getMinute(long timeInMillis) {
        Calendar cal = ClockUtilsHelper.getCalendar(timeInMillis);
        return cal.get(12);
    }

    private static Calendar getCalendar(long timeInMillis) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(timeInMillis);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    static long getNanoTime() {
        return System.nanoTime();
    }

    public static Date getDateFromLong(Long timeStamp) {
        if (timeStamp == null) {
            return null;
        }
        return new Date(timeStamp);
    }

    public static Date getDateFromLong(long timeStamp) {
        return new Date(timeStamp);
    }

    public static String getTimestampStringInCurrentTimeZone(long timestamp) {
        Date date = new Date(timestamp);
        return new SimpleDateFormat().format(date);
    }

    public static long getTimeInMillisMinuteRounded(long _startTime, int minuteRounded) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(_startTime);
        cal.set(12, minuteRounded);
        cal.set(13, 0);
        cal.set(14, 0);
        _startTime = cal.getTimeInMillis();
        return _startTime;
    }

    public static long convertNanoSecstoMilliSecs(long time) {
        return TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS);
    }

    public static long convertMilliSecsToNanoSecs(long ms) {
        return TimeUnit.MILLISECONDS.toNanos(ms);
    }

    public static String millisToDefaultLocaleString(long ms) {
        return DateFormat.getDateTimeInstance().format(new Date(ms));
    }

    public static String getTimeZoneDisplayName() {
        return TimeZone.getDefault().getDisplayName();
    }
}

