/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.clock;

import com.singularity.ee.controller.api.constants.TimeRangeSpecifierType;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.util.clock.ClockUtilsHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ClockUtils {
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_A_MIN = 60000L;
    public static final IClock SYSTEM_CLOCK = new DefaultClock();

    public static Date getPreviousDayEnd(Date now, String timeZoneId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTime(now);
        calendar.add(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getPreviousDayStart(Date now, String timeZoneId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTime(now);
        calendar.add(6, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getPreviousMonthEnd(Date now, String timeZoneId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTime(now);
        calendar.set(5, 1);
        calendar.add(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getPreviousMonthStart(Date now, String timeZoneId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTime(now);
        calendar.set(5, 1);
        calendar.add(2, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getPreviousWeekEnd(Date now, String timeZoneId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTime(now);
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.add(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getPreviousWeekStart(Date now, String timeZoneId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTime(now);
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.add(3, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getPreviousTimeSpan(Date now, TimeRangeSpecifierType type, boolean isStart, String timeZoneId) {
        if (timeZoneId == null) {
            timeZoneId = ClockUtils.getDefaultServerTimeZone();
        }
        switch (type) {
            case PREV_DAY_END: {
                return isStart ? ClockUtils.getPreviousDayStart(now, timeZoneId) : ClockUtils.getPreviousDayEnd(now, timeZoneId);
            }
            case PREV_MONTH_END: {
                return isStart ? ClockUtils.getPreviousMonthStart(now, timeZoneId) : ClockUtils.getPreviousMonthEnd(now, timeZoneId);
            }
            case PREV_WEEK_END: {
                return isStart ? ClockUtils.getPreviousWeekStart(now, timeZoneId) : ClockUtils.getPreviousWeekEnd(now, timeZoneId);
            }
        }
        return null;
    }

    public static final long getNanoTime() {
        return ClockUtilsHelper.getNanoTime();
    }

    public static final long getCurrentTime() {
        return ClockUtilsHelper.getCurrentTime();
    }

    public static final void setCurrentTime(long currentTimestamp) {
        ClockUtilsHelper.setCurrentTime(currentTimestamp);
    }

    public static final void clearCurrentTime() {
        ClockUtilsHelper.clearCurrentTime();
    }

    public static final long roundUpTimestampToNextMinute(long timestamp) {
        long roundedDownToMinute = timestamp / 60000L * 60000L;
        if (timestamp == roundedDownToMinute) {
            return timestamp;
        }
        return roundedDownToMinute + 60000L;
    }

    public static final long roundDownTimestampToLastMinute(long timestamp) {
        return timestamp / 60000L * 60000L;
    }

    public static String getFormattedTime() {
        StringBuilder sb = new StringBuilder();
        ClockUtilsHelper.getCalendarFormattedTime(sb);
        return sb.toString();
    }

    public static int getElapsedMinutes(Date startTime, Date endTime) {
        long difference = ClockUtilsHelper.getTime(endTime) - ClockUtilsHelper.getTime(startTime);
        return (int)(difference / 60000L);
    }

    public static final long getTimeUntilNextHourlySyncedDurationStart(long timestamp, long durationValue) {
        long nextHour = ClockUtils.roundUpTimestampToNextHour(timestamp);
        long milliSecondsTilTopOfHour = nextHour - timestamp;
        long numWholeUnitsTilHour = milliSecondsTilTopOfHour / durationValue;
        long returnValue = nextHour - numWholeUnitsTilHour * durationValue - timestamp;
        return returnValue;
    }

    public static long getTime(Date date) {
        return ClockUtilsHelper.getTime(date);
    }

    public static final long roundUpTimestampToNextHour(long timestamp) {
        long remainder = timestamp % 3600000L;
        if (remainder == 0L) {
            return timestamp;
        }
        return timestamp + (3600000L - remainder);
    }

    public static boolean isTimeRangeEndCloseToCurrentTime(TimeRangeSpecifier trs) {
        return trs.getType() == TimeRangeSpecifierType.PREV_DAY_END && ClockUtils.getCurrentTime() - trs.getTimeRange().getEndTime().getTime() < 60000L;
    }

    public static String getDefaultServerTimeZone() {
        return TimeZone.getDefault().getID().toString();
    }

    public static class DefaultClock
    implements IClock {
        @Override
        public long getCurrentTime() {
            return ClockUtils.getCurrentTime();
        }
    }

    public static interface IClock {
        public long getCurrentTime();
    }

    public static class SimpleFixedTimeClock
    implements IClock {
        private long curTime = 0L;

        @Override
        public synchronized long getCurrentTime() {
            return this.curTime;
        }

        public synchronized void setCurTime(long curTime) {
            this.curTime = curTime;
        }
    }

    public static class SimpleIncrementingFakeClock
    implements IClock {
        private long curTime = 882424L;
        private boolean progressStop = false;

        @Override
        public synchronized long getCurrentTime() {
            if (this.progressStop) {
                return this.curTime;
            }
            return this.curTime++;
        }

        public synchronized void stopProgress() {
            this.progressStop = true;
        }

        public synchronized void startProgress() {
            this.progressStop = false;
        }

        public synchronized void pushForwardBy(long ms) {
            this.curTime += ms;
        }
    }
}

