/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events;

import com.singularity.ee.events.EventMessage;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.HashMap;
import java.util.Map;

public class EventMessageBundle {
    private static EventMessageBundle messageBundle = new EventMessageBundle();
    private static Map<EventMessage, String> eventMessages;

    private EventMessageBundle() {
        HashMap<EventMessage, String> tmpEventMessages = new HashMap<EventMessage, String>();
        tmpEventMessages.put(EventMessage.SERVER_STARTUP, "was re-started");
        tmpEventMessages.put(EventMessage.SERVER_VM_STARTUP_OPTIONS_CHANGED, "Application Server VM startup options changed");
        tmpEventMessages.put(EventMessage.SERVER_VM_SYSTEM_PROPERTIES_CHANGED, "Application Server VM system properties changed");
        tmpEventMessages.put(EventMessage.SERVER_ENV_VARS_CHANGED, "Application Server environment variables changed");
        tmpEventMessages.put(EventMessage.APP_AGENT_RESET_SUCCEEDED, "App Server Agent was reset");
        tmpEventMessages.put(EventMessage.APP_AGENT_RESET_FAILED, "App Server Agent reset failed");
        tmpEventMessages.put(EventMessage.APP_AGENT_MOVE_NODE_SUCCEEDED, "App Server Agent node was moved");
        tmpEventMessages.put(EventMessage.APP_AGENT_MOVE_NODE_FAILED, "App Server Agent node move failed");
        tmpEventMessages.put(EventMessage.MACHINE_AGENT_RESET_SUCCEEDED, "Machine Agent was reset");
        tmpEventMessages.put(EventMessage.MACHINE_AGENT_AUTO_REGISTRATION_FAILED, "Machine Agent auto registration failed");
        tmpEventMessages.put(EventMessage.MACHINE_AGENT_MOVE_NODE_SUCCEEDED, "Machine Agent node was moved");
        tmpEventMessages.put(EventMessage.MACHINE_AGENT_MOVE_NODE_FAILED, "Machine Agent node move failed");
        tmpEventMessages.put(EventMessage.CONTROLLER_EVENT_UPLOAD_LIMIT_REACHED, "Controller limited Agent event data upload");
        tmpEventMessages.put(EventMessage.CONTROLLER_RSD_UPLOAD_LIMIT_REACHED, "Controller limited App Server Agent request data upload");
        tmpEventMessages.put(EventMessage.CONTROLLER_PSD_UPLOAD_LIMIT_REACHED, "Controller limited App Server Agent process snapshot data upload");
        tmpEventMessages.put(EventMessage.CONTROLLER_METRIC_REGISTRATION_LIMIT_REACHED, "Controller limited metric registration");
        tmpEventMessages.put(EventMessage.CONTROLLER_METRIC_DATA_BUFFER_OVERFLOW, "Controller metric data buffer overflow (dropping metric data)");
        tmpEventMessages.put(EventMessage.CONTROLLER_ERROR_ADD_REG_LIMIT_REACHED, "Controller limited Error ADD registration");
        tmpEventMessages.put(EventMessage.CONTROLLER_ASYNC_ADD_REG_LIMIT_REACHED, "Controller limited Async ADD registration");
        tmpEventMessages.put(EventMessage.CONTROLLER_STACKTRACE_ADD_REG_LIMIT_REACHED, "Controller limited StackTrace ADD registration");
        tmpEventMessages.put(EventMessage.CONTROLLER_MEMORY_ADD_REG_LIMIT_REACHED, "Controller limited Memory ADD registration");
        tmpEventMessages.put(EventMessage.CONTROLLER_TRACKED_OBJECT_ADD_REG_LIMIT_REACHED, "Controller limited TrackedObject ADD registration");
        tmpEventMessages.put(EventMessage.CONTROLLER_COLLECTIONS_ADD_REG_LIMIT_REACHED, "Controller limited Collections ADD registration");
        tmpEventMessages.put(EventMessage.CONTROLLER_SEP_ADD_REG_LIMIT_REACHED, "Controller limited Service Endpoint ADD registration");
        tmpEventMessages.put(EventMessage.DEADLOCK, "JVM deadlock detected");
        tmpEventMessages.put(EventMessage.JVM_CRASHED, "JVM Crash detected");
        eventMessages = CollectionHelper.unmodifiableMap(tmpEventMessages);
    }

    public static EventMessageBundle getBundle() {
        return messageBundle;
    }

    public String getMessage(EventMessage key) {
        return eventMessages.get((Object)key);
    }
}

