/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events;

import com.singularity.ee.controller.api.constants.EventCorrelationType;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.events.EventMessage;
import com.singularity.ee.events.EventMessageBundle;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.collections.EqualsUtil;
import com.singularity.ee.util.enums.EnumHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@GenProto
public class AgentEventData
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private long timestamp;
    @FieldPosition(value=13)
    private NotificationSeverity notificationSeverity;
    @FieldPosition(value=3)
    private EventType type;
    @FieldPosition(value=4)
    private String summary;
    @FieldPosition(value=5)
    private Map<String, String> eventDetails = null;
    @FieldPosition(value=6)
    private Set<Long> errorIDs = null;
    @FieldPosition(value=7)
    private Map<String, EventCorrelationType> correlationMap = null;
    @FieldPosition(value=8)
    private boolean archived;
    @FieldPosition(value=9)
    private long endTime;
    @FieldPosition(value=10)
    private String guid;
    @FieldPosition(value=11)
    private String subType;
    @FieldPosition(value=12)
    private EntityDefinition triggeredEntity;
    @FieldPosition(value=14)
    private List<EntityDefinition> triggeredEntities;
    @FieldPosition(value=15)
    private Map<String, Object> eventProperties = null;

    public AgentEventData() {
    }

    public AgentEventData(long timestamp, NotificationSeverity notificationSeverity, EventType type, Map<String, String> eventDetails, String summary, long errorID) {
        this();
        this.timestamp = timestamp;
        this.notificationSeverity = notificationSeverity;
        this.type = type;
        this.addEventDetails(eventDetails);
        this.summary = summary;
        this.addErrorID(errorID);
    }

    public AgentEventData(long timestamp, NotificationSeverity notificationSeverity, EventType type, Map<String, String> eventDetails, String summary) {
        this();
        this.timestamp = timestamp;
        this.notificationSeverity = notificationSeverity;
        this.type = type;
        this.addEventDetails(eventDetails);
        this.summary = summary;
    }

    public AgentEventData(long timestamp, NotificationSeverity notificationSeverity, EventType type, Map<String, String> eventDetails, EventMessage message) {
        this(timestamp, notificationSeverity, type, eventDetails, EventMessageBundle.getBundle().getMessage(message));
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public void addErrorID(long errorID) {
        if (this.errorIDs == null) {
            this.errorIDs = new HashSet<Long>(1, 1.0f);
        }
        this.errorIDs.add(errorID);
    }

    public void addErrorID(Set<Long> errorIDs) {
        if (this.errorIDs == null) {
            this.errorIDs = new HashSet<Long>(errorIDs);
        } else {
            this.errorIDs.addAll(errorIDs);
        }
    }

    public Set<Long> getErrorIDs() {
        if (this.errorIDs == null) {
            return CollectionHelper.emptySerializableSet();
        }
        return this.errorIDs;
    }

    public void setErrorIDs(Set<Long> errorIDs) {
        this.errorIDs = errorIDs;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public NotificationSeverity getNotificationSeverity() {
        return this.notificationSeverity;
    }

    public void setNotificationSeverity(NotificationSeverity notificationSeverity) {
        this.notificationSeverity = notificationSeverity;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public Map<String, String> getEventDetails() {
        if (this.eventDetails == null) {
            return CollectionHelper.emptySerializableMap();
        }
        return this.eventDetails;
    }

    public void setEventDetails(Map<String, String> map) {
        if (map != null) {
            if (this.eventDetails == null) {
                this.eventDetails = new HashMap<String, String>(map);
            } else {
                this.eventDetails.putAll(map);
            }
        }
    }

    public void addEventDetail(String name, String value) {
        if (this.eventDetails == null) {
            this.eventDetails = new HashMap<String, String>(1, 1.0f);
        }
        this.eventDetails.put(name, value);
    }

    public void addEventDetails(Map<String, String> map) {
        if (map != null) {
            if (this.eventDetails == null) {
                this.eventDetails = new HashMap<String, String>(map);
            } else {
                this.eventDetails.putAll(map);
            }
        }
    }

    public void addEventProperty(String name, String value) {
        if (this.eventProperties == null) {
            this.eventProperties = new HashMap<String, Object>(1, 1.0f);
        }
        this.eventProperties.put(name, value);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Map<String, EventCorrelationType> getCorrelationMap() {
        if (this.correlationMap == null) {
            return CollectionHelper.emptySerializableMap();
        }
        return this.correlationMap;
    }

    public void setCorrelationMap(Map<String, EventCorrelationType> correlationMap) {
        this.correlationMap = correlationMap;
    }

    public void addCorrelationID(String correlationID, EventCorrelationType type) {
        if (this.correlationMap == null) {
            this.correlationMap = new HashMap<String, EventCorrelationType>(1, 1.0f);
        }
        this.correlationMap.put(correlationID, type);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        if (this.notificationSeverity != null) {
            result = 37 * result + EnumHelper.getHashCode(this.notificationSeverity);
        }
        if (this.type != null) {
            result = 37 * result + EnumHelper.getHashCode(this.type);
        }
        result = 37 * result + CollectionHelper.getJavaAlgorithmMapHashCode(this.eventDetails);
        if (this.summary != null) {
            result = 37 * result + this.summary.hashCode();
        }
        result = 37 * result + CollectionHelper.getJavaAlgorithmCollectionHashCode(this.errorIDs);
        result = 37 * result + CollectionHelper.getJavaAlgorithmMapHashCode(this.correlationMap);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AgentEventData)) {
            return false;
        }
        AgentEventData other = (AgentEventData)obj;
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getNotificationSeverity() != other.getNotificationSeverity()) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (!EqualsUtil.safeCompareMaps(this.getEventDetails(), other.getEventDetails())) {
            return false;
        }
        if (!EqualsUtil.safeCompareStrings(this.getSummary(), other.getSummary())) {
            return false;
        }
        if (!EqualsUtil.safeCompareCollections(this.getErrorIDs(), other.getErrorIDs())) {
            return false;
        }
        return EqualsUtil.safeCompareMaps(this.getCorrelationMap(), other.getCorrelationMap());
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public EntityDefinition getTriggeredEntity() {
        return this.triggeredEntity;
    }

    public void setTriggeredEntity(EntityDefinition triggeredEntity) {
        this.triggeredEntity = triggeredEntity;
    }

    public List<EntityDefinition> getTriggeredEntities() {
        return this.triggeredEntities;
    }

    public void setTriggeredEntities(List<EntityDefinition> triggeredEntities) {
        this.triggeredEntities = triggeredEntities;
    }

    public Map<String, Object> getEventProperties() {
        return this.eventProperties;
    }

    public void setEventProperties(Map<String, Object> eventProperties) {
        this.eventProperties = eventProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Agent Event Type").append("[").append((Object)this.getType()).append("]").append("\n");
        sb.append("Occurred at Time").append("[").append(this.getTimestamp()).append("]").append("\n");
        sb.append("Summary").append("[").append(this.getSummary()).append("]").append("\n");
        sb.append("Severity").append("[").append((Object)this.getNotificationSeverity()).append("]").append("\n");
        sb.append("Event Details").append("[").append(CollectionHelper.mapToString(this.getEventDetails())).append("]").append("\n");
        sb.append("Error IDs").append("[").append(CollectionHelper.collectionToString(this.getErrorIDs())).append("]").append("\n");
        sb.append("Correlation Map").append("[").append(CollectionHelper.mapToString(this.getCorrelationMap())).append("]").append("\n");
        sb.append("EventProperties").append("[").append(CollectionHelper.mapToString(this.getEventProperties())).append("]").append("\n");
        return sb.toString();
    }
}

