/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.util;

import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.util.string.StringRegexOperations;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class NameValuePairConverter {
    public static final String NAME_VALUE_SEPARATOR = ";";
    private final String separator;
    public static final NameValuePairConverter DEFAULT_CONVERTER = new NameValuePairConverter();

    public NameValuePairConverter() {
        this(NAME_VALUE_SEPARATOR);
    }

    public NameValuePairConverter(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        throw new UnsupportedOperationException("set the separator in the constructor");
    }

    public String convertToStringFormat(NameValuePair[] pairs) {
        if (pairs == null || pairs.length == 0) {
            return null;
        }
        StringBuilder stringFormat = new StringBuilder();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (NameValuePair nameValue : pairs) {
            String name = nameValue.getName();
            String value = nameValue.getValue();
            if (this.isBlank(name)) {
                throw new IllegalArgumentException("Name is not specified");
            }
            if (name.contains(this.separator)) {
                throw new IllegalArgumentException("Name cannot contain " + this.separator);
            }
            if (!uniqueNames.add(name)) {
                throw new IllegalArgumentException(name + " is already present");
            }
            if (this.isBlank(value)) {
                throw new IllegalArgumentException("Value is not specified for property " + name);
            }
            if (value.contains(this.separator)) {
                throw new IllegalArgumentException("Value cannot contain " + this.separator);
            }
            stringFormat.append(name).append(this.separator).append(value).append(this.separator);
        }
        return stringFormat.toString();
    }

    public Map<String, String> parseNameValuePairsAsMap(String nameValuesStr) {
        HashMap<String, String> nameValuePairs = new HashMap<String, String>();
        if (nameValuesStr == null) {
            return nameValuePairs;
        }
        String[] nameValues = StringRegexOperations.split(nameValuesStr, this.separator);
        for (int i = 0; i < nameValues.length; i += 2) {
            nameValuePairs.put(nameValues[i], nameValues[i + 1]);
        }
        return nameValuePairs;
    }

    public NameValuePair[] parseNameValuePairs(String nameValuesStr) {
        if (nameValuesStr == null || nameValuesStr.length() == 0) {
            return new NameValuePair[0];
        }
        String[] nameValues = StringRegexOperations.split(nameValuesStr, this.separator);
        NameValuePair[] nameValuePairs = new NameValuePair[nameValues.length / 2];
        for (int i = 0; i < nameValues.length; i += 2) {
            nameValuePairs[i / 2] = new NameValuePair(nameValues[i], nameValues[i + 1]);
        }
        return nameValuePairs;
    }

    private boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

