/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transientoperations;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.CustomMatchPointDefinition;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionMatchPointConfig;
import com.singularity.ee.controller.api.dto.transientoperations.ITransientOperationParameters;
import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UiCodeGen
@TSCodeGen(exclude=true)
public class TransientBTDiscoveryConfig
implements ITransientOperationParameters {
    private static final long serialVersionUID = 1L;
    private String transientBTSessionId;
    private TransactionMatchPointConfig[] configurations;
    private transient Map<String, TransactionMatchPointConfig> configMap;
    private transient List<TransactionMatchPointConfig> configList = new ArrayList<TransactionMatchPointConfig>();
    private transient String transientBTSessionOpId;

    public TransientBTDiscoveryConfig() {
    }

    public TransientBTDiscoveryConfig(TransactionMatchPointConfig[] configurations) {
        this.configurations = configurations;
    }

    public TransactionMatchPointConfig[] getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(TransactionMatchPointConfig[] configurations) {
        this.configurations = configurations;
    }

    public List<TransactionMatchPointConfig> getConfigList() {
        return this.configList;
    }

    public void addTransactionMatchPointConfig(TransactionMatchPointConfig config) {
        this.configList.add(config);
    }

    public void setConfigList(List<TransactionMatchPointConfig> configList) {
        this.configList = configList;
    }

    public void updateTransactionMatchPointConfig(TransactionMatchPointConfig update) {
    }

    public TransientBTDiscoveryConfig toDTO(TransientBTDiscoveryConfig config) {
        TransientBTDiscoveryConfig result = new TransientBTDiscoveryConfig();
        result.configurations = new TransactionMatchPointConfig[0];
        if (config.configList.size() != 0) {
            TransactionMatchPointConfig[] configurations = new TransactionMatchPointConfig[config.configList.size()];
            for (int i = 0; i < config.configList.size(); ++i) {
                configurations[i] = config.configList.get(i).toDTO();
            }
            result.configurations = configurations;
        }
        return result;
    }

    public String getTransientBTSessionId() {
        return this.transientBTSessionId;
    }

    public void setTransientBTSessionId(String transientBTSessionId) {
        this.transientBTSessionId = transientBTSessionId;
    }

    public synchronized void initializeConfigMap() {
        if (null == this.configMap) {
            this.configMap = new HashMap<String, TransactionMatchPointConfig>();
            for (int i = 0; i < this.configurations.length; ++i) {
                TransactionMatchPointConfig config = this.configurations[i];
                ArrayList<CustomMatchPointDefinition> customDefs = config.getCustomMatchPointDefinitionsAsArrayList();
                CollectionHelper.sort(customDefs, new TransactionMatchPointConfig.CustomMatchPointDefinitionComparator());
                config.setCustomDefinitions(customDefs);
                this.configMap.put(config.getEntryPointTypeString(), config);
            }
        }
    }

    public Map<String, TransactionMatchPointConfig> getConfigMap() {
        this.initializeConfigMap();
        return this.configMap;
    }

    public String getTransientBTSessionOpId() {
        return this.transientBTSessionOpId;
    }

    public void setTransientBTSessionOpId(String transientBTSessionOpId) {
        this.transientBTSessionOpId = transientBTSessionOpId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientBTDiscoveryConfig that = (TransientBTDiscoveryConfig)o;
        return CollectionHelper.arrayEquals(this.configurations, that.configurations);
    }

    public int hashCode() {
        return this.configurations != null ? ArrayUtils.getHashCode(this.configurations) : 0;
    }

    public String toString() {
        return "TransientBTDiscoveryConfig{configurations=" + ArrayUtils.arrayFriendlyToString(this.configurations) + ", configList=" + this.configList + ", opId=" + this.transientBTSessionOpId + '}';
    }
}

