/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.UnresolvedBackendCallInfo;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class TransactionFlowItemIdentifier
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=1)
    private long componentId;
    @FieldPosition(value=2)
    private long unresolvedBackendCallId;
    @FieldPosition(value=3)
    private boolean componentIdentifier;
    @FieldPosition(value=4)
    private EntityDefinition entityDefinition;

    public TransactionFlowItemIdentifier(long componentId) {
        this(componentId, true);
    }

    public TransactionFlowItemIdentifier(long id, boolean isComponentIdentifier) {
        if (isComponentIdentifier) {
            this.componentId = id;
            this.componentIdentifier = true;
        } else {
            this.unresolvedBackendCallId = id;
            this.componentIdentifier = false;
        }
    }

    public TransactionFlowItemIdentifier(EntityDefinition entityDefinition) {
        this.entityDefinition = entityDefinition;
        this.componentIdentifier = false;
        if (entityDefinition.getEntityType() == EntityType.APPLICATION_COMPONENT) {
            this.componentId = entityDefinition.getEntityId();
            this.componentIdentifier = true;
        } else if (entityDefinition.getEntityType() == EntityType.BACKEND) {
            this.unresolvedBackendCallId = entityDefinition.getEntityId();
        }
    }

    public TransactionFlowItemIdentifier(TransactionFlowItemIdentifier identifier) {
        this.componentId = identifier.componentId;
        this.componentIdentifier = identifier.componentIdentifier;
        this.unresolvedBackendCallId = identifier.unresolvedBackendCallId;
        if (identifier.entityDefinition != null) {
            EntityDefinition ed = identifier.entityDefinition;
            this.entityDefinition = new EntityDefinition(ed.getEntityType(), ed.getEntityId());
        }
    }

    public TransactionFlowItemIdentifier copy() {
        return new TransactionFlowItemIdentifier(this);
    }

    public TransactionFlowItemIdentifier() {
    }

    public long getComponentId() {
        return this.componentId;
    }

    public void setComponentId(long componentId) {
        this.componentId = componentId;
    }

    public long getUnresolvedBackendCallId() {
        return this.unresolvedBackendCallId;
    }

    public void setUnresolvedBackendCallId(long unresolvedBackendCallId) {
        this.unresolvedBackendCallId = unresolvedBackendCallId;
    }

    public boolean isComponentIdentifier() {
        return this.componentIdentifier;
    }

    public void setComponentIdentifier(boolean componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
    }

    public int hashCode() {
        if (this.entityDefinition != null) {
            return APersistentObject.calculateHashCode(this.entityDefinition);
        }
        if (this.componentIdentifier) {
            return APersistentObject.calculateHashCode(this.componentIdentifier, this.componentId);
        }
        return APersistentObject.calculateHashCode(this.componentIdentifier, this.unresolvedBackendCallId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionFlowItemIdentifier)) {
            return false;
        }
        TransactionFlowItemIdentifier identifier = (TransactionFlowItemIdentifier)obj;
        if (this.entityDefinition != null) {
            return this.entityDefinition.equals(identifier.entityDefinition);
        }
        if (this.componentIdentifier != identifier.componentIdentifier) {
            return false;
        }
        if (this.componentIdentifier) {
            return this.componentId == identifier.componentId;
        }
        return this.unresolvedBackendCallId == identifier.unresolvedBackendCallId;
    }

    public String toString() {
        if (this.entityDefinition != null) {
            return this.toStringFromEntityDefinition();
        }
        return this.toMetricNodeString();
    }

    private String toStringFromEntityDefinition() {
        EntityType entityType = this.entityDefinition.getEntityType();
        long entityId = this.entityDefinition.getEntityId();
        if (entityType == EntityType.APPLICATION_COMPONENT) {
            return String.valueOf(entityId);
        }
        String prefix = entityType.toString();
        if (entityType == EntityType.FEDERATED_APPLICATION) {
            prefix = "ExApp";
        } else if (entityType == EntityType.FEDERATED_COMPONENT) {
            prefix = "ExComp";
        }
        return prefix + ":" + entityId;
    }

    public String toMetricNodeString() {
        if (this.componentIdentifier) {
            return String.valueOf(this.componentId);
        }
        UnresolvedBackendCallInfo unresolvedBackendCallInfo = new UnresolvedBackendCallInfo(this.unresolvedBackendCallId);
        return unresolvedBackendCallInfo.toUnresolvedString();
    }

    public EntityDefinition getEntityDefinition() {
        if (this.entityDefinition != null) {
            return this.entityDefinition;
        }
        if (this.isComponentIdentifier()) {
            return new EntityDefinition(EntityType.APPLICATION_COMPONENT, this.getComponentId());
        }
        return new EntityDefinition(EntityType.BACKEND, this.getUnresolvedBackendCallId());
    }

    public void setEntityDefinition(EntityDefinition entityDefinition) {
        this.entityDefinition = entityDefinition;
    }

    public boolean isUnresolvedBackendIdentifier() {
        return !this.isComponentIdentifier() && this.entityDefinition == null;
    }

    public EntityType getEntityType() {
        if (this.entityDefinition != null) {
            return this.entityDefinition.getEntityType();
        }
        if (this.isComponentIdentifier()) {
            return EntityType.APPLICATION_COMPONENT;
        }
        return EntityType.BACKEND;
    }

    public long getEntityId() {
        if (this.entityDefinition != null) {
            return this.entityDefinition.getEntityId();
        }
        if (this.isComponentIdentifier()) {
            return this.getComponentId();
        }
        return this.getUnresolvedBackendCallId();
    }
}

