/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.ExtendedStringMatchTypes;
import com.singularity.ee.controller.api.dto.Auditing;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.StringMatchType;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.spi.IStringTokenizer;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.string.StringRegexOperations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class StringMatch
implements SingularitySerializable,
Auditing {
    @IgnoreProtoGen
    public static final transient String APPDYNAMICS_NULL = "_null_appd_null_";
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @IgnoreProtoGen
    public static final String INLIST_DELIMITER = ",";
    @IgnoreProtoGen
    public static final StringMatch ALWAYS_MATCH = new StringMatch(true);
    @FieldPosition(value=2)
    private StringMatchType matchType;
    @FieldPosition(value=3)
    private String matchPattern;
    @FieldPosition(value=4)
    private boolean inverse;
    @FieldPosition(value=5)
    private String[] inList;
    @IgnoreProtoGen
    private transient boolean alwaysMatch;
    @IgnoreProtoGen
    private transient Pattern regexPattern;
    @IgnoreProtoGen
    private transient Set<String> inListSet = null;
    @FieldPosition(value=7)
    private String extendedMatchType;
    @FieldPosition(value=8)
    private String extendedMatchPattern;
    @FieldPosition(value=9)
    int[] regexGroups;
    @IgnoreProtoGen
    private transient int[] intMatchPattern;
    @IgnoreProtoGen
    private transient boolean caseInsensitive;

    public StringMatch() {
    }

    private StringMatch(boolean alwaysMatch) {
        this.alwaysMatch = alwaysMatch;
    }

    public StringMatch(StringMatchType matchType, String matchPattern) {
        this(EnumHelper.getName(matchType, matchType), matchPattern);
        this.setMatchType(matchType);
        this.setMatchPattern(matchPattern);
    }

    public StringMatch(String matchType, String matchPattern) {
        this.setExtendedMatchType(matchType);
        this.setExtendedMatchPattern(matchPattern);
    }

    public StringMatch(StringMatchType matchType, String matchString, boolean inverse) {
        this(matchType, matchString);
        this.inverse = inverse;
    }

    public StringMatch deepCopy() {
        StringMatch copy = new StringMatch();
        copy.setMatchType(this.getMatchType());
        copy.setMatchPattern(this.getMatchPattern());
        copy.setInverse(this.isInverse());
        copy.setExtendedMatchType(this.getExtendedMatchType());
        copy.setExtendedMatchPattern(this.getExtendedMatchPattern());
        copy.setRegexGroups(this.getRegexGroups());
        copy.setCaseInsensitive(this.isCaseInsensitive());
        String[] inList = this.getInList();
        if (inList != null) {
            ArrayList<String> copyInList = new ArrayList<String>();
            for (String inStr : inList) {
                copyInList.add(inStr);
            }
            copy.setInList(CollectionHelper.collectionToArray(copyInList, new String[copyInList.size()]));
        }
        return copy;
    }

    public StringMatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(StringMatchType matchType) {
        this.matchType = matchType;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public void setMatchPattern(String matchPattern) {
        if (this.matchType == StringMatchType.REGEX) {
            this.regexPattern = Pattern.compile(matchPattern);
        }
        if (this.matchType == StringMatchType.INLIST) {
            IStringTokenizer tokenizer = StringOperations.createStringTokenizer(matchPattern, INLIST_DELIMITER);
            this.inList = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.inList[i++] = tokenizer.nextToken().trim();
            }
        }
        this.matchPattern = matchPattern;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean equals(Object o) {
        if (o == null && !this.matchType.equals((Object)StringMatchType.NOT_EMPTY)) {
            return true;
        }
        if (!(o instanceof StringMatch)) {
            return false;
        }
        StringMatch other = (StringMatch)o;
        if (this.extendedMatchPattern != null ? other.extendedMatchPattern == null || !this.extendedMatchPattern.equals(other.extendedMatchPattern) : other.extendedMatchPattern != null) {
            return false;
        }
        if (this.extendedMatchType != null ? other.extendedMatchType == null || !this.extendedMatchType.equals(other.extendedMatchType) : other.extendedMatchType != null) {
            return false;
        }
        if (this.caseInsensitive != other.caseInsensitive) {
            return false;
        }
        return this.inverse == other.isInverse();
    }

    public static boolean safeEquals(StringMatch match1, StringMatch match2) {
        if (match1 == null) {
            return match2 == null;
        }
        return match2 == null ? false : match1.equals(match2);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.extendedMatchType == null ? -1 : this.extendedMatchType.hashCode());
        result = 37 * result + Boolean.valueOf(this.inverse).hashCode();
        result = 37 * result + (this.extendedMatchPattern == null ? -1 : this.extendedMatchPattern.hashCode());
        result = 37 * result + Boolean.valueOf(this.caseInsensitive).hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SM");
        if (this.extendedMatchType != null) {
            sb.append("{ex_type=").append(this.extendedMatchType);
            sb.append(", ex_pattern='").append(this.extendedMatchPattern).append('\'');
        }
        if (this.matchType != null) {
            sb.append(", type=").append((Object)this.matchType);
            sb.append(", pattern='").append(this.matchPattern).append('\'');
        }
        if (this.inverse) {
            sb.append(", inverse=").append(this.inverse);
        }
        if (this.caseInsensitive) {
            sb.append(", caseInsensitive=").append(this.caseInsensitive);
        }
        if (this.inList != null) {
            sb.append(", inList=").append(CollectionHelper.asList(this.inList).toString());
        }
        if (this.alwaysMatch) {
            sb.append(", alwaysMatch=").append(this.alwaysMatch);
        }
        if (this.regexPattern != null) {
            sb.append(", regexPattern=").append(this.regexPattern);
        }
        if (this.regexGroups != null) {
            sb.append(", regexGroups=").append(CollectionHelper.intArrayToString(this.regexGroups));
        }
        if (this.intMatchPattern != null) {
            sb.append(", intMatchPattern=").append(CollectionHelper.intArrayToString(this.parseIntMatchPattern()));
        }
        sb.append('}');
        return sb.toString();
    }

    public String[] getInList() {
        return this.inList;
    }

    public void setInList(String[] inList) {
        this.inList = inList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchString(String inputString) {
        boolean match;
        if (this.alwaysMatch) {
            return true;
        }
        if (this.extendedMatchType != null && ExtendedStringMatchTypes.isExtendedStringMatchType(this.extendedMatchType)) {
            if (inputString == null) {
                match = false;
            } else if (this.extendedMatchType.equals("RANGE")) {
                match = this.matchRange(inputString);
            } else if (this.extendedMatchType.equals("LE")) {
                match = this.matchLessThan(inputString, true);
            } else if (this.extendedMatchType.equals("LT")) {
                match = this.matchLessThan(inputString, false);
            } else if (this.extendedMatchType.equals("GE")) {
                match = this.matchGreaterThan(inputString, true);
            } else if (this.extendedMatchType.equals("GT")) {
                match = this.matchGreaterThan(inputString, false);
            } else {
                if (!this.extendedMatchType.equals("REGEX_VALUE")) throw new IllegalStateException("Extended match type " + (Object)((Object)this.matchType) + " not supported");
                match = this.regexPattern.matcher(inputString).matches();
            }
        } else {
            if (this.matchType == null && this.extendedMatchType != null) {
                this.matchType = EnumHelper.getEnum(StringMatchType.class, this.extendedMatchType);
            }
            if (this.matchPattern == null && this.extendedMatchPattern != null) {
                this.matchPattern = this.extendedMatchPattern;
            }
            if (this.matchType != StringMatchType.NOT_EMPTY && this.matchPattern == null) {
                return false;
            }
            if (inputString == null) {
                match = false;
            } else {
                switch (this.matchType) {
                    case STARTSWITH: {
                        match = this.matchStartsWith(inputString);
                        break;
                    }
                    case ENDSWITH: {
                        match = this.matchEndsWith(inputString);
                        break;
                    }
                    case CONTAINS: {
                        match = this.matchContains(inputString);
                        break;
                    }
                    case EQUALS: {
                        match = this.matchEquals(inputString);
                        break;
                    }
                    case REGEX: {
                        match = this.matchRegex(inputString);
                        break;
                    }
                    case INLIST: {
                        match = this.matchInList(inputString);
                        break;
                    }
                    case NOT_EMPTY: {
                        match = this.checkIfNotEmptyWithoutNullCheck(inputString);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("String match type " + (Object)((Object)this.matchType) + " not supported");
                    }
                }
            }
        }
        if (!this.inverse) return match;
        if (match) return false;
        return true;
    }

    private boolean checkIfNotEmptyWithoutNullCheck(String inputString) {
        return inputString.length() != 0;
    }

    public StringBuilder processRegexpGroups(String value, String mergeString) {
        if (this.isRegexpValueMatch()) {
            StringBuilder buffer = new StringBuilder();
            this.processRegexpGroups(value, mergeString, buffer);
            return buffer;
        }
        return null;
    }

    public void processRegexpGroups(String value, String mergeString, StringBuilder buffer) {
        Matcher matcher;
        if (this.isRegexpValueMatch() && (matcher = this.regexPattern.matcher(value)).matches()) {
            if (buffer == null) {
                buffer = new StringBuilder();
            }
            int highGroupCount = matcher.groupCount();
            for (int i = 0; i < this.regexGroups.length; ++i) {
                int groupNum = this.regexGroups[i];
                if (groupNum > highGroupCount) continue;
                buffer.append(matcher.group(groupNum));
                if (i >= this.regexGroups.length - 1) continue;
                buffer.append(mergeString);
            }
        }
    }

    private boolean isRegexpValueMatch() {
        return this.regexGroups != null && this.regexGroups.length > 0;
    }

    private boolean matchGreaterThan(String inputString, boolean orEquals) {
        int[] intMatchPattern = this.parseIntMatchPattern();
        try {
            if (!orEquals) {
                return Integer.parseInt(inputString) > intMatchPattern[0];
            }
            return Integer.parseInt(inputString) >= intMatchPattern[0];
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean matchLessThan(String inputString, boolean orEquals) {
        int[] intMatchPattern = this.parseIntMatchPattern();
        try {
            if (!orEquals) {
                return Integer.parseInt(inputString) < intMatchPattern[0];
            }
            return Integer.parseInt(inputString) <= intMatchPattern[0];
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean matchRange(String inputString) {
        int[] intMatchPattern = this.parseIntMatchPattern();
        try {
            int value = Integer.parseInt(inputString);
            return value >= intMatchPattern[0] && value <= intMatchPattern[1];
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean matchStartsWith(String inputString) {
        if (this.caseInsensitive) {
            return inputString.toLowerCase().startsWith(this.matchPattern.toLowerCase());
        }
        return inputString.startsWith(this.matchPattern);
    }

    private boolean matchEndsWith(String inputString) {
        if (this.caseInsensitive) {
            return inputString.toLowerCase().endsWith(this.matchPattern.toLowerCase());
        }
        return inputString.endsWith(this.matchPattern);
    }

    private boolean matchContains(String inputString) {
        if (this.caseInsensitive) {
            return inputString.toLowerCase().contains(this.matchPattern.toLowerCase());
        }
        return inputString.contains(this.matchPattern);
    }

    private boolean matchEquals(String inputString) {
        if (this.caseInsensitive) {
            return this.matchPattern.equalsIgnoreCase(inputString);
        }
        return this.matchPattern.equals(inputString);
    }

    private boolean matchRegex(String inputString) {
        if (this.regexPattern == null) {
            this.regexPattern = this.caseInsensitive ? Pattern.compile(this.matchPattern, 2) : Pattern.compile(this.matchPattern);
        }
        if (this.caseInsensitive) {
            return StringRegexOperations.regexFind(this.regexPattern, inputString.toLowerCase());
        }
        return StringRegexOperations.regexFind(this.regexPattern, inputString);
    }

    private boolean matchInList(String inputString) {
        if (this.inListSet == null) {
            HashSet<String> inListSetLocal = new HashSet<String>();
            if (this.caseInsensitive) {
                for (String val : this.inList) {
                    inListSetLocal.add(val.toLowerCase());
                }
            } else {
                CollectionHelper.addAll(inListSetLocal, this.inList);
            }
            this.inListSet = inListSetLocal;
        }
        if (this.caseInsensitive) {
            return this.inListSet.contains(inputString.toLowerCase());
        }
        return this.inListSet.contains(inputString);
    }

    public static boolean safeEquals(StringMatch[] methodMatchData1, StringMatch[] methodMatchData2) {
        if (methodMatchData1 == null) {
            return methodMatchData2 == null;
        }
        if (methodMatchData2 == null) {
            return false;
        }
        if (methodMatchData1.length != methodMatchData2.length) {
            return false;
        }
        for (int i = 0; i < methodMatchData1.length; ++i) {
            if (StringMatch.safeEquals(methodMatchData1[i], methodMatchData2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyPattern(String matchPattern) {
        return matchPattern == null || matchPattern.trim().length() == 0;
    }

    public static boolean isEmpty(StringMatch match) {
        return match == null || StringMatch.isEmptyPattern(match.getMatchPattern()) && match.getMatchType() != StringMatchType.NOT_EMPTY;
    }

    public String getExtendedMatchType() {
        return this.extendedMatchType;
    }

    public void setExtendedMatchType(String extendedMatchType) {
        this.extendedMatchType = extendedMatchType;
        if (extendedMatchType == null) {
            return;
        }
        if (!ExtendedStringMatchTypes.isExtendedStringMatchType(extendedMatchType)) {
            this.matchType = EnumHelper.getEnum(StringMatchType.class, extendedMatchType);
            if (this.extendedMatchPattern != null) {
                this.matchPattern = this.extendedMatchPattern;
            }
        }
    }

    public int[] getRegexGroups() {
        return this.regexGroups;
    }

    public void setRegexGroups(int[] regexGroups) {
        this.regexGroups = regexGroups;
    }

    public String getExtendedMatchPattern() {
        return this.extendedMatchPattern;
    }

    public void setExtendedMatchPattern(String extendedMatchPattern) {
        this.extendedMatchPattern = extendedMatchPattern;
        if (extendedMatchPattern == null) {
            return;
        }
        if (!ExtendedStringMatchTypes.isExtendedStringMatchType(this.extendedMatchType)) {
            this.matchPattern = extendedMatchPattern;
        }
        if (this.extendedMatchType == null) {
            return;
        }
        if (this.extendedMatchType.equals("REGEX") || this.extendedMatchType.equals("REGEX_VALUE")) {
            this.regexPattern = Pattern.compile(extendedMatchPattern);
        } else if (this.extendedMatchType.equals("INLIST")) {
            IStringTokenizer tokenizer = StringOperations.createStringTokenizer(extendedMatchPattern, INLIST_DELIMITER);
            this.inList = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.inList[i++] = tokenizer.nextToken().trim();
            }
        } else if (this.extendedMatchType.equals("RANGE") || this.extendedMatchType.equals("LT") || this.extendedMatchType.equals("LE") || this.extendedMatchType.equals("GT") || this.extendedMatchType.equals("GE")) {
            this.parseIntMatchPattern();
        }
    }

    public int[] parseIntMatchPattern() {
        if (this.intMatchPattern == null && this.extendedMatchType != null) {
            int[] lintMatchPattern;
            if (this.extendedMatchType.equals("RANGE")) {
                String[] split = StringRegexOperations.split(this.extendedMatchPattern, "-", 2);
                lintMatchPattern = new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1])};
            } else {
                lintMatchPattern = new int[]{Integer.parseInt(this.extendedMatchPattern)};
            }
            this.intMatchPattern = lintMatchPattern;
            return lintMatchPattern;
        }
        return this.intMatchPattern;
    }

    @Override
    public Map<String, Object> toAuditMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (this.extendedMatchType != null) {
            map.put("ex_type", this.extendedMatchType);
            map.put("ex_pattern", this.extendedMatchPattern);
        }
        if (this.matchType != null) {
            map.put("type", (Object)this.matchType);
            map.put("pattern", this.matchPattern);
        }
        map.put("inverse", this.inverse);
        if (this.inList != null) {
            map.put("inList", CollectionHelper.asList(this.inList).toString());
        }
        map.put("alwaysMatch", this.alwaysMatch);
        if (this.regexPattern != null) {
            map.put("regexPattern", this.regexPattern);
        }
        if (this.regexGroups != null) {
            map.put("regexGroups", CollectionHelper.intArrayToString(this.regexGroups));
        }
        if (this.intMatchPattern != null) {
            map.put("intMatchPattern", CollectionHelper.intArrayToString(this.parseIntMatchPattern()));
        }
        return map;
    }
}

