/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class SnapshotCollectionPolicy
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @IgnoreProtoGen
    public static final int MAX_SNAPSHOTS_TO_COLLECT_PER_MINUTE = 10;
    @IgnoreProtoGen
    public static final int MAX_SNAPSHOT_COLLECTION_DURATION_IN_MINUTES = 10;
    @IgnoreProtoGen
    public static final int MAX_ATTEMPTS_FOR_OUTLIERS_ON_SLA_VIOLATION = 100;
    @IgnoreProtoGen
    public static final int DEFAULT_MAX_ATTEMPTS_FOR_OUTLIERS_ON_SLA_VIOLATION = 20;
    @FieldPosition(value=2)
    private boolean collectingOnDemandSnapshots;
    @FieldPosition(value=3)
    private int onDemandSnapshotCollectionDurationInMinutes;
    @FieldPosition(value=4)
    private int onDemandSnapshotCollectionRemainingDurationInMinutes;
    @FieldPosition(value=5)
    private int numberOfOnDemandSnapshotsToCollect;
    @FieldPosition(value=6)
    private boolean collectSnapshotOnSLAViolationEnabled;
    @FieldPosition(value=7)
    private boolean onWarningThresholdViolation;
    @FieldPosition(value=8)
    private boolean collectOutliersOnlyOnSLAViolation;
    @FieldPosition(value=9)
    private int maxAttemptsForOutliersOnSLAViolation;
    @FieldPosition(value=10)
    private int onSLAViolationSnapshotCollectionDurationInMinutes;
    @FieldPosition(value=11)
    private int numberOfSnapshotsToCollectOnSLAViolation;
    @FieldPosition(value=12)
    private boolean occuranceSnapshotCollectionEnabled;
    @FieldPosition(value=13)
    private int nthOccurance;
    @FieldPosition(value=14)
    private boolean collectSnapshotForEveryNMinutesEnabled;
    @FieldPosition(value=15)
    private int minuteFrequency;
    @FieldPosition(value=16)
    private boolean automaticCollectionEnabled;
    @FieldPosition(value=17)
    private int automaticSlowVolumePercentageThreshold;
    @FieldPosition(value=18)
    private int automaticErrorVolumePercentageThreshold;

    public boolean isCollectingOnDemandSnapshots() {
        return this.collectingOnDemandSnapshots;
    }

    public void setCollectingOnDemandSnapshots(boolean collectingOnDemandSnapshots) {
        this.collectingOnDemandSnapshots = collectingOnDemandSnapshots;
    }

    public int getOnDemandSnapshotCollectionDurationInMinutes() {
        return this.onDemandSnapshotCollectionDurationInMinutes;
    }

    public void setOnDemandSnapshotCollectionDurationInMinutes(int onDemandSnapshotCollectionDurationInMinutes) {
        this.onDemandSnapshotCollectionDurationInMinutes = onDemandSnapshotCollectionDurationInMinutes;
    }

    public int getNumberOfOnDemandSnapshotsToCollect() {
        return this.numberOfOnDemandSnapshotsToCollect;
    }

    public void setNumberOfOnDemandSnapshotsToCollect(int numberOfOnDemandSnapshotsToCollect) {
        this.numberOfOnDemandSnapshotsToCollect = numberOfOnDemandSnapshotsToCollect;
    }

    public int getOnSLAViolationSnapshotCollectionDurationInMinutes() {
        return this.onSLAViolationSnapshotCollectionDurationInMinutes;
    }

    public void setOnSLAViolationSnapshotCollectionDurationInMinutes(int onSLAViolationSnapshotCollectionDurationInMinutes) {
        this.onSLAViolationSnapshotCollectionDurationInMinutes = onSLAViolationSnapshotCollectionDurationInMinutes;
    }

    public int getNumberOfSnapshotsToCollectOnSLAViolation() {
        return this.numberOfSnapshotsToCollectOnSLAViolation;
    }

    public void setNumberOfSnapshotsToCollectOnSLAViolation(int numberOfSnapshotsToCollectOnSLAViolation) {
        this.numberOfSnapshotsToCollectOnSLAViolation = numberOfSnapshotsToCollectOnSLAViolation;
    }

    public boolean isCollectSnapshotOnSLAViolationEnabled() {
        return this.collectSnapshotOnSLAViolationEnabled;
    }

    public void setCollectSnapshotOnSLAViolationEnabled(boolean collectSnapshotOnSLAViolationEnabled) {
        this.collectSnapshotOnSLAViolationEnabled = collectSnapshotOnSLAViolationEnabled;
    }

    public boolean isOnWarningThresholdViolation() {
        return this.onWarningThresholdViolation;
    }

    public boolean isOnCriticalThresholdViolation() {
        return !this.onWarningThresholdViolation;
    }

    public void setOnWarningThresholdViolation(boolean onWarningThresholdViolation) {
        this.onWarningThresholdViolation = onWarningThresholdViolation;
    }

    public boolean isOccuranceSnapshotCollectionEnabled() {
        return this.occuranceSnapshotCollectionEnabled;
    }

    public void setOccuranceSnapshotCollectionEnabled(boolean occuranceSnapshotCollectionEnabled) {
        this.occuranceSnapshotCollectionEnabled = occuranceSnapshotCollectionEnabled;
    }

    public int getNthOccurance() {
        return this.nthOccurance;
    }

    public void setNthOccurance(int nthOccurance) {
        this.nthOccurance = nthOccurance;
    }

    public boolean isCollectSnapshotForEveryNMinutesEnabled() {
        return this.collectSnapshotForEveryNMinutesEnabled;
    }

    public void setCollectSnapshotForEveryNMinutesEnabled(boolean collectSnapshotForEveryNMinutesEnabled) {
        this.collectSnapshotForEveryNMinutesEnabled = collectSnapshotForEveryNMinutesEnabled;
    }

    public int getMinuteFrequency() {
        return this.minuteFrequency;
    }

    public void setMinuteFrequency(int minuteFrequency) {
        this.minuteFrequency = minuteFrequency;
    }

    public int getOnDemandSnapshotCollectionRemainingDurationInMinutes() {
        return this.onDemandSnapshotCollectionRemainingDurationInMinutes;
    }

    public void setOnDemandSnapshotCollectionRemainingDurationInMinutes(int onDemandSnapshotCollectionRemainingDurationInMinutes) {
        this.onDemandSnapshotCollectionRemainingDurationInMinutes = onDemandSnapshotCollectionRemainingDurationInMinutes;
    }

    public static void validateDurationAndNumberOfSnapshots(int durationInMinutes, int snapshotsToCollectPerMinute) {
        if (durationInMinutes < 1) {
            throw new IllegalArgumentException("Duration cannot be less than 1");
        }
        if (durationInMinutes > 10) {
            throw new IllegalArgumentException("Duration cannot be more than 10 minutes");
        }
        if (snapshotsToCollectPerMinute > 10) {
            throw new IllegalArgumentException("Number of snapshots to collect cannot be more than 10 per minute");
        }
        if (snapshotsToCollectPerMinute < 1) {
            throw new IllegalArgumentException("Number of snapshots to collect cannot be less than 1");
        }
    }

    public void validate() {
        this.validateOnSLASnapshotCollection();
        this.validateNthOccuranceSnapshotCollection();
        this.validateEveryNMinuteSnapshotCollection();
    }

    private void validateOnSLASnapshotCollection() {
        if (this.collectSnapshotOnSLAViolationEnabled) {
            SnapshotCollectionPolicy.validateDurationAndNumberOfSnapshots(this.onSLAViolationSnapshotCollectionDurationInMinutes, this.numberOfSnapshotsToCollectOnSLAViolation);
        }
    }

    private void validateEveryNMinuteSnapshotCollection() {
        if (this.collectSnapshotForEveryNMinutesEnabled && this.minuteFrequency < 1) {
            throw new IllegalArgumentException("Minute frequency cannot be less than 1");
        }
    }

    private void validateNthOccuranceSnapshotCollection() {
        if (this.occuranceSnapshotCollectionEnabled && this.nthOccurance < 1) {
            throw new IllegalArgumentException("Occurance number cannot be less than 1");
        }
    }

    public boolean isCollectOutliersOnlyOnSLAViolation() {
        return this.collectOutliersOnlyOnSLAViolation;
    }

    public void setCollectOutliersOnlyOnSLAViolation(boolean collectOutliersOnlyOnSLAViolation) {
        this.collectOutliersOnlyOnSLAViolation = collectOutliersOnlyOnSLAViolation;
    }

    public int getMaxAttemptsForOutliersOnSLAViolation() {
        return this.maxAttemptsForOutliersOnSLAViolation;
    }

    public void setMaxAttemptsForOutliersOnSLAViolation(int maxAttemptsForOutliersOnSLAViolation) {
        this.maxAttemptsForOutliersOnSLAViolation = maxAttemptsForOutliersOnSLAViolation;
    }

    public static SnapshotCollectionPolicy getDefaultValue() {
        SnapshotCollectionPolicy policy = new SnapshotCollectionPolicy();
        policy.setCollectSnapshotOnSLAViolationEnabled(true);
        policy.setNumberOfSnapshotsToCollectOnSLAViolation(5);
        policy.setOnSLAViolationSnapshotCollectionDurationInMinutes(5);
        policy.setOnWarningThresholdViolation(true);
        policy.setCollectOutliersOnlyOnSLAViolation(true);
        policy.setMaxAttemptsForOutliersOnSLAViolation(20);
        policy.setCollectSnapshotForEveryNMinutesEnabled(true);
        policy.setMinuteFrequency(10);
        policy.setOccuranceSnapshotCollectionEnabled(false);
        policy.setNthOccurance(100);
        policy.setAutomaticCollectionEnabled(true);
        policy.setAutomaticErrorVolumePercentageThreshold(10);
        policy.setAutomaticSlowVolumePercentageThreshold(10);
        return policy;
    }

    public int getAutomaticSlowVolumePercentageThreshold() {
        return this.automaticSlowVolumePercentageThreshold;
    }

    public void setAutomaticSlowVolumePercentageThreshold(int automaticSlowVolumePercentageThreshold) {
        this.automaticSlowVolumePercentageThreshold = automaticSlowVolumePercentageThreshold;
    }

    public int getAutomaticErrorVolumePercentageThreshold() {
        return this.automaticErrorVolumePercentageThreshold;
    }

    public void setAutomaticErrorVolumePercentageThreshold(int automaticErrorVolumePercentageThreshold) {
        this.automaticErrorVolumePercentageThreshold = automaticErrorVolumePercentageThreshold;
    }

    public boolean isAutomaticCollectionEnabled() {
        return this.automaticCollectionEnabled;
    }

    public void setAutomaticCollectionEnabled(boolean automaticCollectionEnabled) {
        this.automaticCollectionEnabled = automaticCollectionEnabled;
    }

    public String toString() {
        return "\nSnapshotCollectionPolicy[\ncollectingOnDemandSnapshots=" + this.collectingOnDemandSnapshots + ", \nonDemandSnapshotCollectionDurationInMinutes=" + this.onDemandSnapshotCollectionDurationInMinutes + ", \nonDemandSnapshotCollectionRemainingDurationInMinutes=" + this.onDemandSnapshotCollectionRemainingDurationInMinutes + ", \nnumberOfOnDemandSnapshotsToCollect=" + this.numberOfOnDemandSnapshotsToCollect + ", \ncollectSnapshotOnSLAViolationEnabled=" + this.collectSnapshotOnSLAViolationEnabled + ", \nonWarningThresholdViolation=" + this.onWarningThresholdViolation + ", \nonSLAViolationSnapshotCollectionDurationInMinutes=" + this.onSLAViolationSnapshotCollectionDurationInMinutes + ", \nnumberOfSnapshotsToCollectOnSLAViolation=" + this.numberOfSnapshotsToCollectOnSLAViolation + ", \noccuranceSnapshotCollectionEnabled=" + this.occuranceSnapshotCollectionEnabled + ", \nnthOccurance=" + this.nthOccurance + ", \ncollectSnapshotForEveryNMinutesEnabled=" + this.collectSnapshotForEveryNMinutesEnabled + ", \nminuteFrequency=" + this.minuteFrequency + "\n]";
    }
}

