/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.MetricData;
import com.singularity.ee.controller.api.dto.MetricDataTimeslice;
import com.singularity.ee.controller.api.dto.MetricValue;
import com.singularity.ee.util.collections.EqualsUtilHelper;

@UiCodeGen
@TSCodeGen(exclude=true)
public class PerformanceValue {
    private long metricId;
    private float value;
    private double standardDeviation;
    private MetricValue metricValue;

    public PerformanceValue() {
    }

    protected PerformanceValue(MetricData data) {
        this.metricId = data.getMetricId();
        this.value = -1.0f;
        MetricDataTimeslice[] dataTimeslices = data.getDataTimeslices();
        if (dataTimeslices == null || dataTimeslices.length == 0) {
            return;
        }
        MetricValue metricValue = dataTimeslices[0].getMetricValue();
        this.value = metricValue.getValue();
        this.standardDeviation = metricValue.getStandardDeviation();
        this.metricValue = metricValue;
    }

    public PerformanceValue(long metricId, float value) {
        this.metricId = metricId;
        this.value = value;
    }

    public PerformanceValue(Long metricId, MetricValue value) {
        this.metricId = metricId == null ? 0L : metricId;
        this.value = value == null ? 0.0f : (float)value.getValue();
    }

    public long getMetricId() {
        return this.metricId;
    }

    public void setMetricId(long metricId) {
        this.metricId = metricId;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public void add(float value) {
        this.value += value;
    }

    public String toString() {
        return "[MetricId:" + this.metricId + " Val:" + this.value + "]";
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public static PerformanceValue getPerformanceValueForFirstTimeslice(MetricData data) {
        if (data == null) {
            return new PerformanceValue(-1L, -1.0f);
        }
        return new PerformanceValue(data);
    }

    public static PerformanceValue[] getPerformanceValueForFirstTimeslices(MetricData[] datas) {
        PerformanceValue[] results = new PerformanceValue[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            results[i] = PerformanceValue.getPerformanceValueForFirstTimeslice(datas[i]);
        }
        return results;
    }

    @Deprecated
    public static MetricValue getSafeMetricValueForTimeslice(MetricData data) {
        return MetricData.getSafeMetricValueForTimeslice(data);
    }

    @Deprecated
    public static MetricValue getMetricValueForFirstTimeslice(MetricData data) {
        return MetricData.getMetricValueForFirstTimeslice(data);
    }

    @Deprecated
    public static long getMetricValueForFirstTimeslice(MetricData data, boolean defaultToZero) {
        return MetricData.getMetricValueForFirstTimeslice(data, defaultToZero);
    }

    public static PerformanceValue createEmptyValue() {
        PerformanceValue perfValue = new PerformanceValue();
        return perfValue;
    }

    public PerformanceValue copy() {
        PerformanceValue copy = new PerformanceValue(this.metricId, this.value);
        copy.setStandardDeviation(this.standardDeviation);
        copy.setMetricValue(this.metricValue == null ? null : this.metricValue.copy());
        return copy;
    }

    public static PerformanceValue safeCopy(PerformanceValue value) {
        return value == null ? null : value.copy();
    }

    public MetricValue getMetricValue() {
        return this.metricValue;
    }

    public void setMetricValue(MetricValue metricValue) {
        this.metricValue = metricValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PerformanceValue)) {
            return false;
        }
        PerformanceValue performanceValue = (PerformanceValue)obj;
        return this.metricId == performanceValue.metricId && EqualsUtilHelper.floatEquals(this.value, performanceValue.value) && EqualsUtilHelper.doubleEquals(this.standardDeviation, performanceValue.standardDeviation) && (this.metricValue == null ? performanceValue.metricValue == null : this.metricValue.equals(performanceValue.metricValue));
    }

    public int hashCode() {
        throw new RuntimeException("PerformanceValue hashCode not implemented");
    }
}

