/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.dto.AAppComponentConfigObject;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointType;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeStringHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.IMatchPointRule;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class CustomMatchPointDefinition
extends AAppComponentConfigObject
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private String businessTransactionName;
    @IgnoreProtoGen
    private IMatchPointRule matchPointRule;
    @Deprecated
    @FieldPosition(value=4)
    private TransactionEntryPointType entryPointType;
    @Deprecated
    @FieldPosition(value=5)
    private boolean background;
    @Deprecated
    @FieldPosition(value=6)
    private boolean enabled;
    @FieldPosition(value=7)
    private String entryPointTypeString;
    @IgnoreProtoGen
    private EntityDefinition attachedEntity;
    @IgnoreProtoGen
    private AgentType agentType;
    @IgnoreProtoGen
    @Deprecated
    private transient String matchRuleString;

    @Deprecated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public CustomMatchPointDefinition() {
    }

    public CustomMatchPointDefinition(String businessTransactionName) {
        this.businessTransactionName = businessTransactionName;
    }

    public CustomMatchPointDefinition(String txName, IMatchPointRule rule) {
        this.businessTransactionName = txName;
        this.matchPointRule = rule;
    }

    @Deprecated
    public TransactionEntryPointType getEntryPointType() {
        return this.entryPointType;
    }

    @Deprecated
    public void setEntryPointType(TransactionEntryPointType entryPointType) {
        this.entryPointType = entryPointType;
    }

    public String getEntryPointTypeString() {
        if (this.entryPointTypeString == null && this.entryPointType != null) {
            return TransactionEntryPointTypeStringHelper.getString(this.entryPointType);
        }
        return this.entryPointTypeString;
    }

    public void setEntryPointTypeString(String entryPointTypeString) {
        if (TransactionEntryPointTypeHelper.isLegacyType(entryPointTypeString)) {
            this.entryPointType = TransactionEntryPointTypeStringHelper.getEnum(entryPointTypeString);
        }
        this.entryPointTypeString = entryPointTypeString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomMatchPointDefinition)) {
            return false;
        }
        CustomMatchPointDefinition otherCustomMatchPointDefinition = (CustomMatchPointDefinition)o;
        IMatchPointRule otherMatchPointRule = otherCustomMatchPointDefinition.getMatchPointRule();
        String otherTransactionName = otherCustomMatchPointDefinition.getName();
        if (this.getName() != null ? !this.getName().equals(otherTransactionName) : otherTransactionName != null) {
            return false;
        }
        if (this.matchPointRule != null) {
            return this.matchPointRule.equals(otherMatchPointRule);
        }
        return otherMatchPointRule == null;
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this.businessTransactionName != null) {
            result = 37 * result + this.businessTransactionName.hashCode();
        }
        if (this.matchPointRule != null) {
            result = 37 * result + this.matchPointRule.hashCode();
        }
        return result;
    }

    @JsonIgnore
    public boolean isLocalToAgent() {
        return this.getId() == -1L;
    }

    @JsonIgnore
    public void setLocalToAgent() {
        this.setId(-1L);
    }

    public void deepCopy(CustomMatchPointDefinition dto) {
        super.deepCopy(dto);
        this.setApplicationComponentId(0L);
        dto.setEntryPointTypeString(this.entryPointTypeString);
        dto.setMatchRuleString(this.matchRuleString);
        dto.setBusinessTransactionName(this.businessTransactionName);
        dto.setBackground(this.background);
        dto.setEnabled(this.enabled);
        dto.setMatchPointRule(this.matchPointRule);
    }

    public CustomMatchPointDefinition toDTO() {
        CustomMatchPointDefinition def = new CustomMatchPointDefinition();
        def.setAgentType(this.agentType);
        def.setEnabled(this.enabled);
        def.setAttachedEntity(this.attachedEntity);
        def.setEntryPointTypeString(this.entryPointTypeString);
        def.setName(this.getName());
        def.setBusinessTransactionName(this.businessTransactionName);
        def.setMatchPointRule(this.matchPointRule);
        def.setApplicationComponentId(this.getApplicationComponentId());
        return def;
    }

    @Deprecated
    public String getMatchRuleString() {
        return this.matchRuleString;
    }

    @Deprecated
    public void setMatchRuleString(String matchRuleString) {
        this.matchRuleString = matchRuleString;
    }

    public String getBusinessTransactionName() {
        return this.businessTransactionName;
    }

    public void setBusinessTransactionName(String businessTransactionName) {
        this.businessTransactionName = businessTransactionName;
    }

    @Override
    public void setName(String name) {
        this.businessTransactionName = name;
    }

    @Override
    public String getName() {
        return this.businessTransactionName;
    }

    public IMatchPointRule getMatchPointRule() {
        return this.matchPointRule;
    }

    public void setMatchPointRule(IMatchPointRule matchPointRule) {
        this.matchPointRule = matchPointRule;
    }

    @Deprecated
    public boolean isBackground() {
        return this.background;
    }

    @Deprecated
    public void setBackground(boolean background) {
        this.background = background;
    }

    public EntityDefinition getAttachedEntity() {
        return this.attachedEntity;
    }

    public void setAttachedEntity(EntityDefinition attachedEntity) {
        this.attachedEntity = attachedEntity;
    }

    public AgentType getAgentType() {
        return this.agentType;
    }

    public void setAgentType(AgentType agentType) {
        this.agentType = agentType;
    }

    @Override
    public String toString() {
        return "CustomMatchPointDefinition{businessTransactionName='" + this.businessTransactionName + '\'' + ", matchPointRule=" + this.matchPointRule + ", entryPointType=" + (Object)((Object)this.entryPointType) + ", entryPointTypeString=" + this.entryPointTypeString + ", background=" + this.background + ", enabled=" + this.enabled + ", attachedEntity=" + this.attachedEntity + ", agentType=" + (Object)((Object)this.agentType) + ", matchRuleString='" + this.matchRuleString + '\'' + '}';
    }
}

