/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.EumAutoEnablePossibleType;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointType;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionEntryPointTypeStringHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ABusinessTransactionObject;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.BusinessTransactionConfiguration;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MatchCriteria;
import com.singularity.ee.util.enums.EnumHelper;
import java.util.Date;

@GenProto(protoFile="TransactionMonitor.proto", needsList=true)
@UiCodeGen
@TSCodeGen(exclude=true)
public class BusinessTransaction
extends ABusinessTransactionObject
implements SingularitySerializable {
    @IgnoreProtoGen
    public static final String DEFAULT_TRANSACTION_NAME = "_APPDYNAMICS_DEFAULT_TX_";
    @IgnoreProtoGen
    public static final String OVERFLOW_BT_NAME = "All Other Traffic";
    @IgnoreProtoGen
    public static final String DEFAULT_TRANSACTION_PRETTY_NAME_PREFIX = "All Other Traffic - ";
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @Deprecated
    @FieldPosition(value=2)
    private TransactionEntryPointType entryPointType;
    @FieldPosition(value=3)
    private String internalName;
    @FieldPosition(value=4)
    private long componentId;
    @IgnoreProtoGen
    private String applicationComponentName;
    @IgnoreProtoGen
    private boolean excluded;
    @FieldPosition(value=5)
    private MatchCriteria matchCriteria;
    @FieldPosition(value=6)
    private long[] dataGathererConfigIds;
    @FieldPosition(value=7)
    private Date createdOn;
    @FieldPosition(value=8)
    private boolean background;
    @FieldPosition(value=9)
    private BusinessTransactionConfiguration configuration;
    @FieldPosition(value=10)
    private boolean analyticsDataCollectionEnabled;
    @FieldPosition(value=11)
    private long[] async2ConfigurationIds;
    @FieldPosition(value=12)
    private boolean permanent = false;
    @IgnoreProtoGen
    private long createdNodeId;
    @IgnoreProtoGen
    private boolean discovered;
    @IgnoreProtoGen
    private boolean enabledForEUM;
    @IgnoreProtoGen
    private EumAutoEnablePossibleType eumAutoEnablePossible = null;
    @FieldPosition(value=13)
    private String entryPointTypeString;
    @FieldPosition(value=14)
    private String ruleId;
    @FieldPosition(value=15)
    private boolean btRuleMappingEnabled;

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public boolean isBtRuleMappingEnabled() {
        return this.btRuleMappingEnabled;
    }

    public void setBtRuleMappingEnabled(boolean btRuleMappingEnabled) {
        this.btRuleMappingEnabled = btRuleMappingEnabled;
    }

    public BusinessTransaction() {
    }

    public BusinessTransaction(String internalName, String entryPointTypeString, long componentId) {
        this.internalName = internalName;
        this.componentId = componentId;
        this.permanent = false;
        this.setEntryPointTypeString(entryPointTypeString);
    }

    public BusinessTransaction(String internalName, String entryPointTypeString, long componentId, boolean bPermanent) {
        this.internalName = internalName;
        this.componentId = componentId;
        this.permanent = bPermanent;
        this.setEntryPointTypeString(entryPointTypeString);
    }

    public long getComponentId() {
        return this.componentId;
    }

    public void setComponentId(long componentId) {
        this.componentId = componentId;
    }

    public TransactionEntryPointType getEntryPointType() {
        return this.entryPointType;
    }

    public void setEntryPointType(TransactionEntryPointType entryPointType) {
        this.entryPointType = entryPointType;
    }

    public String getEntryPointTypeString() {
        if (this.entryPointTypeString == null && this.entryPointType != null) {
            return TransactionEntryPointTypeStringHelper.getString(this.entryPointType);
        }
        return this.entryPointTypeString;
    }

    public void setEntryPointTypeString(String entryPointTypeString) {
        if (TransactionEntryPointTypeHelper.isLegacyType(entryPointTypeString)) {
            this.entryPointType = TransactionEntryPointTypeStringHelper.getEnum(entryPointTypeString);
        }
        this.entryPointTypeString = entryPointTypeString;
    }

    public MatchCriteria getMatchCriteria() {
        return this.matchCriteria;
    }

    public void setMatchCriteria(MatchCriteria matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BusinessTransaction)) {
            return false;
        }
        BusinessTransaction other = (BusinessTransaction)o;
        if (!this.internalName.equals(other.getInternalName())) {
            return false;
        }
        if (this.entryPointType != other.getEntryPointType()) {
            return false;
        }
        if (this.entryPointTypeString != null ? !this.entryPointTypeString.equals(other.entryPointTypeString) : other.entryPointTypeString != null) {
            return false;
        }
        return this.componentId == other.getComponentId();
    }

    public long[] getDataGathererConfigIds() {
        return this.dataGathererConfigIds;
    }

    public void setDataGathererConfigIds(long[] dataGathererConfigIds) {
        this.dataGathererConfigIds = dataGathererConfigIds;
    }

    public long[] getAsync2ConfigurationIds() {
        return this.async2ConfigurationIds;
    }

    public void setAsync2ConfigurationIds(long[] async2ConfigurationIds) {
        this.async2ConfigurationIds = async2ConfigurationIds;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean bPermanent) {
        this.permanent = bPermanent;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + this.internalName.hashCode();
        result = 37 * result + this.entryPointType.hashCode();
        result = 37 * result + (this.entryPointTypeString != null ? this.entryPointTypeString.hashCode() : 0);
        result = 37 * result + Long.valueOf(this.componentId).hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "BusinessTransaction{id=" + this.getId() + ", name=" + this.getName() + ", entryPointType=" + (this.entryPointType != null ? EnumHelper.getName(this.entryPointType, this.entryPointType) : "null") + ", entryPointTypeString=" + this.entryPointTypeString + ", internalName=" + this.internalName + ", componentId=" + this.componentId + " ,applicationId=" + this.getApplicationId() + ", applicationComponentName=" + this.applicationComponentName + ", matchCriteria=" + this.matchCriteria + ", createdOn=" + this.createdOn + ", background=" + this.background + ", analyticsDataCollectionEnabled=" + this.analyticsDataCollectionEnabled + ", configuration=" + this.configuration + ", createdNodeId=" + this.createdNodeId + ", enabledForEUM=" + this.enabledForEUM + ", eumAutoEnablePossible=" + (Object)((Object)this.eumAutoEnablePossible) + "}";
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public BusinessTransactionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BusinessTransactionConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setCreatedNodeId(long createdNodeId) {
        this.createdNodeId = createdNodeId;
    }

    public long getCreatedNodeId() {
        return this.createdNodeId;
    }

    public String getApplicationComponentName() {
        return this.applicationComponentName;
    }

    public void setApplicationComponentName(String applicationComponentName) {
        this.applicationComponentName = applicationComponentName;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    public boolean isEnabledForEUM() {
        return this.enabledForEUM;
    }

    public void setEnabledForEUM(boolean enabledForEUM) {
        this.enabledForEUM = enabledForEUM;
    }

    public EumAutoEnablePossibleType getEumAutoEnablePossible() {
        return this.eumAutoEnablePossible;
    }

    public void setEumAutoEnablePossible(EumAutoEnablePossibleType eumAutoEnablePossible) {
        this.eumAutoEnablePossible = eumAutoEnablePossible;
    }

    public boolean isAnalyticsDataCollectionEnabled() {
        return this.analyticsDataCollectionEnabled;
    }

    public void setAnalyticsDataCollectionEnabled(boolean analyticsDataCollectionEnabled) {
        this.analyticsDataCollectionEnabled = analyticsDataCollectionEnabled;
    }

    public boolean isDiscovered() {
        return this.discovered;
    }

    public void setDiscovered(boolean discovered) {
        this.discovered = discovered;
    }

    public static String getDefaultPrettyNameForComponent(String componentName) {
        if (componentName != null && !"".equals(componentName)) {
            return DEFAULT_TRANSACTION_PRETTY_NAME_PREFIX + componentName;
        }
        return OVERFLOW_BT_NAME;
    }
}

