/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ASubHierarchicalConfigObject;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.BackendDiscoveryCondition;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.BackendIdentityOption;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.ArrayList;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class BackendDiscoveryConfig
extends ASubHierarchicalConfigObject
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private BackendDiscoveryCondition[] discoveryConditions;
    @FieldPosition(value=3)
    private BackendIdentityOption[] identityOptions;
    @FieldPosition(value=4)
    private boolean discoveryEnabled;
    @FieldPosition(value=5)
    private boolean correlationEnabled;
    @FieldPosition(value=6)
    private boolean supportsCorrelation;
    @FieldPosition(value=7)
    private int priority;
    @FieldPosition(value=8)
    private String exitPointType;
    @FieldPosition(value=9)
    private String exitPointSubType;

    public BackendDiscoveryConfig(String name, String exitPointType, BackendIdentityOption[] identityOptions, boolean discoveryEnabled, boolean correlationEnabled, boolean supportsCorrelation) {
        this(name, exitPointType, exitPointType, identityOptions, discoveryEnabled, correlationEnabled, supportsCorrelation);
    }

    public BackendDiscoveryConfig(String name, String exitPointType, String exitPointSubType, BackendIdentityOption[] identityOptions, boolean discoveryEnabled, boolean correlationEnabled, boolean supportsCorrelation) {
        this.name = name;
        this.exitPointType = exitPointType;
        this.exitPointSubType = exitPointSubType;
        this.identityOptions = identityOptions;
        this.discoveryEnabled = discoveryEnabled;
        this.correlationEnabled = correlationEnabled;
        this.supportsCorrelation = supportsCorrelation;
        this.priority = 0;
        this.discoveryConditions = new BackendDiscoveryCondition[0];
    }

    public BackendDiscoveryConfig() {
    }

    public void deepCopy(BackendDiscoveryConfig dto) {
        super.deepCopy(dto);
        ArrayList<BackendIdentityOption> options = new ArrayList<BackendIdentityOption>();
        for (BackendIdentityOption identityOption : this.identityOptions) {
            BackendIdentityOption copy = new BackendIdentityOption();
            identityOption.deepCopy(copy);
            options.add(copy);
        }
        ArrayList<BackendDiscoveryCondition> conditions = new ArrayList<BackendDiscoveryCondition>();
        for (BackendDiscoveryCondition discoveryCondition : this.discoveryConditions) {
            BackendDiscoveryCondition conditionCopy = new BackendDiscoveryCondition();
            discoveryCondition.deepCopy(conditionCopy);
            conditions.add(conditionCopy);
        }
        dto.setIdentityOptions(CollectionHelper.collectionToArray(options, new BackendIdentityOption[options.size()]));
        dto.setDiscoveryConditions(CollectionHelper.collectionToArray(conditions, new BackendDiscoveryCondition[conditions.size()]));
        dto.setDiscoveryEnabled(this.discoveryEnabled);
        dto.setCorrelationEnabled(this.correlationEnabled);
        dto.setSupportsCorrelation(this.supportsCorrelation);
        dto.setName(this.name);
        dto.setPriority(this.priority);
        dto.setExitPointType(this.exitPointType);
        dto.setExitPointSubType(this.exitPointSubType);
    }

    public BackendIdentityOption[] getIdentityOptions() {
        return this.identityOptions;
    }

    public void setIdentityOptions(BackendIdentityOption[] identityOptions) {
        this.identityOptions = identityOptions;
    }

    public BackendDiscoveryCondition[] getDiscoveryConditions() {
        return this.discoveryConditions;
    }

    public void setDiscoveryConditions(BackendDiscoveryCondition[] discoveryConditions) {
        this.discoveryConditions = discoveryConditions;
    }

    public boolean isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(boolean discoveryEnabled) {
        this.discoveryEnabled = discoveryEnabled;
    }

    public boolean isCorrelationEnabled() {
        return this.correlationEnabled;
    }

    public void setCorrelationEnabled(boolean correlationEnabled) {
        this.correlationEnabled = correlationEnabled;
    }

    public boolean isSupportsCorrelation() {
        return this.supportsCorrelation;
    }

    public void setSupportsCorrelation(boolean supportsCorrelation) {
        this.supportsCorrelation = supportsCorrelation;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getExitPointType() {
        return this.exitPointType;
    }

    public void setExitPointType(String exitPointType) {
        this.exitPointType = exitPointType;
    }

    public String getExitPointSubType() {
        return this.exitPointSubType;
    }

    public void setExitPointSubType(String exitPointSubType) {
        this.exitPointSubType = exitPointSubType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("BackendDiscoveryConfig{");
        sb.append("discoveryConditions=").append(CollectionHelper.arrayToString(this.discoveryConditions));
        sb.append(", identityOptions=").append(CollectionHelper.arrayToString(this.identityOptions));
        sb.append(", discoveryEnabled=").append(this.discoveryEnabled);
        sb.append(", correlationEnabled=").append(this.correlationEnabled);
        sb.append(", supportsCorrelation=").append(this.supportsCorrelation);
        sb.append(", priority=").append(this.priority);
        sb.append(", exitPointType='").append(this.exitPointType).append('\'');
        sb.append(", exitPointSubType='").append(this.exitPointSubType).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

