/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.CallElement;
import com.singularity.ee.controller.api.dto.transactionmonitor.SnapshotExitCallHelper;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionExitPointType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionExitPointCall;
import com.singularity.ee.util.collections.ArrayUtilsHelper;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.string.StringRegexOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class SnapshotExitCall
implements SingularitySerializable {
    @IgnoreProtoGen
    public static final String ASYNC_EXITCALL_PROPERTY_NAME = "Asynchronous";
    @IgnoreProtoGen
    public static final String ASYNC_EXITCALL_PROPERTY_VALUE_YES = "Yes";
    @IgnoreProtoGen
    public static final String ASYNC_CONTINUATION_PROPERTY_NAME = "Continuation";
    @IgnoreProtoGen
    public static final String SESSION_ID = "Session Id";
    @IgnoreProtoGen
    public static final String DB2_SSID = "db2-ssid";
    @IgnoreProtoGen
    public static final String QUERY_TYPE = "Query Type";
    @IgnoreProtoGen
    public static final String QUERY_STMT_TYPE = "Statement Type";
    @IgnoreProtoGen
    public static final String QUERY_DELIMITER = "|";
    @IgnoreProtoGen
    public static final String QUERY_STMT_TYPE_PREPARED = "Prepared Statement";
    @IgnoreProtoGen
    public static final String QUERY_STMT_TYPE_STRING = "String";
    @IgnoreProtoGen
    public static final String QUERY_DETAILS = "Query Details";
    @IgnoreProtoGen
    public static final String NUM_SOCKET_READS = "Number of socket reads";
    @IgnoreProtoGen
    public static final String NUM_SOCKET_BYTES_READS = "Number of bytes read from socket";
    @IgnoreProtoGen
    public static final String SOCKET_READ_TIME = "Socket read time";
    @IgnoreProtoGen
    public static final String NUM_SOCKET_WRITES = "Number of socket writes";
    @IgnoreProtoGen
    public static final String NUM_SOCKET_BYTES_WRITTEN = "Number of bytes written to socket";
    @IgnoreProtoGen
    public static final String SOCKET_WRITE_TIME = "Socket write time";
    @IgnoreProtoGen
    public static final String HEAP_ALLOCATIONS = "Number of Heap Allocations";
    @IgnoreProtoGen
    public static final char QUERY_DELIMITER_CHAR = '|';
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @IgnoreProtoGen
    public static final String EXIT_NAME = "ExitName";
    @IgnoreProtoGen
    public static final String ASYNC_START = "AsyncStart";
    @IgnoreProtoGen
    public static final String ASYNC_END = "AsyncEnd";
    @IgnoreProtoGen
    public static final String START_TIME = "Start Time";
    @Deprecated
    @FieldPosition(value=2)
    private TransactionExitPointType type;
    @FieldPosition(value=3)
    private long customExitPointId;
    @FieldPosition(value=4)
    private volatile String detailString;
    @FieldPosition(value=5)
    private NameValuePair[] properties;
    @FieldPosition(value=6)
    private String toComponentId;
    @FieldPosition(value=7)
    private int timeTakenInMillis;
    @FieldPosition(value=8)
    private int count;
    @FieldPosition(value=9)
    private int errorCount;
    @FieldPosition(value=10)
    private String errorDetails;
    @FieldPosition(value=11)
    private String snapshotSequenceCounter;
    @FieldPosition(value=12)
    private String callingMethod;
    @FieldPosition(value=13)
    private String exitPointName;
    @FieldPosition(value=14)
    private long timestamp;
    @FieldPosition(value=15)
    private String remoteSnapshotGuid;
    @IgnoreProtoGen
    private boolean customActivity;
    @IgnoreProtoGen
    private transient boolean cloned;
    @IgnoreProtoGen
    private transient int resultSetRows = 0;
    @IgnoreProtoGen
    private transient long iterationTime = 0L;
    @IgnoreProtoGen
    private transient long base = 0L;
    @IgnoreProtoGen
    private transient boolean prepStmtValuesSubstituted = false;
    @IgnoreProtoGen
    private short[] hotspotIndices = null;
    @IgnoreProtoGen
    private int[] hotspotIndicesTimeTaken = null;
    @IgnoreProtoGen
    private String[] hotspotIndicesErrorDetails = null;
    @IgnoreProtoGen
    private transient short nextHotspotIndex = 0;
    @IgnoreProtoGen
    private transient int maxTimeTakenInMs = SnapshotExitCallHelper.getMinInt();
    @IgnoreProtoGen
    private transient int minTimeTakenInMs = SnapshotExitCallHelper.getMaxInt();
    @IgnoreProtoGen
    private volatile transient List<Object[]> listOfBindVariables;
    @IgnoreProtoGen
    private transient int queryDroppedCount;
    @IgnoreProtoGen
    private transient boolean preparedStmtBatch = false;
    @IgnoreProtoGen
    private transient int addBatchCountForPS = 0;
    @IgnoreProtoGen
    private volatile transient boolean addedToCG = false;
    @IgnoreProtoGen
    private int timeTakenInNanos = -1;
    @IgnoreProtoGen
    private transient CallElement callElement;
    @IgnoreProtoGen
    private transient boolean valid = true;
    @IgnoreProtoGen
    private transient List<SnapshotExitCall> nestedAsyncCalls = null;

    public SnapshotExitCall(SnapshotExitCall originatingExitCall) {
        this.type = originatingExitCall.type;
        this.detailString = originatingExitCall.detailString;
        this.properties = originatingExitCall.properties;
        this.toComponentId = originatingExitCall.toComponentId;
        this.timeTakenInMillis = originatingExitCall.timeTakenInMillis;
        this.count = originatingExitCall.count;
        this.errorCount = originatingExitCall.errorCount;
        this.errorDetails = originatingExitCall.errorDetails;
        this.snapshotSequenceCounter = originatingExitCall.snapshotSequenceCounter;
        this.callingMethod = originatingExitCall.callingMethod;
        this.cloned = originatingExitCall.cloned;
        this.resultSetRows = originatingExitCall.resultSetRows;
        this.iterationTime = originatingExitCall.iterationTime;
        this.addBatchCountForPS = originatingExitCall.addBatchCountForPS;
        this.hotspotIndices = originatingExitCall.hotspotIndices;
        this.nextHotspotIndex = originatingExitCall.nextHotspotIndex;
        this.customActivity = originatingExitCall.customActivity;
        this.customExitPointId = originatingExitCall.customExitPointId;
        this.exitPointName = originatingExitCall.exitPointName;
        short[] sArray = this.hotspotIndices = originatingExitCall.hotspotIndices != null ? new short[originatingExitCall.hotspotIndices.length] : null;
        if (this.hotspotIndices != null) {
            System.arraycopy(originatingExitCall.hotspotIndices, 0, this.hotspotIndices, 0, this.hotspotIndices.length);
        }
        String[] stringArray = this.hotspotIndicesErrorDetails = originatingExitCall.hotspotIndicesErrorDetails != null ? new String[originatingExitCall.hotspotIndicesErrorDetails.length] : null;
        if (this.hotspotIndicesErrorDetails != null) {
            System.arraycopy(originatingExitCall.hotspotIndicesErrorDetails, 0, this.hotspotIndicesErrorDetails, 0, this.hotspotIndicesErrorDetails.length);
        }
        int[] nArray = this.hotspotIndicesTimeTaken = originatingExitCall.hotspotIndicesTimeTaken != null ? new int[originatingExitCall.hotspotIndicesTimeTaken.length] : null;
        if (this.hotspotIndicesTimeTaken != null) {
            System.arraycopy(originatingExitCall.hotspotIndicesTimeTaken, 0, this.hotspotIndicesTimeTaken, 0, this.hotspotIndicesTimeTaken.length);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public CallElement getCallElement() {
        return this.callElement;
    }

    public void setCallElement(CallElement callElement) {
        this.callElement = callElement;
    }

    public List<SnapshotExitCall> getNestedAsyncCalls() {
        return this.nestedAsyncCalls;
    }

    public void setNestedAsyncCalls(List<SnapshotExitCall> nestedAsyncCalls) {
        this.nestedAsyncCalls = nestedAsyncCalls;
    }

    public boolean hasNestedAsyncCalls() {
        return null != this.nestedAsyncCalls && this.nestedAsyncCalls.size() > 0;
    }

    public int getTimeTakenInNanos() {
        return this.timeTakenInNanos;
    }

    public void setTimeTakenInNanos(int timeTakenInNanos) {
        this.timeTakenInNanos = timeTakenInNanos;
    }

    public boolean isCustomActivity() {
        return this.customActivity;
    }

    public void setCustomActivity(boolean customActivity) {
        this.customActivity = customActivity;
    }

    public boolean hasBeenAddedToCG() {
        return this.addedToCG;
    }

    public void setAddedToCG(boolean addedToCG) {
        this.addedToCG = addedToCG;
    }

    public boolean isPreparedStmtBatch() {
        return this.preparedStmtBatch;
    }

    public void setPreparedStmtBatch(boolean isPreparedStmtBatch) {
        this.preparedStmtBatch = isPreparedStmtBatch;
    }

    public List<Object[]> getListOfBindVariables() {
        return this.listOfBindVariables;
    }

    public void setListOfBindVariables(List<Object[]> listOfBindVariables) {
        this.listOfBindVariables = listOfBindVariables;
    }

    public void addBindVariables(Object[] bindVariables) {
        if (null == this.listOfBindVariables) {
            this.listOfBindVariables = new ArrayList<Object[]>();
        }
        ArrayList tempListOfBindVariables = (ArrayList)this.listOfBindVariables;
        tempListOfBindVariables.add(bindVariables);
    }

    public void addBindVariables(List<Object[]> batchOfBindVariables) {
        if (null == this.listOfBindVariables) {
            this.listOfBindVariables = new ArrayList<Object[]>();
        }
        ArrayList tempListOfBindVariables = (ArrayList)this.listOfBindVariables;
        tempListOfBindVariables.addAll(batchOfBindVariables);
    }

    public boolean hasBindVariables() {
        return null != this.listOfBindVariables && this.listOfBindVariables.size() > 0;
    }

    public int getQueryDroppedCount() {
        return this.queryDroppedCount;
    }

    public void setQueryDroppedCount(int queryDroppedCount) {
        this.queryDroppedCount = queryDroppedCount;
    }

    public String getPropertiesAsString() {
        String propStr = "";
        if (this.getProperties() != null) {
            for (NameValuePair pair : this.getProperties()) {
                propStr = propStr + pair.getName() + ":" + pair.getValue() + ";";
            }
        }
        return propStr;
    }

    public void setPropertiesFromString(String propStr) {
        String[] propStrs;
        if (propStr == null || propStr.trim().length() == 0) {
            this.properties = new NameValuePair[0];
            return;
        }
        ArrayList<NameValuePair> pairList = new ArrayList<NameValuePair>();
        for (String keyVal : propStrs = StringRegexOperations.split(propStr, ";")) {
            String[] keyVals = StringRegexOperations.splitKeyValue(keyVal, ':');
            NameValuePair pair = new NameValuePair();
            pair.setName(keyVals[0]);
            if (keyVals.length == 1) {
                pair.setValue("");
            } else {
                pair.setValue(keyVals[1]);
            }
            pairList.add(pair);
        }
        NameValuePair[] props = CollectionHelper.collectionToArray(pairList, new NameValuePair[pairList.size()]);
        this.properties = props;
    }

    public SnapshotExitCall(TransactionExitPointType type, String toComponentId, int timeTakenInMillis, int count, int errorCount) {
        this.type = type;
        this.detailString = "";
        this.properties = new NameValuePair[0];
        this.toComponentId = toComponentId;
        this.timeTakenInMillis = timeTakenInMillis;
        this.errorDetails = "";
        this.count = count;
        this.errorCount = errorCount;
    }

    public SnapshotExitCall(long customExitPointId, String toComponentId, int timeTakenInMillis, int count, int errorCount) {
        this.customExitPointId = customExitPointId;
        this.detailString = "";
        this.properties = new NameValuePair[0];
        this.toComponentId = toComponentId;
        this.timeTakenInMillis = timeTakenInMillis;
        this.errorDetails = "";
        this.count = count;
        this.errorCount = errorCount;
    }

    public SnapshotExitCall() {
        this.count = 1;
        this.customExitPointId = -1L;
    }

    public TransactionExitPointType getType() {
        return this.type;
    }

    public void setType(TransactionExitPointType type) {
        this.type = type;
    }

    public String getDetailString() {
        return this.detailString;
    }

    public void setDetailString(String detailString) {
        this.detailString = detailString;
    }

    public NameValuePair[] getProperties() {
        return this.properties;
    }

    public void setProperties(NameValuePair[] properties) {
        this.properties = properties;
    }

    public void addProperties(NameValuePair ... newProperties) {
        this.properties = NameValuePair.expandArray(this.properties, newProperties);
    }

    public void addProperties(Collection<NameValuePair> newProperties) {
        this.properties = NameValuePair.expandArray(this.properties, newProperties);
    }

    public String getToComponentId() {
        return this.toComponentId;
    }

    public void setToComponentId(String toComponentId) {
        this.toComponentId = toComponentId;
    }

    public int getTimeTakenInMillis() {
        return this.timeTakenInMillis;
    }

    public void setTimeTakenInMillis(int timeTakenInMillis) {
        this.timeTakenInMillis = timeTakenInMillis;
        this.updateMaxTimeTakenInMs(timeTakenInMillis);
        this.updateMinTimeTakenInMs(timeTakenInMillis);
    }

    public void addTimeTaken(int timeTakenInMs) {
        this.timeTakenInMillis += timeTakenInMs;
        this.updateMaxTimeTakenInMs(timeTakenInMs);
        this.updateMinTimeTakenInMs(timeTakenInMs);
    }

    public void updateMaxTimeTakenInMs(int timeTakenInMs) {
        if (timeTakenInMs > this.maxTimeTakenInMs) {
            this.maxTimeTakenInMs = timeTakenInMs;
        }
    }

    public void updateMinTimeTakenInMs(int timeTakenInMs) {
        if (timeTakenInMs < this.minTimeTakenInMs) {
            this.minTimeTakenInMs = timeTakenInMs;
        }
    }

    public int getMaxTimeTakenInMs() {
        return this.maxTimeTakenInMs;
    }

    public int getMinTimeTakenInMs() {
        return this.minTimeTakenInMs;
    }

    public String getSnapshotSequenceCounter() {
        return this.snapshotSequenceCounter;
    }

    public void setSnapshotSequenceCounter(String snapshotSequenceCounter) {
        this.snapshotSequenceCounter = snapshotSequenceCounter;
    }

    public String getRemoteSnapshotGuid() {
        return this.remoteSnapshotGuid;
    }

    public void setRemoteSnapshotGuid(String remoteSnapshotGuid) {
        this.remoteSnapshotGuid = remoteSnapshotGuid;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public String getCallingMethod() {
        return this.callingMethod;
    }

    public void setCallingMethod(String callingMethod) {
        this.callingMethod = callingMethod;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount(int count) {
        this.count += count;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void incrementErrorCount(int errorCount) {
        this.errorCount += errorCount;
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public void setCloned(boolean cloned) {
        this.cloned = cloned;
    }

    public long getCustomExitPointId() {
        return this.customExitPointId;
    }

    public void setCustomExitPointId(long customExitPointId) {
        this.customExitPointId = customExitPointId;
    }

    public TransactionExitPointCall getExitPointCall() {
        if (this.exitPointName == null || this.exitPointName.trim().length() == 0) {
            TransactionExitPointType type = this.getType();
            if (type != null) {
                return new TransactionExitPointCall(EnumHelper.getName(type, type));
            }
            return new TransactionExitPointCall(this.customExitPointId);
        }
        TransactionExitPointCall exitPointCall = new TransactionExitPointCall(this.exitPointName);
        if (this.containsProperty(ASYNC_EXITCALL_PROPERTY_NAME, ASYNC_EXITCALL_PROPERTY_VALUE_YES)) {
            exitPointCall.setSynchronous(false);
        }
        return exitPointCall;
    }

    public boolean containsProperty(String propertyName, String propertyValue) {
        if (this.properties != null && this.properties.length > 0) {
            for (NameValuePair nv : this.properties) {
                if (nv.getName() == null || nv.getValue() == null || !nv.getName().equals(propertyName) || !nv.getValue().equals(propertyValue)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "type:" + this.getExitPointCall() + " time:" + this.timeTakenInMillis + " count:" + this.count + " errorCount:" + this.errorCount + " toComponent:" + this.toComponentId + " seq:" + this.snapshotSequenceCounter;
    }

    public String getExitPointName() {
        return this.exitPointName;
    }

    public void setExitPointName(String exitPointName) {
        this.exitPointName = exitPointName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void addResultSetRowsCount(int rows) {
        this.resultSetRows += rows;
    }

    public void incrementResultSetRowCount() {
        ++this.resultSetRows;
    }

    public void addResultSetIterationTime(long timeToIterate) {
        this.iterationTime += timeToIterate;
    }

    public void setBase(long base) {
        this.base = base;
    }

    public long getBase() {
        return this.base;
    }

    public int getResultSetRows() {
        return this.resultSetRows;
    }

    public long getIterationTime() {
        return this.iterationTime;
    }

    public short[] getHotspotIndices() {
        return this.hotspotIndices;
    }

    public int[] getHotspotIndicesTimeTaken() {
        return this.hotspotIndicesTimeTaken;
    }

    public void setHotspotIndicesTimeTaken(int[] hotspotIndicesTimeTaken) {
        this.hotspotIndicesTimeTaken = hotspotIndicesTimeTaken;
    }

    public String[] getHotspotIndicesErrorDetails() {
        return this.hotspotIndicesErrorDetails;
    }

    public void setHotspotIndicesErrorDetails(String[] hotspotIndicesErrorDetails) {
        this.hotspotIndicesErrorDetails = hotspotIndicesErrorDetails;
    }

    public void setHotspotIndices(short[] indices) {
        this.hotspotIndices = indices;
    }

    public short getNextHotspotIndex() {
        return this.nextHotspotIndex;
    }

    public void setNextHotspotIndex(short nextHotspotIndex) {
        this.nextHotspotIndex = nextHotspotIndex;
    }

    public int getAddBatchCountForPS() {
        return this.addBatchCountForPS;
    }

    public void setAddBatchCountForPS(int addBatchCountForPS) {
        this.addBatchCountForPS = addBatchCountForPS;
    }

    public void addHotspotIndex(short ptr, int timeTakenInMillis, String errorDetails) {
        if (this.hotspotIndices == null) {
            this.hotspotIndices = new short[]{-1, -1, -1, -1, -1};
            this.hotspotIndicesTimeTaken = new int[]{-1, -1, -1, -1, -1};
            this.hotspotIndicesErrorDetails = new String[]{null, null, null, null, null};
        } else if (this.nextHotspotIndex == this.hotspotIndices.length) {
            short[] newindices = new short[this.nextHotspotIndex + 5];
            System.arraycopy(this.hotspotIndices, 0, newindices, 0, this.nextHotspotIndex);
            ArrayUtilsHelper.arrayFillShort(newindices, this.nextHotspotIndex + 1, newindices.length, (short)-1);
            this.hotspotIndices = newindices;
            int[] newtimes = new int[this.nextHotspotIndex + 5];
            System.arraycopy(this.hotspotIndicesTimeTaken, 0, newtimes, 0, this.nextHotspotIndex);
            ArrayUtilsHelper.arrayFillInt(newtimes, this.nextHotspotIndex + 1, newtimes.length, -1);
            this.hotspotIndicesTimeTaken = newtimes;
            String[] newerrors = new String[this.nextHotspotIndex + 5];
            System.arraycopy(this.hotspotIndicesErrorDetails, 0, newerrors, 0, this.nextHotspotIndex);
            ArrayUtilsHelper.arrayFillString(newerrors, this.nextHotspotIndex + 1, newerrors.length, null);
            this.hotspotIndicesErrorDetails = newerrors;
        }
        this.hotspotIndices[this.nextHotspotIndex] = ptr;
        this.hotspotIndicesTimeTaken[this.nextHotspotIndex] = timeTakenInMillis;
        this.hotspotIndicesErrorDetails[this.nextHotspotIndex] = errorDetails;
        this.nextHotspotIndex = (short)(this.nextHotspotIndex + 1);
    }

    public boolean isPrepStmtValuesSubstituted() {
        return this.prepStmtValuesSubstituted;
    }

    public void setPrepStmtValuesSubstituted(boolean prepStmtValuesSubstituted) {
        this.prepStmtValuesSubstituted = prepStmtValuesSubstituted;
    }

    public boolean isWirePropagated() {
        return true;
    }

    public static class SnapshotExitCallTimeTakenComparator
    implements Comparator<SnapshotExitCall> {
        @Override
        public int compare(SnapshotExitCall first, SnapshotExitCall second) {
            return first.getTimeTakenInMillis() - second.getTimeTakenInMillis() < 0 ? 1 : -1;
        }
    }
}

