/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.UserComment;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.RequestUserExperience;
import com.singularity.ee.controller.api.dto.transactionmonitor.SnapshotExitCall;
import com.singularity.ee.controller.api.dto.transactionmonitor.StackTrace;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionSnapshot;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionSnapshotData;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.string.StringOperations;

@GenProto(protoFile="TransactionMonitor.proto", needsList=true)
@UiCodeGen
@TSCodeGen(exclude=true)
public class RequestSegmentData
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @IgnoreProtoGen
    public static final String ERROR_IDS = "Error IDs";
    @IgnoreProtoGen
    public static final String SEP_IDS = "SEP Ids";
    @IgnoreProtoGen
    public static final String STACK_TRACES = "Stack Traces";
    @IgnoreProtoGen
    public static final String ERROR_DETAIL = "Error Detail";
    @IgnoreProtoGen
    public static final String HTTP_PARAMETER = "Http Parameter";
    @IgnoreProtoGen
    public static final String BUSINESS_DATA = "Business Data";
    @IgnoreProtoGen
    public static final String COOKIE = "Cookie";
    @IgnoreProtoGen
    public static final String HTTP_HEADER = "Http Header";
    @IgnoreProtoGen
    public static final String SESSION_KEY = "Session Key";
    @IgnoreProtoGen
    public static final String RESPONSE_HEADER = "Response Header";
    @IgnoreProtoGen
    public static final String LOG_MESSAGE = "Log Message";
    @IgnoreProtoGen
    public static final String PROCESS_PROPERTY = "Process Property";
    @IgnoreProtoGen
    public static final String TRANSACTION_PROPERTY = "Transaction Property";
    @IgnoreProtoGen
    public static final String TRANSACTION_EVENT = "Transaction Event";
    @IgnoreProtoGen
    public static final String DOTNET_PROPS = "Dotnet Property";
    @IgnoreProtoGen
    public static final String DOTNET_SET = "isProtoBuf";
    @IgnoreProtoGen
    public static final String EUM_REQUEST_GUID = "EUM Request GUID";
    @IgnoreProtoGen
    public static final String PROCESS_SNAPSHOT_GUIDS = "Process Snapshot GUIDs";
    @IgnoreProtoGen
    public static final String ASYNC_ACTIVTY = "Async Activity";
    @IgnoreProtoGen
    public static final String PARENT_SNAPSHOT_GUID = "Parent Snapshot GUID";
    @IgnoreProtoGen
    public static final String PARENT_SNAPSHOT_EXIT_GUID = "Parent Snapshot Exit GUID";
    @IgnoreProtoGen
    public static final String PARENT_SNAPSHOT_APPLICATION_ID = "Parent Snapshot Application Id";
    @IgnoreProtoGen
    public static final String END_SEGMENT = "End Segment";
    @IgnoreProtoGen
    public static final String THREAD_POOL_WAIT_TIME = "Thread Pool Wait Time";
    @IgnoreProtoGen
    public static final String THREAD_POOL_NAME = "Thread Pool Name";
    @IgnoreProtoGen
    public static final String E2E_LATENCY_TYPE = "End To End Latency";
    @FieldPosition(value=2)
    private long id;
    @FieldPosition(value=3)
    private UserComment[] userComments;
    @FieldPosition(value=4)
    private boolean archived;
    @FieldPosition(value=5)
    private String requestGUID;
    @FieldPosition(value=6)
    private long businessTransactionId;
    @FieldPosition(value=7)
    private long applicationId;
    @FieldPosition(value=8)
    private long applicationComponentId;
    @FieldPosition(value=9)
    private long applicationComponentNodeId;
    @FieldPosition(value=10)
    private boolean async;
    @FieldPosition(value=11)
    private String threadID;
    @FieldPosition(value=12)
    private String threadName;
    @FieldPosition(value=13)
    private long localStartTime;
    @FieldPosition(value=14)
    private long serverStartTime;
    @FieldPosition(value=15)
    private boolean firstInChain;
    @FieldPosition(value=16)
    private String callChain;
    @FieldPosition(value=17)
    private int localID;
    @FieldPosition(value=18)
    private boolean errorOccured;
    @FieldPosition(value=19)
    private boolean hasDeepDiveData;
    @FieldPosition(value=20)
    private String userExperience;
    @FieldPosition(value=21)
    private int timeTakenInMilliSecs;
    @FieldPosition(value=22)
    private long cpuTimeTakenInMilliSecs;
    @FieldPosition(value=23)
    private String warningThreshold;
    @FieldPosition(value=24)
    private String criticalThreshold;
    @FieldPosition(value=25)
    private String summary;
    @FieldPosition(value=26)
    private String errorSummary;
    @FieldPosition(value=27)
    private String diagnosticSessionGUID;
    @FieldPosition(value=28)
    private String deepDivePolicy;
    @FieldPosition(value=29)
    private boolean delayedDeepDive;
    @FieldPosition(value=30)
    private int delayedDeepDiveOffSet;
    @FieldPosition(value=31)
    private TransactionSnapshotData snapshotData;
    @FieldPosition(value=32)
    private String stallDump;
    @FieldPosition(value=33)
    private String snapshotExitSequence;
    @FieldPosition(value=34)
    private SnapshotExitCall[] snapshotExitCalls;
    @FieldPosition(value=35)
    private boolean exitCallsDataTruncated;
    @FieldPosition(value=36)
    private String exitCallsDataTruncationMessage;
    @FieldPosition(value=37)
    private String URL;
    @FieldPosition(value=38)
    private String httpSessionID;
    @FieldPosition(value=39)
    private String securityID;
    @FieldPosition(value=40)
    private long[] errorIDs = new long[0];
    @FieldPosition(value=41)
    private NameValuePair[] errorDetails = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=42)
    private NameValuePair[] httpParameters = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=43)
    private NameValuePair[] businessData = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=44)
    private NameValuePair[] cookies = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=45)
    private NameValuePair[] httpHeaders = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=46)
    private NameValuePair[] sessionKeys = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=47)
    private NameValuePair[] responseHeaders = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=48)
    private NameValuePair[] logMessages = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=49)
    private NameValuePair[] transactionProperties = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=50)
    private NameValuePair[] transactionEvents = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=51)
    private boolean unresolvedCallInCallChain;
    @FieldPosition(value=52)
    private NameValuePair[] dotnetProperty = NameValuePair.EMPTY_NAME_VALUE_PAIR_ARRAY;
    @FieldPosition(value=53)
    private StackTrace[] stackTraces;
    @FieldPosition(value=54)
    private long[] serviceEndPointIds;
    @IgnoreProtoGen
    public static final long NO_E2E_LATENCY_DATA_AVAILABLE = -1L;
    @FieldPosition(value=55)
    private long endToEndLatency = -1L;
    @FieldPosition(value=56)
    private String endToEndUserExperience;
    @FieldPosition(value=57)
    private long totalWaitTime;
    @FieldPosition(value=58)
    private long totalBlockTime;
    @FieldPosition(value=59)
    private String asyncActivity;
    @FieldPosition(value=60)
    private long threadPoolWaitTime;
    @FieldPosition(value=61)
    private String threadPoolName;
    @FieldPosition(value=62)
    private boolean endSegment;

    public RequestSegmentData() {
    }

    public RequestSegmentData(TransactionSnapshot snapshot) {
        this();
        this.id = snapshot.getId();
        this.applicationComponentId = snapshot.getApplicationComponentId();
        this.applicationComponentNodeId = snapshot.getApplicationNodeId();
        this.businessTransactionId = snapshot.getBusinessTransactionId();
        this.callChain = snapshot.getCallChain();
        this.cpuTimeTakenInMilliSecs = snapshot.getTimeTakenInMilliSecs();
        this.deepDivePolicy = snapshot.getPolicy();
        this.delayedDeepDive = snapshot.isDelayedSnapshot();
        this.delayedDeepDiveOffSet = snapshot.getOffsetFromStart();
        this.diagnosticSessionGUID = snapshot.getSessionGuid();
        this.errorDetails = new NameValuePair[]{new NameValuePair("Error", snapshot.getErrorDetail())};
        this.errorOccured = snapshot.isErrorOccured();
        this.exitCallsDataTruncated = snapshot.isExitCallsDataTruncated();
        this.exitCallsDataTruncationMessage = snapshot.getExitCallsDataTruncationMessage();
        this.firstInChain = snapshot.isFirstInChain();
        this.localID = snapshot.getLocalID();
        this.localStartTime = snapshot.getStartTime();
        this.requestGUID = snapshot.getSnapshotGuid();
        this.serverStartTime = snapshot.getStartTime();
        this.snapshotData = snapshot.getData();
        this.snapshotExitCalls = snapshot.getSnapshotExitCalls();
        if (this.snapshotExitCalls == null) {
            this.snapshotExitCalls = new SnapshotExitCall[0];
        }
        this.snapshotExitSequence = snapshot.getSnapshotExitSequence();
        this.summary = snapshot.getReason();
        this.timeTakenInMilliSecs = snapshot.getTimeTakenInMilliSecs();
        this.transactionProperties = snapshot.getTransactionProperties();
        this.userExperience = snapshot.isDelayedSnapshot() ? EnumHelper.getNameForEnumConstant(RequestUserExperience.SLOW, RequestUserExperience.SLOW) : EnumHelper.getNameForEnumConstant(RequestUserExperience.NORMAL, RequestUserExperience.NORMAL);
        this.hasDeepDiveData = true;
        this.endToEndLatency = -1L;
    }

    public long getEndToEndLatency() {
        return this.endToEndLatency;
    }

    public void setEndToEndLatency(long endToEndLatency) {
        this.endToEndLatency = endToEndLatency;
    }

    public String getEndToEndUserExperience() {
        return this.endToEndUserExperience;
    }

    public void setEndToEndUserExperience(String endToEndUserExperience) {
        this.endToEndUserExperience = endToEndUserExperience;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public UserComment[] getUserComments() {
        return this.userComments;
    }

    public void setUserComments(UserComment[] userComments) {
        this.userComments = userComments;
    }

    public String getRequestGUID() {
        return this.requestGUID;
    }

    public void setRequestGUID(String requestGUID) {
        this.requestGUID = requestGUID;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getBusinessTransactionId() {
        return this.businessTransactionId;
    }

    public void setBusinessTransactionId(long businessTranactionId) {
        this.businessTransactionId = businessTranactionId;
    }

    public long getApplicationComponentId() {
        return this.applicationComponentId;
    }

    public void setApplicationComponentId(long applicationComponentId) {
        this.applicationComponentId = applicationComponentId;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    public long getApplicationComponentNodeId() {
        return this.applicationComponentNodeId;
    }

    public void setApplicationComponentNodeId(long applicationComponentNodeId) {
        this.applicationComponentNodeId = applicationComponentNodeId;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public void setThreadID(String threadID) {
        this.threadID = threadID;
    }

    public long getServerStartTime() {
        return this.serverStartTime;
    }

    public void setServerStartTime(long serverStartTime) {
        this.serverStartTime = serverStartTime;
    }

    public long getLocalStartTime() {
        return this.localStartTime;
    }

    public void setLocalStartTime(long localStartTime) {
        this.localStartTime = localStartTime;
    }

    public boolean isFirstInChain() {
        return this.firstInChain;
    }

    public void setFirstInChain(boolean firstInChain) {
        this.firstInChain = firstInChain;
    }

    public String getCallChain() {
        return this.callChain;
    }

    public void setCallChain(String callChain) {
        this.callChain = callChain;
    }

    public int getLocalID() {
        return this.localID;
    }

    public void setLocalID(int localID) {
        this.localID = localID;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }

    public boolean isHasDeepDiveData() {
        return this.hasDeepDiveData;
    }

    public void setHasDeepDiveData(boolean hasDeepDiveData) {
        this.hasDeepDiveData = hasDeepDiveData;
    }

    public String getUserExperience() {
        return this.userExperience;
    }

    public void setUserExperience(String userExperience) {
        this.userExperience = userExperience;
    }

    public int getTimeTakenInMilliSecs() {
        return this.timeTakenInMilliSecs;
    }

    public void setTimeTakenInMilliSecs(int timeTakenInMilliSecs) {
        this.timeTakenInMilliSecs = timeTakenInMilliSecs;
    }

    public String getWarningThreshold() {
        return this.warningThreshold;
    }

    public void setWarningThreshold(String warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    public String getCriticalThreshold() {
        return this.criticalThreshold;
    }

    public void setCriticalThreshold(String criticalThreshold) {
        this.criticalThreshold = criticalThreshold;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getErrorSummary() {
        return this.errorSummary;
    }

    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    public String getDiagnosticSessionGUID() {
        return this.diagnosticSessionGUID;
    }

    public void setDiagnosticSessionGUID(String sessionGUID) {
        this.diagnosticSessionGUID = sessionGUID;
    }

    public String getDeepDivePolicy() {
        return this.deepDivePolicy;
    }

    public void setDeepDivePolicy(String deepDivePolicy) {
        this.deepDivePolicy = deepDivePolicy;
    }

    public boolean isDelayedDeepDive() {
        return this.delayedDeepDive;
    }

    public void setDelayedDeepDive(boolean delayedDeepDive) {
        this.delayedDeepDive = delayedDeepDive;
    }

    public int getDelayedDeepDiveOffSet() {
        return this.delayedDeepDiveOffSet;
    }

    public void setDelayedDeepDiveOffSet(int delayedDeepDiveOffSet) {
        this.delayedDeepDiveOffSet = delayedDeepDiveOffSet;
    }

    public TransactionSnapshotData getSnapshotData() {
        return this.snapshotData;
    }

    public void setSnapshotData(TransactionSnapshotData snapshotData) {
        this.snapshotData = snapshotData;
    }

    public String getStallDump() {
        return this.stallDump;
    }

    public void setStallDump(String stallDump) {
        this.stallDump = stallDump;
    }

    public NameValuePair[] getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(NameValuePair[] errorDetails) {
        this.errorDetails = errorDetails;
    }

    public String getSnapshotExitSequence() {
        return this.snapshotExitSequence;
    }

    public void setSnapshotExitSequence(String snapshotExitSequence) {
        this.snapshotExitSequence = snapshotExitSequence;
    }

    public SnapshotExitCall[] getSnapshotExitCalls() {
        return this.snapshotExitCalls;
    }

    public void setSnapshotExitCalls(SnapshotExitCall[] snapshotExitCalls) {
        this.snapshotExitCalls = snapshotExitCalls;
    }

    public boolean isExitCallsDataTruncated() {
        return this.exitCallsDataTruncated;
    }

    public void setExitCallsDataTruncated(boolean exitCallsDataTruncated) {
        this.exitCallsDataTruncated = exitCallsDataTruncated;
    }

    public String getExitCallsDataTruncationMessage() {
        return this.exitCallsDataTruncationMessage;
    }

    public void setExitCallsDataTruncationMessage(String exitCallsDataTruncationMessage) {
        this.exitCallsDataTruncationMessage = exitCallsDataTruncationMessage;
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public String getHttpSessionID() {
        return this.httpSessionID;
    }

    public void setHttpSessionID(String sessionID) {
        this.httpSessionID = sessionID;
    }

    public String getSecurityID() {
        return this.securityID;
    }

    public void setSecurityID(String securityID) {
        this.securityID = securityID;
    }

    public NameValuePair[] getHttpParameters() {
        return this.httpParameters;
    }

    public void setHttpParameters(NameValuePair[] httpParameters) {
        this.httpParameters = httpParameters;
    }

    public NameValuePair[] getBusinessData() {
        return this.businessData;
    }

    public void setBusinessData(NameValuePair[] businessData) {
        this.businessData = businessData;
    }

    public NameValuePair[] getCookies() {
        return this.cookies;
    }

    public void setCookies(NameValuePair[] cookies) {
        this.cookies = cookies;
    }

    public NameValuePair[] getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(NameValuePair[] httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public NameValuePair[] getSessionKeys() {
        return this.sessionKeys;
    }

    public void setSessionKeys(NameValuePair[] sessionKeys) {
        this.sessionKeys = sessionKeys;
    }

    public NameValuePair[] getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(NameValuePair[] responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public NameValuePair[] getLogMessages() {
        return this.logMessages;
    }

    public void setLogMessages(NameValuePair[] logMessages) {
        this.logMessages = logMessages;
    }

    public NameValuePair[] getTransactionProperties() {
        return this.transactionProperties;
    }

    public void setTransactionProperties(NameValuePair[] transactionProperties) {
        this.transactionProperties = transactionProperties;
    }

    public NameValuePair[] getTransactionEvents() {
        return this.transactionEvents;
    }

    public void setTransactionEvents(NameValuePair[] transactionEvents) {
        this.transactionEvents = transactionEvents;
    }

    public long getCpuTimeTakenInMilliSecs() {
        return this.cpuTimeTakenInMilliSecs;
    }

    public void setCpuTimeTakenInMilliSecs(long cpuTimeTakenInMilliSecs) {
        this.cpuTimeTakenInMilliSecs = cpuTimeTakenInMilliSecs;
    }

    public long[] getErrorIDs() {
        return this.errorIDs;
    }

    public void setErrorIDs(long[] errorIDs) {
        this.errorIDs = errorIDs;
    }

    public void validate() throws IllegalArgumentException {
        if (this.timeTakenInMilliSecs < 0 && this.timeTakenInMilliSecs != -1) {
            throw new IllegalArgumentException("Negative value for 'timeTakenInMillis' for Request Data ");
        }
        if (this.localStartTime < 0L) {
            throw new IllegalArgumentException("Negative value for 'localstarttime' for Reqest Data");
        }
        if (this.delayedDeepDiveOffSet < 0) {
            throw new IllegalArgumentException("Negative value for 'DelayedDeepDiveOffset' for Request Data");
        }
        if (this.cpuTimeTakenInMilliSecs < 0L) {
            throw new IllegalArgumentException("Negative value for 'CpuTimeTakenInMilliSecs' for Request Data");
        }
        if (this.userExperience == null) {
            throw new IllegalArgumentException("User experience is not set");
        }
        for (SnapshotExitCall exitcall : this.snapshotExitCalls) {
            int exitCallTime = exitcall.getTimeTakenInMillis();
            if (exitCallTime < 0 && exitCallTime != -1) {
                throw new IllegalArgumentException("Negative value for 'timeTakenInMillis' for Snapshot exit call");
            }
            if (exitcall.getErrorCount() >= 0) continue;
            throw new IllegalArgumentException("Negative value for 'ErrorCount' for Snapshot exit call");
        }
    }

    public int countProps() {
        int count = 0;
        if (this.errorDetails != null) {
            count += this.errorDetails.length;
        }
        if (this.httpParameters != null) {
            count += this.httpParameters.length;
        }
        if (this.businessData != null) {
            count += this.businessData.length;
        }
        if (this.cookies != null) {
            count += this.cookies.length;
        }
        if (this.httpHeaders != null) {
            count += this.httpHeaders.length;
        }
        if (this.sessionKeys != null) {
            count += this.sessionKeys.length;
        }
        if (this.responseHeaders != null) {
            count += this.responseHeaders.length;
        }
        if (this.logMessages != null) {
            count += this.logMessages.length;
        }
        if (this.transactionProperties != null) {
            count += this.transactionProperties.length;
        }
        if (this.transactionEvents != null) {
            count += this.transactionEvents.length;
        }
        if (this.dotnetProperty != null) {
            count += this.dotnetProperty.length;
        }
        return count;
    }

    public boolean isUnresolvedCallInCallChain() {
        return this.unresolvedCallInCallChain;
    }

    public void setUnresolvedCallInCallChain(boolean unresolvedCallInCallChain) {
        this.unresolvedCallInCallChain = unresolvedCallInCallChain;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public NameValuePair[] getDotnetProperty() {
        return this.dotnetProperty;
    }

    public void setDotnetProperty(NameValuePair[] dotnetProperty) {
        this.dotnetProperty = dotnetProperty;
    }

    public void setProperty(String type, String name, String value, long numProp, String strProp) {
        if (type == null) {
            return;
        }
        if (type.equals(ERROR_DETAIL)) {
            this.setErrorDetails(this.setProperty(this.getErrorDetails(), name, value));
        } else if (type.equals(ERROR_IDS)) {
            long[] oldIds = this.getErrorIDs();
            if (oldIds == null) {
                oldIds = new long[]{};
            }
            long[] newIds = new long[oldIds.length + 1];
            for (int pos = 0; pos < oldIds.length; ++pos) {
                newIds[pos] = oldIds[pos];
            }
            newIds[pos] = numProp;
            this.setErrorIDs(newIds);
        } else if (type.equals(SEP_IDS)) {
            long[] newSEPIds;
            long[] sepIds = this.getServiceEndPointIds();
            if (sepIds == null) {
                newSEPIds = new long[]{numProp};
            } else {
                newSEPIds = new long[sepIds.length + 1];
                System.arraycopy(sepIds, 0, newSEPIds, 0, sepIds.length);
                newSEPIds[sepIds.length] = numProp;
            }
            this.setServiceEndPointIds(newSEPIds);
        } else if (type.equals(HTTP_PARAMETER)) {
            this.setHttpParameters(this.setProperty(this.getHttpParameters(), name, value));
        } else if (type.equals(BUSINESS_DATA)) {
            this.setBusinessData(this.setProperty(this.getBusinessData(), name, value));
        } else if (type.equals(COOKIE)) {
            this.setCookies(this.setProperty(this.getCookies(), name, value));
        } else if (type.equals(HTTP_HEADER)) {
            this.setHttpHeaders(this.setProperty(this.getHttpHeaders(), name, value));
        } else if (type.equals(SESSION_KEY)) {
            this.setSessionKeys(this.setProperty(this.getSessionKeys(), name, value));
        } else if (type.equals(RESPONSE_HEADER)) {
            this.setResponseHeaders(this.setProperty(this.getResponseHeaders(), name, value));
        } else if (type.equals(LOG_MESSAGE)) {
            this.setLogMessages(this.setProperty(this.getLogMessages(), name, value));
        } else if (type.equals(TRANSACTION_PROPERTY)) {
            if (name.equals(THREAD_POOL_NAME)) {
                this.setThreadPoolName(value);
            } else if (name.equals(THREAD_POOL_WAIT_TIME)) {
                this.setThreadPoolWaitTime(StringOperations.safeParseLong(value, 0L));
            } else if (name.equals(END_SEGMENT)) {
                this.setEndSegment(StringOperations.parseBooleanStr(value));
            } else {
                this.setTransactionProperties(this.setProperty(this.getTransactionProperties(), name, value));
            }
        } else if (type.equals(TRANSACTION_EVENT)) {
            this.setTransactionEvents(this.setProperty(this.getTransactionEvents(), name, value));
        } else if (type.equals(DOTNET_PROPS)) {
            this.setDotnetProperty(this.setProperty(this.getDotnetProperty(), name, value));
        } else if (type.equals(STACK_TRACES)) {
            StackTrace trace = new StackTrace();
            trace.setApplicationDiagnosticDataId(numProp);
            trace.setExceptionMessage(value);
            this.addStackTrace(trace);
        } else if (type.equals(E2E_LATENCY_TYPE)) {
            this.setEndToEndLatency(numProp);
            this.setEndToEndUserExperience(strProp);
        } else {
            throw new IllegalArgumentException("Illegal property type for Request Object: " + type);
        }
    }

    private void addStackTrace(StackTrace trace) {
        StackTrace[] oldTraces = this.getStackTraces();
        if (oldTraces == null) {
            oldTraces = new StackTrace[]{};
        }
        StackTrace[] newTraces = new StackTrace[oldTraces.length + 1];
        for (int pos = 0; pos < oldTraces.length; ++pos) {
            newTraces[pos] = oldTraces[pos];
        }
        newTraces[pos] = trace;
        this.setStackTraces(newTraces);
    }

    private NameValuePair[] setProperty(NameValuePair[] pair, String name, String value) {
        if (pair == null) {
            pair = new NameValuePair[]{};
        }
        NameValuePair[] newPair = new NameValuePair[pair.length + 1];
        for (int pos = 0; pos < pair.length; ++pos) {
            newPair[pos] = pair[pos];
        }
        newPair[pos] = new NameValuePair(name, value);
        return newPair;
    }

    public StackTrace[] getStackTraces() {
        return this.stackTraces;
    }

    public void setStackTraces(StackTrace[] stacktraces) {
        this.stackTraces = stacktraces;
    }

    public long[] getServiceEndPointIds() {
        return this.serviceEndPointIds;
    }

    public void setServiceEndPointIds(long[] serviceEndPointIds) {
        this.serviceEndPointIds = serviceEndPointIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestSegmentData");
        sb.append("{id=").append(this.id);
        sb.append(", requestGUID='").append(this.requestGUID).append('\'');
        sb.append(", businessTransactionId=").append(this.businessTransactionId);
        sb.append(", applicationId=").append(this.applicationId);
        sb.append(", applicationComponentId=").append(this.applicationComponentId);
        sb.append(", applicationComponentNodeId=").append(this.applicationComponentNodeId);
        sb.append('\n');
        sb.append(", async=").append(this.async);
        sb.append(", threadID='").append(this.threadID).append('\'');
        sb.append(", threadName='").append(this.threadName).append('\'');
        sb.append(", localStartTime=").append(this.localStartTime);
        sb.append(", serverStartTime=").append(this.serverStartTime);
        sb.append(", firstInChain=").append(this.firstInChain);
        sb.append(", callChain='").append(this.callChain).append('\'');
        sb.append(", snapshotExitSequence='").append(this.snapshotExitSequence).append('\'');
        if (this.snapshotExitCalls != null) {
            sb.append(", snapshotExitCalls='").append(CollectionHelper.collectionToString(CollectionHelper.asList(this.snapshotExitCalls))).append('\'');
        }
        sb.append(", localID=").append(this.localID);
        sb.append('\n');
        sb.append(", errorOccured=").append(this.errorOccured);
        sb.append(", hasDeepDiveData=").append(this.hasDeepDiveData);
        sb.append(", userExperience='").append(this.userExperience).append('\'');
        sb.append(", e2eUserExperience='").append(this.endToEndUserExperience).append('\'');
        sb.append(", timeTakenInMilliSecs=").append(this.timeTakenInMilliSecs);
        sb.append(", e2eLatency=").append(this.endToEndLatency);
        sb.append(", cpuTimeTakenInMilliSecs=").append(this.cpuTimeTakenInMilliSecs);
        sb.append(", warningThreshold='").append(this.warningThreshold).append('\'');
        sb.append(", criticalThreshold='").append(this.criticalThreshold).append('\'');
        sb.append(", threadPoolWaitTime='").append(this.threadPoolWaitTime).append('\'');
        sb.append(", threadPoolName='").append(this.threadPoolName).append('\'');
        sb.append(", endSegment='").append(this.endSegment).append('\'');
        if (null != this.serviceEndPointIds) {
            sb.append(", serviceEndPointIds='").append(CollectionHelper.collectionToString(CollectionHelper.asList(new long[][]{this.serviceEndPointIds}))).append('\'');
        }
        sb.append('\n');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestSegmentData that = (RequestSegmentData)o;
        if (this.callChain != null ? !this.callChain.equals(that.callChain) : that.callChain != null) {
            return false;
        }
        return !(this.requestGUID != null ? !this.requestGUID.equals(that.requestGUID) : that.requestGUID != null);
    }

    public int hashCode() {
        int result = this.requestGUID != null ? this.requestGUID.hashCode() : 0;
        result = 31 * result + (this.callChain != null ? this.callChain.hashCode() : 0);
        return result;
    }

    public long getTotalWaitTime() {
        return this.totalWaitTime;
    }

    public void setTotalWaitTime(long totalWaitTime) {
        this.totalWaitTime = totalWaitTime;
    }

    public long getTotalBlockTime() {
        return this.totalBlockTime;
    }

    public void setTotalBlockTime(long totalBlockTime) {
        this.totalBlockTime = totalBlockTime;
    }

    public String getAsyncActivity() {
        return this.asyncActivity;
    }

    public void setAsyncActivity(String asyncActivity) {
        this.asyncActivity = asyncActivity;
    }

    public long getThreadPoolWaitTime() {
        return this.threadPoolWaitTime;
    }

    public void setThreadPoolWaitTime(long threadPoolWaitTime) {
        this.threadPoolWaitTime = threadPoolWaitTime;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public boolean isEndSegment() {
        return this.endSegment;
    }

    public void setEndSegment(boolean endSegment) {
        this.endSegment = endSegment;
    }
}

