/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.AllocationElement;
import com.singularity.ee.util.collections.ILinkedList;
import com.singularity.ee.util.collections.LinkedListImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class ProcessAllocationGraph
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private int totalElementCount;
    @IgnoreProtoGen
    private transient ILinkedList<AllocationElement> allocationElementQueue;
    @FieldPosition(value=4)
    private transient int numRoots;
    @FieldPosition(value=5)
    private AllocationElement[] roots;
    @FieldPosition(value=6)
    private transient AllocationElement[] procAllocationGraphRoots;

    public int getTotalElementCount() {
        return this.totalElementCount;
    }

    public void setTotalElementCount(int totalElementCount) {
        this.totalElementCount = totalElementCount;
    }

    public ILinkedList<AllocationElement> getAllocationElementQueue() {
        return this.allocationElementQueue;
    }

    public void setAllocationElementQueue(ILinkedList<AllocationElement> allocationElementQueue) {
        this.allocationElementQueue = allocationElementQueue;
    }

    public int getNumRoots() {
        return this.numRoots;
    }

    public void setNumRoots(int numRoots) {
        this.numRoots = numRoots;
    }

    public AllocationElement[] getRoots() {
        return this.roots;
    }

    public void setRoots(AllocationElement[] roots) {
        this.roots = roots;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(" : root allocation element :");
        if (this.roots == null) {
            return builder.toString();
        }
        for (AllocationElement root : this.roots) {
            builder.append(root + "\n");
        }
        return builder.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.numRoots);
        this.roots = null;
        if (this.numRoots > 0) {
            ProcessAllocationGraph.flattenAllocationElementsFromQueue(out, this.allocationElementQueue);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.numRoots = in.readInt();
        if (this.numRoots > 0) {
            int counter = 0;
            LinkedListImpl<AllocationEleTreeDeserializationHelper> allocationElementQueue = new LinkedListImpl<AllocationEleTreeDeserializationHelper>();
            AllocationElement dummyAllocEle = new AllocationElement();
            allocationElementQueue.addFirst(new AllocationEleTreeDeserializationHelper(dummyAllocEle, this.numRoots));
            while (!allocationElementQueue.isEmpty()) {
                AllocationEleTreeDeserializationHelper helper = (AllocationEleTreeDeserializationHelper)allocationElementQueue.removeLast();
                AllocationElement currentAllocEle = helper.allocationElement;
                int numChildren = helper.numChildren;
                if (numChildren >= 0) {
                    AllocationElement[] children = new AllocationElement[numChildren];
                    for (int i = 0; i < numChildren; ++i) {
                        AllocationElement childAllocEle;
                        children[i] = childAllocEle = (AllocationElement)in.readObject();
                        if (counter < this.numRoots) {
                            this.roots[counter++] = childAllocEle;
                        }
                        allocationElementQueue.addFirst(new AllocationEleTreeDeserializationHelper(childAllocEle, in.readInt()));
                    }
                    currentAllocEle.setChildren(children);
                    continue;
                }
                currentAllocEle.setChildren(null);
            }
        } else {
            this.roots = new AllocationElement[0];
        }
    }

    public static void flattenAllocationElementsFromQueue(ObjectOutputStream out, ILinkedList<AllocationElement> allocationElementQueue) throws IOException {
        while (!allocationElementQueue.isEmpty()) {
            AllocationElement currentAllocEle = (AllocationElement)allocationElementQueue.remove();
            int numChildren = currentAllocEle.getNumChildren();
            currentAllocEle.setChildren(null);
            out.writeObject(currentAllocEle);
            out.writeInt(numChildren);
        }
    }

    public AllocationElement[] getProcAllocationGraphRoots() {
        return this.procAllocationGraphRoots;
    }

    public void setProcAllocationGraphRoots(AllocationElement[] procAllocationGraphRoots) {
        this.procAllocationGraphRoots = procAllocationGraphRoots;
    }

    public static class AllocationEleTreeDeserializationHelper {
        public final AllocationElement allocationElement;
        public final int numChildren;

        public AllocationEleTreeDeserializationHelper(AllocationElement allocationElement, int numChildren) {
            this.allocationElement = allocationElement;
            this.numChildren = numChildren;
        }
    }
}

