/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.transactionmonitor;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.CallElement;
import com.singularity.ee.controller.api.dto.transactionmonitor.CallElementCache;
import com.singularity.ee.controller.api.dto.transactionmonitor.HotspotCallGraph;
import com.singularity.ee.util.collections.ILinkedList;
import com.singularity.ee.util.collections.LinkedListImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

@GenProto(protoFile="TransactionMonitor.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class CallGraph
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private CallElement root;
    @FieldPosition(value=3)
    private boolean customSerialized;
    @FieldPosition(value=4)
    private boolean dataTruncated;
    @FieldPosition(value=5)
    private String dataTruncationMessage;
    @FieldPosition(value=6)
    private String excludedPackages;
    @FieldPosition(value=7)
    private int totalElementCount;
    @FieldPosition(value=8)
    private NameValuePair[] nameValuePair;
    @IgnoreProtoGen
    private HotspotCallGraph hotspotCallGraph;
    @FieldPosition(value=9)
    private boolean cpuTimeEnabled;
    @IgnoreProtoGen
    private boolean extendedCpuTimeEnabled;
    @IgnoreProtoGen
    private ArrayList<String> stacktraceElements;
    @IgnoreProtoGen
    private transient ILinkedList<CallElement> callElementQueue;
    @IgnoreProtoGen
    public static final String BT_OR_SEP_ACTIVE = "BT-OR-SEP-ACTIVE";
    @IgnoreProtoGen
    public static final String TIMESTAMP = "SAMPLE_TIMESTAMP";
    @IgnoreProtoGen
    public static final String RESPONSE_TIME = "RESPONSE_TIME";
    @IgnoreProtoGen
    public static final String URL = "URL";
    @IgnoreProtoGen
    public static final String DELIMITER = ":";
    @IgnoreProtoGen
    public static final String EXIT_POINT_TYPE = "exitPointType";
    @IgnoreProtoGen
    public static final String DEFAULT_CALL_GRAPH_NAME = "defaultClass:method";
    @IgnoreProtoGen
    public static final String GUID = "GUID";

    public void setRoot(CallElement root) {
        this.root = root;
    }

    public CallElement getRoot() {
        return this.root;
    }

    public void setDataTruncated(boolean dataTruncated) {
        this.dataTruncated = dataTruncated;
    }

    public boolean isDataTruncated() {
        return this.dataTruncated;
    }

    public void setDataTruncationMessage(String dataTruncationMessage) {
        this.dataTruncationMessage = dataTruncationMessage;
    }

    public String getDataTruncationMessage() {
        return this.dataTruncationMessage;
    }

    public String getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(String excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public void setTotalElementCount(int totalElementCount) {
        this.totalElementCount = totalElementCount;
    }

    public int getTotalElementCount() {
        return this.totalElementCount;
    }

    public NameValuePair[] getNameValuePair() {
        return this.nameValuePair;
    }

    public void setNameValuePair(NameValuePair[] nameValuePair) {
        this.nameValuePair = nameValuePair;
    }

    public boolean isCustomSerialized() {
        return this.customSerialized;
    }

    public void setCustomSerialized(boolean customSerialized) {
        this.customSerialized = customSerialized;
    }

    public ILinkedList<CallElement> getCallElementQueue() {
        return this.callElementQueue;
    }

    public void setCallElementQueue(ILinkedList<CallElement> callElementQueue) {
        this.callElementQueue = callElementQueue;
    }

    public ArrayList<String> getStacktraceElements() {
        return this.stacktraceElements;
    }

    public void setStacktraceElements(ArrayList<String> stacktraceElements) {
        this.stacktraceElements = stacktraceElements;
    }

    public String toString() {
        return super.toString() + " : root call element :" + this.root;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.customSerialized = this.root != null;
        CallElement tmpRoot = this.root;
        this.root = null;
        out.defaultWriteObject();
        if (this.callElementQueue == null) {
            if (tmpRoot != null) {
                out.writeBoolean(true);
                LinkedListImpl<CallElement> callElementList = new LinkedListImpl<CallElement>();
                callElementList.addFirst(tmpRoot);
                while (!callElementList.isEmpty()) {
                    CallElement currentCallEle = (CallElement)callElementList.removeLast();
                    CallElement[] children = currentCallEle.getChildren();
                    currentCallEle.setChildren(null);
                    int numChildren = children.length == 0 ? -1 : children.length;
                    for (int i = 0; i < numChildren; ++i) {
                        callElementList.addFirst(children[i]);
                    }
                    out.writeObject(currentCallEle);
                    out.writeInt(numChildren);
                    CallElementCache.release(currentCallEle);
                }
            } else {
                out.writeBoolean(false);
            }
        } else if (tmpRoot != null) {
            out.writeBoolean(true);
            CallGraph.flattenCallElementsFromQueue(out, this.callElementQueue);
        } else {
            out.writeBoolean(false);
        }
    }

    public static void flattenCallElementsFromQueue(ObjectOutputStream out, ILinkedList<CallElement> callElementQueue) throws IOException {
        while (!callElementQueue.isEmpty()) {
            CallElement currentCallEle = (CallElement)callElementQueue.remove();
            int numChildren = currentCallEle.getNumOfChildren();
            currentCallEle.setChildren(null);
            out.writeObject(currentCallEle);
            out.writeInt(numChildren);
            CallElementCache.release(currentCallEle);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.customSerialized && this.hotspotCallGraph == null) {
            boolean isRootSpecified = in.readBoolean();
            if (isRootSpecified) {
                LinkedListImpl<CallElementTreeDeserializationHelper> callElementQueue = new LinkedListImpl<CallElementTreeDeserializationHelper>();
                CallElement nextCallEle = (CallElement)in.readObject();
                callElementQueue.addFirst(new CallElementTreeDeserializationHelper(nextCallEle, in.readInt()));
                this.root = nextCallEle;
                while (!callElementQueue.isEmpty()) {
                    CallElementTreeDeserializationHelper helper = (CallElementTreeDeserializationHelper)callElementQueue.removeLast();
                    CallElement currentCallEle = helper.callElement;
                    int numChildren = helper.numChildren;
                    if (numChildren >= 0) {
                        CallElement[] children = new CallElement[numChildren];
                        for (int i = 0; i < numChildren; ++i) {
                            CallElement childCallEle;
                            children[i] = childCallEle = (CallElement)in.readObject();
                            callElementQueue.addFirst(new CallElementTreeDeserializationHelper(childCallEle, in.readInt()));
                        }
                        currentCallEle.setChildren(children);
                        continue;
                    }
                    currentCallEle.setChildren(null);
                }
            } else {
                this.root = null;
            }
        } else if (this.hotspotCallGraph != null) {
            this.root = this.hotspotCallGraph.createCallElementTree(0);
            this.hotspotCallGraph = null;
        }
    }

    public HotspotCallGraph getHotspotCallGraph() {
        return this.hotspotCallGraph;
    }

    public void setHotspotCallGraph(HotspotCallGraph hotspotCallGraph) {
        this.hotspotCallGraph = hotspotCallGraph;
    }

    public void setCpuTimeEnabled(boolean cpuTimeEnabled) {
        this.cpuTimeEnabled = cpuTimeEnabled;
    }

    public boolean isCpuTimeEnabled() {
        return this.cpuTimeEnabled;
    }

    public void setExtendedCpuTimeEnabled(boolean extendedCpuTimeEnabled) {
        this.extendedCpuTimeEnabled = extendedCpuTimeEnabled;
    }

    public boolean isExtendedCpuTimeEnabled() {
        return this.extendedCpuTimeEnabled;
    }

    public CallGraph deepCopyCallElement() {
        CallGraph newObj = new CallGraph();
        newObj.setNameValuePair(this.nameValuePair);
        if (this.root != null) {
            newObj.setRoot(this.root.deepCopy());
        }
        if (this.stacktraceElements != null) {
            newObj.setStacktraceElements(new ArrayList<String>(this.stacktraceElements));
        }
        return newObj;
    }

    public void populateStackTraceFromCallElement() {
        ArrayList<String> stacktraceElements = new ArrayList<String>();
        CallElement callElement = this.getRoot();
        while (callElement != null) {
            stacktraceElements.add(callElement.getClassName() + DELIMITER + callElement.getMethodName() + DELIMITER + callElement.getLineNumber());
            CallElement[] children = callElement.getChildren();
            if (children != null && children.length > 0) {
                callElement = children[0];
                continue;
            }
            callElement = null;
        }
        this.stacktraceElements = stacktraceElements;
        this.root = null;
    }

    public static class CallElementTreeDeserializationHelper {
        public final CallElement callElement;
        public final int numChildren;

        public CallElementTreeDeserializationHelper(CallElement callElement, int numChildren) {
            this.callElement = callElement;
            this.numChildren = numChildren;
        }
    }
}

