/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.dbmon;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.dbmon.DBServerType;
import java.util.HashMap;
import java.util.Map;

@IgnoreProtoGen
@UiCodeGen
@TSCodeGen(exclude=true)
public enum BucketStatType {
    COUCH_TOTAL_DISK_SIZE(1),
    HIT_RATIO(4),
    BYTES_READ(5),
    BYTES_WRITTEN(6),
    CMD_GET(7),
    CMD_SET(8),
    OPS(16);

    private static Map<Integer, BucketStatType> idToStatType;
    private int id;
    private DBServerType dbType;

    public static BucketStatType valueOf(int id) {
        return idToStatType.get(id);
    }

    private BucketStatType(int id) {
        this.id = id;
        this.dbType = DBServerType.COUCHBASE;
    }

    public DBServerType dbType() {
        return this.dbType;
    }

    public int id() {
        return this.id;
    }

    public static BucketStatType[] bucketStatTypesForServerType(DBServerType dbType) {
        if (dbType == DBServerType.COUCHBASE) {
            return BucketStatType.values();
        }
        return null;
    }

    static {
        idToStatType = new HashMap<Integer, BucketStatType>();
        for (BucketStatType statType : BucketStatType.values()) {
            DBServerType type = statType.dbType();
            Integer id = statType.id();
            if (idToStatType.containsKey(id)) {
                throw new IllegalArgumentException("There are multiple BucketStatTypes with the same ID. Both " + (Object)((Object)idToStatType.get(id)) + " and " + (Object)((Object)statType) + " have an ID of " + id + ".");
            }
            idToStatType.put(id, statType);
        }
    }
}

