/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.dbmon;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.dbmon.BucketStatType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@IgnoreProtoGen
@TSCodeGen(exclude=true)
public class BucketStatMeasurement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long timestamp;
    private long bucketId;
    private long serverId;
    private Map<Integer, Number> values;

    public Map<Integer, Number> getValues() {
        return this.values;
    }

    public void setValues(Map<Integer, Number> values) {
        this.values = values;
    }

    public void setBucketId(long bucketId) {
        this.bucketId = bucketId;
    }

    public long getBucketId() {
        return this.bucketId;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public BucketStatMeasurement addValue(BucketStatType type, Long value) {
        if (this.values == null) {
            this.values = new HashMap<Integer, Number>();
        }
        this.values.put(type.id(), value);
        return this;
    }

    public void addAllValues(Map<BucketStatType, Long> valuesToAdd) {
        for (Map.Entry<BucketStatType, Long> entry : valuesToAdd.entrySet()) {
            this.addValue(entry.getKey(), entry.getValue());
        }
    }

    public Long statValueAsLong(BucketStatType stat) {
        Long value = 0L;
        Number number = this.values.get(stat.id());
        if (number != null) {
            value = number.longValue();
        }
        return value;
    }

    public String statValueAsString(BucketStatType stat) {
        String value = null;
        Number obj = this.values.get(stat.id());
        if (obj != null) {
            value = String.valueOf(obj);
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BucketStatMeasurement{");
        sb.append("timestamp=").append(this.timestamp);
        sb.append(", bucketId=").append(this.bucketId);
        sb.append(", serverId=").append(this.serverId);
        sb.append(", values=").append(this.values);
        sb.append('}');
        return sb.toString();
    }
}

