/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.IdentityType;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import java.util.Date;

@GenProto(protoFile="DtoBase.proto")
@UiCodeGen
@TSCodeGen(exclude=true)
public class UserComment
extends APersistentObject {
    @IgnoreProtoGen
    public static final String ARCHIVED_COMMENT = "ARCHIVED";
    @IgnoreProtoGen
    public static final String SYS_NOTIFICATION_READ_COMMENT = "##AD-NOTIFICATION-COMMENT: MARKED AS READ##";
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private String createdBy;
    @FieldPosition(value=3)
    private Date createdOn;
    @FieldPosition(value=4)
    private String comment;
    @FieldPosition(value=5)
    private boolean tagged;
    @FieldPosition(value=6)
    private IdentityType createdByType;

    public boolean isTagged() {
        return this.tagged;
    }

    public void setTagged(boolean tagged) {
        this.tagged = tagged;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCreatedByType(IdentityType createdByType) {
        this.createdByType = createdByType;
    }

    public IdentityType getCreatedByType() {
        return this.createdByType;
    }

    public static UserComment createArchivedUserComment(String identityName, IdentityType identityType) {
        UserComment userComment = new UserComment();
        userComment.setComment(ARCHIVED_COMMENT);
        userComment.setCreatedBy(identityName);
        userComment.setCreatedOn(new Date());
        userComment.setCreatedByType(identityType);
        return userComment;
    }

    public static UserComment createNotificationReadComment(String identityName, IdentityType identityType) {
        UserComment comment = new UserComment();
        comment.setComment(SYS_NOTIFICATION_READ_COMMENT);
        comment.setCreatedBy(identityName);
        comment.setCreatedOn(new Date());
        comment.setCreatedByType(identityType);
        return comment;
    }

    public static boolean isSysNotificationReadCommentByUser(UserComment comment, String userName) {
        return SYS_NOTIFICATION_READ_COMMENT.equals(comment.getComment()) && userName.equals(comment.getCreatedBy());
    }

    public static boolean isSysNotificationReadComment(UserComment comment) {
        return SYS_NOTIFICATION_READ_COMMENT.equals(comment.getComment());
    }
}

