/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.NodeResolutionInfo;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionFlowItemIdentifier;
import com.singularity.ee.util.collections.CollectionHelper;

@GenProto(needsList=true)
@UiCodeGen
@TSCodeGen(exclude=true)
public class UnresolvedBackendCallInfo
extends APersistentObject
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @IgnoreProtoGen
    public static final String UNRESOLVED = "UNRESOLVED";
    @IgnoreProtoGen
    public static final String UNRESOLVED_PREFIX = "{[UNRESOLVED][";
    @IgnoreProtoGen
    public static final String TO_APPLICATION_PREFIX = "App:";
    @IgnoreProtoGen
    public static final String OVERFLOW_BACKEND_IDENTIFYING_PROP_KEY_PREFIX = "All other traffic for ";
    @IgnoreProtoGen
    public static final String OVERFLOW_BACKEND_IDENTIFYING_PROP_VALUE = "Reason: Backend limit reached";
    @IgnoreProtoGen
    public static final String IS_DB2_ZOS = "is-db2-zos";
    @IgnoreProtoGen
    public static final int IDENTIFYING_PROPERTIES_OVERFLOW_LIMIT = 760;
    @IgnoreProtoGen
    private String discovered;
    @FieldPosition(value=2)
    private NodeResolutionInfo resolutionInfo;
    @FieldPosition(value=3)
    private NameValuePair[] metaInfo;
    @FieldPosition(value=4)
    private long applicationId;
    @FieldPosition(value=5)
    private long createdOn;
    @FieldPosition(value=6)
    private String displayName;
    @FieldPosition(value=7)
    private NameValuePair[] visualizationProperties;
    @FieldPosition(value=8)
    private long applicationComponentNodeId;
    @FieldPosition(value=9)
    private long applicationComponentId;
    @FieldPosition(value=10)
    private long destinationApplicationId;

    public UnresolvedBackendCallInfo(NodeResolutionInfo resolutionInfo, long applicationId, NameValuePair ... metaInfo) {
        this.resolutionInfo = resolutionInfo;
        this.applicationId = applicationId;
        this.metaInfo = metaInfo;
    }

    public UnresolvedBackendCallInfo(long id, long applicationComponentId, NodeResolutionInfo resolutionInfo) {
        this(id, applicationComponentId, resolutionInfo, true);
    }

    private UnresolvedBackendCallInfo(long id, long appOrComponentId, NodeResolutionInfo resolutionInfo, boolean isComponent) {
        this(id);
        if (isComponent) {
            this.setApplicationComponentId(appOrComponentId);
        } else {
            this.setDestinationApplicationId(appOrComponentId);
        }
        this.setResolutionInfo(resolutionInfo);
    }

    public static UnresolvedBackendCallInfo createBackendResolvedToApp(long id, long appId, NodeResolutionInfo resolutionInfo) {
        return new UnresolvedBackendCallInfo(id, appId, resolutionInfo, false);
    }

    public static UnresolvedBackendCallInfo createBackendResolvedToTier(long id, long componentId, NodeResolutionInfo resolutionInfo) {
        return new UnresolvedBackendCallInfo(id, componentId, resolutionInfo, true);
    }

    public UnresolvedBackendCallInfo(long id, NodeResolutionInfo resolutionInfo) {
        this(id);
        this.setResolutionInfo(resolutionInfo);
    }

    public UnresolvedBackendCallInfo(UnresolvedBackendCallInfo call) {
        this.applicationId = call.getApplicationId();
        this.displayName = call.getDisplayName();
        this.applicationComponentId = call.getApplicationComponentId();
        this.applicationComponentNodeId = call.getApplicationComponentNodeId();
        this.metaInfo = call.getMetaInfo();
        this.resolutionInfo = call.getResolutionInfo();
        this.visualizationProperties = call.getVisualizationProperties();
        this.createdOn = call.getCreatedOn();
        this.setId(call.getId());
        this.setVersion(call.getVersion());
    }

    public UnresolvedBackendCallInfo() {
    }

    public UnresolvedBackendCallInfo(long id) {
        this.setId(id);
    }

    public String getDiscovered() {
        return this.discovered;
    }

    public void setDiscovered(String discovered) {
        this.discovered = discovered;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    public NodeResolutionInfo getResolutionInfo() {
        return this.resolutionInfo;
    }

    public void setResolutionInfo(NodeResolutionInfo resolutionInfo) {
        this.resolutionInfo = resolutionInfo;
    }

    public NameValuePair[] getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(NameValuePair ... metaInfo) {
        this.metaInfo = metaInfo;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(long createdOn) {
        this.createdOn = createdOn;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setVisualizationProperties(NameValuePair[] visualizationProperties) {
        this.visualizationProperties = visualizationProperties;
    }

    public NameValuePair[] getVisualizationProperties() {
        return this.visualizationProperties;
    }

    public static UnresolvedBackendCallInfo[] getCallsFromNodeResolutionInfos(long applicationId, NodeResolutionInfo ... infos) {
        if (infos == null) {
            return new UnresolvedBackendCallInfo[0];
        }
        UnresolvedBackendCallInfo[] calls = new UnresolvedBackendCallInfo[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            UnresolvedBackendCallInfo call = new UnresolvedBackendCallInfo();
            call.setApplicationId(applicationId);
            call.setResolutionInfo(infos[i]);
            calls[i] = call;
        }
        return calls;
    }

    public long getApplicationComponentId() {
        return this.applicationComponentId;
    }

    public void setApplicationComponentId(long applicationComponentId) {
        this.applicationComponentId = applicationComponentId;
    }

    public long getApplicationComponentNodeId() {
        return this.applicationComponentNodeId;
    }

    public void setApplicationComponentNodeId(long applicationComponentNodeId) {
        this.applicationComponentNodeId = applicationComponentNodeId;
    }

    public long getDestinationApplicationId() {
        return this.destinationApplicationId;
    }

    public void setDestinationApplicationId(long destinationApplicationId) {
        this.destinationApplicationId = destinationApplicationId;
    }

    @Override
    public TransactionFlowItemIdentifier constructTransactionFlowItemIdentifier() {
        TransactionFlowItemIdentifier identifier = new TransactionFlowItemIdentifier();
        identifier.setUnresolvedBackendCallId(this.getId());
        identifier.setComponentIdentifier(false);
        return identifier;
    }

    @Override
    public int hashCode() {
        return new Long(this.getId()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UnresolvedBackendCallInfo) {
            UnresolvedBackendCallInfo other = (UnresolvedBackendCallInfo)obj;
            return this.getId() == other.getId();
        }
        return false;
    }

    public String toUnresolvedString() {
        return UNRESOLVED_PREFIX + this.getId() + "]}";
    }

    public static String getCrossAppResolvedString(long toApplicationId) {
        return TO_APPLICATION_PREFIX + String.valueOf(toApplicationId);
    }

    @Override
    public String toString() {
        return "UnresolvedBackendCallInfo [id=" + this.getId() + ", resolutionInfo=" + this.resolutionInfo + ", metaInfo=" + CollectionHelper.arrayToString(this.metaInfo) + ", applicationId=" + this.applicationId + ", createdOn=" + this.createdOn + ", displayName=" + this.displayName + ", visualizationProperties=" + CollectionHelper.arrayToString(this.visualizationProperties) + ", applicationComponentNodeId=" + this.applicationComponentNodeId + ", applicationComponentId=" + this.applicationComponentId + "]";
    }
}

