/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.InfoPointMetricDefinition;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.MethodInvocationDataGathererConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.POJOMethodDefinition;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.ArrayList;

@GenProto
@UiCodeGen
@TSCodeGen(exclude=true)
public class InstrumentationPoint
extends APersistentObject
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private POJOMethodDefinition methodDefinition;
    @FieldPosition(value=3)
    private InfoPointMetricDefinition[] customMetricDefinitions;
    @FieldPosition(value=4)
    private MethodInvocationDataGathererConfig[] dataGathererConfigurations;
    @FieldPosition(value=5)
    private boolean applyForAllTransactions;
    @FieldPosition(value=6)
    private long[] businessTransactionIds;

    @Override
    public InstrumentationPoint copy() {
        InstrumentationPoint copy = new InstrumentationPoint();
        copy.setMethodDefinition(this.methodDefinition.copy());
        ArrayList<InfoPointMetricDefinition> impDefs = new ArrayList<InfoPointMetricDefinition>();
        for (InfoPointMetricDefinition impDef : this.customMetricDefinitions) {
            impDefs.add(impDef.deepCopy());
        }
        copy.setCustomMetricDefinitions(CollectionHelper.collectionToArray(impDefs, new InfoPointMetricDefinition[impDefs.size()]));
        ArrayList<MethodInvocationDataGathererConfig> midgConfigs = new ArrayList<MethodInvocationDataGathererConfig>();
        for (MethodInvocationDataGathererConfig config : this.dataGathererConfigurations) {
            midgConfigs.add(config.deepCopy());
        }
        copy.setDataGathererConfigurations(CollectionHelper.collectionToArray(midgConfigs, new MethodInvocationDataGathererConfig[midgConfigs.size()]));
        copy.setApplyForAllTransactions(this.applyForAllTransactions);
        copy.setBusinessTransactionIds(this.businessTransactionIds);
        return copy;
    }

    public boolean isApplyForAllTransactions() {
        return this.applyForAllTransactions;
    }

    public void setApplyForAllTransactions(boolean applyForAllTransactions) {
        this.applyForAllTransactions = applyForAllTransactions;
    }

    public long[] getBusinessTransactionIds() {
        return this.businessTransactionIds;
    }

    public void setBusinessTransactionIds(long[] businessTransactionIds) {
        this.businessTransactionIds = businessTransactionIds;
    }

    public MethodInvocationDataGathererConfig[] getDataGathererConfigurations() {
        return this.dataGathererConfigurations;
    }

    public void setDataGathererConfigurations(MethodInvocationDataGathererConfig ... dataGathererConfigurations) {
        this.dataGathererConfigurations = dataGathererConfigurations;
    }

    public InfoPointMetricDefinition[] getCustomMetricDefinitions() {
        return this.customMetricDefinitions;
    }

    public void setCustomMetricDefinitions(InfoPointMetricDefinition ... customMetricDefinitions) {
        this.customMetricDefinitions = customMetricDefinitions;
    }

    public POJOMethodDefinition getMethodDefinition() {
        return this.methodDefinition;
    }

    public void setMethodDefinition(POJOMethodDefinition methodDefinition) {
        this.methodDefinition = methodDefinition;
    }
}

