/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.IEntityDefinition;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.util.enums.EnumHelper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@GenProto(protoFile="DtoBase.proto")
@UiCodeGen
public class EntityDefinition
extends APersistentObject
implements SingularitySerializable,
IEntityDefinition {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private EntityType entityType;
    @FieldPosition(value=3)
    private long entityId;
    @IgnoreProtoGen
    private transient String prettyToString;
    @IgnoreProtoGen
    public static final EntityDefinition[] EMPTY_ARRAY = new EntityDefinition[0];

    public EntityDefinition() {
    }

    public EntityDefinition(EntityType entityType, long entityId) {
        this.setEntityType(entityType);
        this.setEntityId(entityId);
    }

    public EntityDefinition(EntityType entityType) {
        this.entityType = entityType;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    @Override
    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public String getPrettyToString() {
        return this.prettyToString;
    }

    public void setPrettyToString(String prettyToString) {
        this.prettyToString = prettyToString;
    }

    public static Map<EntityType, Set<Long>> convertEntityDefinitionsToMap(EntityDefinition[] entityDefinitions) {
        HashMap<EntityType, Set<Long>> entityType2Ids = new HashMap<EntityType, Set<Long>>();
        if (entityDefinitions != null) {
            for (EntityDefinition entityDefinition : entityDefinitions) {
                HashSet<Long> idSet = (HashSet<Long>)entityType2Ids.get((Object)entityDefinition.getEntityType());
                if (idSet == null) {
                    idSet = new HashSet<Long>();
                    entityType2Ids.put(entityDefinition.getEntityType(), idSet);
                }
                idSet.add(entityDefinition.getEntityId());
            }
        }
        return entityType2Ids;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EntityDefinition) {
            EntityDefinition compareTo = (EntityDefinition)obj;
            if (this.getEntityId() == compareTo.getEntityId()) {
                if (this.getEntityType() == null) {
                    return compareTo.getEntityType() == null;
                }
                return this.getEntityType().equals((Object)compareTo.getEntityType());
            }
        } else if (obj instanceof IEntityDefinition) {
            throw new IllegalArgumentException("Should be calling equalsValue instead");
        }
        return false;
    }

    public static int calculateHashCode(EntityType type, long entityId) {
        int result = 17;
        result = 37 * result + (int)(entityId ^ entityId >>> 32);
        result = 37 * result + (type == null ? 0 : EnumHelper.getOrdinal(type));
        return result;
    }

    @Override
    public int hashCode() {
        return EntityDefinition.calculateHashCode(this.getEntityType(), this.getEntityId());
    }

    @Override
    public String toString() {
        if (this.prettyToString != null) {
            return this.prettyToString;
        }
        return "Type:" + (Object)((Object)this.entityType) + ", id:" + this.entityId;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject((Object)this.entityType);
        oos.writeLong(this.entityId);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        try {
            this.entityType = (EntityType)((Object)ois.readObject());
        }
        catch (InvalidObjectException e) {
            this.entityType = null;
        }
        this.entityId = ois.readLong();
    }
}

