/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.singularity.ee.controller.api.dto.transactionmonitor.BusinessTransactionType;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.string.StringRegexOperations;

@UiCodeGen
@TSCodeGen(exclude=true)
public class DroppedTransaction {
    private String name;
    private BusinessTransactionType type;
    private transient IAgentAtomicInteger count = new AgentAtomicIntegerImpl(1);
    private int droppedCount;

    public DroppedTransaction() {
    }

    public DroppedTransaction(String btName, BusinessTransactionType type) {
        this.name = btName;
        this.type = type;
    }

    public void incrementCount() {
        this.count.incrementAndGet();
    }

    @JsonIgnore
    public IAgentAtomicInteger getCount() {
        return this.count;
    }

    public void setCount(IAgentAtomicInteger value) {
        this.count.set(value.get());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BusinessTransactionType getType() {
        return this.type;
    }

    public void setType(BusinessTransactionType value) {
        this.type = value;
    }

    public static DroppedTransaction fromString(String name, String value) {
        String[] split = StringRegexOperations.split(value, ";");
        if (split.length == 2) {
            DroppedTransaction droppedBT = new DroppedTransaction(name, EnumHelper.getEnum(BusinessTransactionType.class, split[0]));
            droppedBT.count.set(Integer.parseInt(split[1]));
            return droppedBT;
        }
        return null;
    }

    public String valueToString() {
        return this.type.toString() + ";" + this.count.get();
    }

    public void setDroppedCount(int droppedCount) {
        this.droppedCount = droppedCount;
    }

    public int getDroppedCount() {
        return this.droppedCount;
    }
}

