/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.CallGraphPackages;
import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.collections.CollectionHelper;

@GenProto
@UiCodeGen
@TSCodeGen(exclude=true)
public class CallGraphConfiguration
extends APersistentObject {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @IgnoreProtoGen
    public static final int MIN_SAMPLING_RATE = 10;
    @IgnoreProtoGen
    public static final int MAX_SAMPLING_RATE = 60000;
    @IgnoreProtoGen
    public static final int MIN_DURATION_FOR_JDBC_EXIT_CALLS = 10;
    @IgnoreProtoGen
    public static final boolean DEFAULT_HOTSPOTS_ENABLED = false;
    @IgnoreProtoGen
    private static final String[] EXCLUDE_PACKAGES_LIST = new String[]{CallGraphPackages.JAVA_CORE_PACKAGE_PREFIX, CallGraphPackages.JAVA_EXTENSION_PACKAGE_PREFIX, CallGraphPackages.COM_SUN_IMPLEMENTATION_CLASSES_PREFIX, CallGraphPackages.SUN_IMPLEMENTATION_CLASSES_PREFIX, CallGraphPackages.ORG_EXTENSION_PACKAGE_PREFIX, CallGraphPackages.BEA_SERVER_PACKAGE_PREFIX, CallGraphPackages.WEBLOGIC_SERVER_PACKAGE_PREFIX, CallGraphPackages.WEBLOGIC_SERVER_PACKAGE_PREFIX_2, CallGraphPackages.IBM_PACKAGE_PREFIX, CallGraphPackages.MYSQL_PACKAGE_PREFIX, CallGraphPackages.ORACLE_PACKAGE_PREFIX, CallGraphPackages.ORACLE_PACKAGE_PREFIX_2, CallGraphPackages.MICROSOFT_JDBC_PACKAGE_PREFIX, CallGraphPackages.OPENSYMPHONY_PACKAGE_PREFIX, CallGraphPackages.SOURCE_FORGE_PROJECTS_PREFIX, CallGraphPackages.JROCKIT_CORE_PACKAGE_PREFIX, CallGraphPackages.KODO_JPA_PACKAGE_PREFIX, CallGraphPackages.POINTBASE_PACKAGE_PREFIX, CallGraphPackages.TOPLINK_PACKAGE_PREFIX, CallGraphPackages.INFORMIX_CLASSES, CallGraphPackages.SYBASE_JDBC2_CLASSES, CallGraphPackages.SYBASE_JDBC3_CLASSES, CallGraphPackages.SYBASE_JDBC4_CLASSES, CallGraphPackages.MONGO_CONNECTION_INTERNALS};
    @IgnoreProtoGen
    private static final String[] ZERO_ELEMENT_LIST = new String[0];
    @IgnoreProtoGen
    private static final String[] INCLUDE_PACKAGES_LIST = new String[]{CallGraphPackages.JERSEY_PACKAGE_PREFIX, CallGraphPackages.OPEN_EJB, CallGraphPackages.CASSANDRA_PACKAGE_PREFIX, CallGraphPackages.KAFKA_PACKAGE_PREFIX, CallGraphPackages.APACHE_HTTP_PACKAGE_PREFIX, CallGraphPackages.NING_ASYNC_HTTP_CLIENT_PACKAGE_PREFIX, CallGraphPackages.APACHE_CAMEL_EXAMPLES, CallGraphPackages.APACHE_CAMEL_SEDA_INTERNALS, CallGraphPackages.MULE_ESB_INTERNALS, CallGraphPackages.JBOSS_ESB_INTERNALS, CallGraphPackages.SPRING_INTEGRATION_INTERNALS, CallGraphPackages.WMQ_PACKAGE_PREFIX, CallGraphPackages.ActiveMQ_PACKAGE_PREFIX, CallGraphPackages.IBM_BPM_PACKAGE_PREFIX, CallGraphPackages.IBM_BPE_PACKAGE_PREFIX, CallGraphPackages.IBM_WS_PACKAGE_PREFIX};
    @FieldPosition(value=2)
    private int samplingRateInMilliSeconds;
    @FieldPosition(value=3)
    private String[] excludedPackages;
    @FieldPosition(value=4)
    private String[] includedPackages;
    @FieldPosition(value=5)
    private int minDurationForJDBCCallsInMilliSeconds;
    @FieldPosition(value=6)
    private boolean rawSQL;
    @FieldPosition(value=7)
    private boolean hotspotsEnabled = false;

    public CallGraphConfiguration() {
    }

    public CallGraphConfiguration(int samplingRateInMilliSeconds, String[] excludedPackages, String[] includedPackages) {
        this.samplingRateInMilliSeconds = samplingRateInMilliSeconds;
        this.excludedPackages = excludedPackages == null ? null : ArrayUtils.copyOf(excludedPackages, excludedPackages.length);
        this.includedPackages = includedPackages == null ? null : ArrayUtils.copyOf(includedPackages, includedPackages.length);
    }

    public static CallGraphConfiguration getJavaAgentDefaultValue() {
        return CallGraphConfiguration.getDefaultValueInternal(EXCLUDE_PACKAGES_LIST, INCLUDE_PACKAGES_LIST);
    }

    private static CallGraphConfiguration getDefaultValueInternal(String[] excludedPackages, String[] includedPackages) {
        CallGraphConfiguration config = new CallGraphConfiguration();
        config.setSamplingRateInMilliSeconds(10);
        config.setExcludedPackages(excludedPackages);
        config.setIncludedPackages(includedPackages);
        config.setMinDurationForJDBCCallsInMilliSeconds(10);
        config.setHotspotsEnabled(false);
        return config;
    }

    public static CallGraphConfiguration getDotNetAgentDefaultValue() {
        return CallGraphConfiguration.getDefaultValueInternal(ZERO_ELEMENT_LIST, ZERO_ELEMENT_LIST);
    }

    public static CallGraphConfiguration getPhpAgentDefaultValue() {
        return CallGraphConfiguration.getDefaultValueInternal(ZERO_ELEMENT_LIST, ZERO_ELEMENT_LIST);
    }

    public static CallGraphConfiguration getNodeJSAgentDefaultValue() {
        return CallGraphConfiguration.getDefaultValueInternal(ZERO_ELEMENT_LIST, ZERO_ELEMENT_LIST);
    }

    public static CallGraphConfiguration getPythonAgentDefaultValue() {
        return CallGraphConfiguration.getDefaultValueInternal(ZERO_ELEMENT_LIST, ZERO_ELEMENT_LIST);
    }

    public static CallGraphConfiguration getRubyAgentDefaultValue() {
        return CallGraphConfiguration.getDefaultValueInternal(ZERO_ELEMENT_LIST, ZERO_ELEMENT_LIST);
    }

    public boolean isRawSQL() {
        return this.rawSQL;
    }

    public void setRawSQL(boolean rawSQL) {
        this.rawSQL = rawSQL;
    }

    public int getSamplingRateInMilliSeconds() {
        return this.samplingRateInMilliSeconds;
    }

    public void setSamplingRateInMilliSeconds(int samplingRateInMilliSeconds) {
        this.samplingRateInMilliSeconds = samplingRateInMilliSeconds;
    }

    public String[] getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(String[] excludedPackages) {
        this.excludedPackages = excludedPackages == null ? null : ArrayUtils.copyOf(excludedPackages, excludedPackages.length);
    }

    public String[] getIncludedPackages() {
        return this.includedPackages;
    }

    public void setIncludedPackages(String[] includedPackages) {
        this.includedPackages = includedPackages == null ? null : ArrayUtils.copyOf(includedPackages, includedPackages.length);
    }

    public int getMinDurationForJDBCCallsInMilliSeconds() {
        return this.minDurationForJDBCCallsInMilliSeconds;
    }

    public void setMinDurationForJDBCCallsInMilliSeconds(int minDurationForJDBCCallsInMilliSeconds) {
        this.minDurationForJDBCCallsInMilliSeconds = minDurationForJDBCCallsInMilliSeconds;
    }

    public boolean isHotspotsEnabled() {
        return this.hotspotsEnabled;
    }

    public void setHotspotsEnabled(boolean hotspotsEnabled) {
        this.hotspotsEnabled = hotspotsEnabled;
    }

    @Override
    public String toString() {
        return "CallGraphConfiguration [samplingRateInMilliSeconds=" + this.samplingRateInMilliSeconds + ", excludedPackages=" + CollectionHelper.arrayToString(this.excludedPackages) + ", includedPackages=" + CollectionHelper.arrayToString(this.includedPackages) + ", minDurationForJDBCCallsInMilliSeconds=" + this.minDurationForJDBCCallsInMilliSeconds + ", rawSQL=" + this.rawSQL + ", hotspotsEnabled=" + this.hotspotsEnabled + "]";
    }
}

