/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto;

import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.dto.PersistentObjectHelper;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.TransactionFlowItemIdentifier;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@GenProto(protoFile="DtoBase.proto")
@UiCodeGen
public abstract class APersistentObject
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private long id;
    @FieldPosition(value=3)
    private int version;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
        if (id == 0L) {
            this.setVersion(0);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static long[] getIds(APersistentObject ... objects) {
        if (objects == null) {
            return new long[0];
        }
        return APersistentObject.getIds(CollectionHelper.asList(objects));
    }

    public static long[] getIds(Collection<? extends APersistentObject> objects) {
        if (objects == null) {
            return new long[0];
        }
        long[] ids = new long[PersistentObjectHelper.size(objects)];
        int i = 0;
        for (APersistentObject aPersistentObject : objects) {
            ids[i++] = aPersistentObject.getId();
        }
        return ids;
    }

    public static <T extends APersistentObject> T getObject(long id, T ... objects) {
        if (objects == null) {
            return null;
        }
        for (T obj : objects) {
            if (((APersistentObject)obj).getId() != id) continue;
            return obj;
        }
        return null;
    }

    public static int calculateHashCode(Object ... hashCodeArgs) {
        int result = 17;
        for (Object hashCodeArg : hashCodeArgs) {
            if (hashCodeArg == null) continue;
            result = 37 * result + hashCodeArg.hashCode();
        }
        return result;
    }

    public static Set<Long> getIdSet(Collection<APersistentObject> objects) {
        HashSet<Long> ids = new HashSet<Long>(objects.size());
        for (APersistentObject obj : objects) {
            ids.add(obj.getId());
        }
        return ids;
    }

    public static Set<Long> getIdSet(APersistentObject ... objects) {
        HashSet<Long> ids = new HashSet<Long>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            ids.add(objects[i].getId());
        }
        return ids;
    }

    public static List<Long> getIdList(APersistentObject ... objects) {
        ArrayList<Long> ids = new ArrayList<Long>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            ids.add(objects[i].getId());
        }
        return ids;
    }

    protected static <T extends APersistentObject> T[] getCopies(Class<T> clazz, T ... objects) {
        return PersistentObjectHelper.getObjectCopies(clazz, objects);
    }

    public APersistentObject copy() {
        return PersistentObjectHelper.copyPersistentObject();
    }

    public TransactionFlowItemIdentifier constructTransactionFlowItemIdentifier() {
        throw new IllegalArgumentException("Invalid type " + ReflectionUtilityCommon.getClassSimpleName(this.getClass()) + " specified to get flow item identifier");
    }

    public String toString() {
        return String.format("id=%s , version=%d", this.id, this.version);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof APersistentObject)) {
            return false;
        }
        APersistentObject persist = (APersistentObject)obj;
        return this.id == persist.id && this.version == persist.version;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

