/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.EventTypeCategoryConstants;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.HashMap;
import java.util.Map;

@TSCodeGen(exclude=true)
public class EventTypeHelper {
    private static final Map<EventType, EventTypeHelper> eventTypes;
    private final String displayName;
    private final boolean internalToAgentAndController;

    public EventTypeHelper(String displayName, boolean internalToAgntCtrl) {
        this.displayName = displayName;
        this.internalToAgentAndController = internalToAgntCtrl;
    }

    public static String getDisplayName(EventType eventType) {
        EventTypeHelper helper = eventTypes.get((Object)eventType);
        if (helper != null) {
            return helper.displayName;
        }
        return null;
    }

    public static boolean isInternal(EventType eventType) {
        EventTypeHelper helper = eventTypes.get((Object)eventType);
        if (helper != null) {
            return helper.internalToAgentAndController;
        }
        return false;
    }

    public static String getCategory(EventType eventType) {
        String category = EventTypeCategoryConstants.getTypeCategory(eventType);
        return category != null ? category : "";
    }

    static {
        HashMap<EventType, EventTypeHelper> tmpEventTypes = new HashMap<EventType, EventTypeHelper>();
        tmpEventTypes.put(EventType.ERROR, new EventTypeHelper("Business Transaction Error", false));
        tmpEventTypes.put(EventType.APPLICATION_ERROR, new EventTypeHelper("Application Error", false));
        tmpEventTypes.put(EventType.APPLICATION_INFO, new EventTypeHelper("Application Info", false));
        tmpEventTypes.put(EventType.STALL, new EventTypeHelper("Transaction Stall", false));
        tmpEventTypes.put(EventType.BT_SLA_VIOLATION, new EventTypeHelper("Transaction SLA Violation", false));
        tmpEventTypes.put(EventType.DEADLOCK, new EventTypeHelper("Deadlock", false));
        tmpEventTypes.put(EventType.MEMORY_LEAK, new EventTypeHelper("Memory Leak", false));
        tmpEventTypes.put(EventType.MEMORY_LEAK_DIAGNOSTICS, new EventTypeHelper("Memory Leak Diagnostics", false));
        tmpEventTypes.put(EventType.LOW_HEAP_MEMORY, new EventTypeHelper("Low Heap Memory", false));
        tmpEventTypes.put(EventType.ALERT, new EventTypeHelper("Alert", false));
        tmpEventTypes.put(EventType.CUSTOM, new EventTypeHelper("Custom", false));
        tmpEventTypes.put(EventType.APP_SERVER_RESTART, new EventTypeHelper("App Server Restart", false));
        tmpEventTypes.put(EventType.CLR_CRASH, new EventTypeHelper("CLR Crash", false));
        tmpEventTypes.put(EventType.BT_SLOW, new EventTypeHelper("Slow Business Transaction", false));
        tmpEventTypes.put(EventType.SYSTEM_LOG, new EventTypeHelper("System Log", false));
        tmpEventTypes.put(EventType.INFO_INSTRUMENTATION_VISIBILITY, new EventTypeHelper("Internal Instrumentation Info", true));
        tmpEventTypes.put(EventType.AGENT_EVENT, new EventTypeHelper("Agent Internal Event", false));
        tmpEventTypes.put(EventType.INFO_BT_SNAPSHOT, new EventTypeHelper("BT Snapshot", true));
        tmpEventTypes.put(EventType.AGENT_STATUS, new EventTypeHelper("Agent Status", false));
        tmpEventTypes.put(EventType.SERIES_SLOW, new EventTypeHelper("Series of Slow Requests", false));
        tmpEventTypes.put(EventType.SERIES_ERROR, new EventTypeHelper("Series of Error Requests", false));
        tmpEventTypes.put(EventType.ACTIVITY_TRACE, new EventTypeHelper("Activity Trace", true));
        tmpEventTypes.put(EventType.OBJECT_CONTENT_SUMMARY, new EventTypeHelper("Object Content Summary", true));
        tmpEventTypes.put(EventType.DIAGNOSTIC_SESSION, new EventTypeHelper("Diagnostic Session", false));
        tmpEventTypes.put(EventType.HIGH_END_TO_END_LATENCY, new EventTypeHelper("High End to End Message Processing Latency", false));
        tmpEventTypes.put(EventType.APPLICATION_CONFIG_CHANGE, new EventTypeHelper("Application Configuration Change", false));
        tmpEventTypes.put(EventType.APPLICATION_DEPLOYMENT, new EventTypeHelper("Application Deployment", false));
        tmpEventTypes.put(EventType.POLICY_CLOSE, new EventTypeHelper("Health Rule Close (deprecated)", false));
        tmpEventTypes.put(EventType.POLICY_CLOSE_CRITICAL, new EventTypeHelper("Health Rule Close", false));
        tmpEventTypes.put(EventType.POLICY_CLOSE_WARNING, new EventTypeHelper("Health Rule Close", false));
        tmpEventTypes.put(EventType.POLICY_CANCELLED, new EventTypeHelper("Health Rule Canceled (deprecated)", false));
        tmpEventTypes.put(EventType.POLICY_CANCELED_CRITICAL, new EventTypeHelper("Health Rule Canceled", false));
        tmpEventTypes.put(EventType.POLICY_CANCELED_WARNING, new EventTypeHelper("Health Rule Canceled", false));
        tmpEventTypes.put(EventType.POLICY_DOWNGRADED, new EventTypeHelper("Health Rule State changed from Critical to Warning", false));
        tmpEventTypes.put(EventType.POLICY_OPEN, new EventTypeHelper("New Health Rule Violation (deprecated)", false));
        tmpEventTypes.put(EventType.POLICY_OPEN_CRITICAL, new EventTypeHelper("New Critical Health Rule Violation", false));
        tmpEventTypes.put(EventType.POLICY_OPEN_WARNING, new EventTypeHelper("New Warning Health Rule Violation", false));
        tmpEventTypes.put(EventType.POLICY_CONTINUES_CRITICAL, new EventTypeHelper("Ongoing Critical Health Rule Violation", false));
        tmpEventTypes.put(EventType.POLICY_CONTINUES_WARNING, new EventTypeHelper("Ongoing Warning Health Rule Violation", false));
        tmpEventTypes.put(EventType.POLICY_UPGRADED, new EventTypeHelper("Health Rule State changed from Warning to Critical", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_BROWSER_EVENT, new EventTypeHelper("EUM Cloud Browser Event", true));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_BROWSER_EVENT, new EventTypeHelper("EUM Cloud Synthetic Browser Event", true));
        tmpEventTypes.put(EventType.THREAD_DUMP_ACTION_END, new EventTypeHelper("Thread Dump RunBook End", false));
        tmpEventTypes.put(EventType.THREAD_DUMP_ACTION_STARTED, new EventTypeHelper("Thread Dump RunBook Start", false));
        tmpEventTypes.put(EventType.RUNBOOK_DIAGNOSTIC_SESSION_STARTED, new EventTypeHelper("Diagnostic Session RunBook Start", false));
        tmpEventTypes.put(EventType.RUNBOOK_DIAGNOSTIC_SESSION_END, new EventTypeHelper("Diagnostic Session RunBook End", false));
        tmpEventTypes.put(EventType.RUN_LOCAL_SCRIPT_ACTION_STARTED, new EventTypeHelper("Run Local Script Start", false));
        tmpEventTypes.put(EventType.RUN_LOCAL_SCRIPT_ACTION_END, new EventTypeHelper("Run Local Script End", false));
        tmpEventTypes.put(EventType.RESOURCE_POOL_LIMIT, new EventTypeHelper("Resource Pool Limit", false));
        tmpEventTypes.put(EventType.NORMAL, new EventTypeHelper("Transaction Normal", false));
        tmpEventTypes.put(EventType.SLOW, new EventTypeHelper("Slow Transaction", false));
        tmpEventTypes.put(EventType.VERY_SLOW, new EventTypeHelper("Very Slow Transaction", false));
        tmpEventTypes.put(EventType.BUSINESS_ERROR, new EventTypeHelper("Transaction Error", false));
        tmpEventTypes.put(EventType.ADJUDICATION_CANCELLED, new EventTypeHelper("Adjudication Cancelled", false));
        tmpEventTypes.put(EventType.ALREADY_ADJUDICATED, new EventTypeHelper("Already Adjudicated", false));
        tmpEventTypes.put(EventType.EMAIL_SENT, new EventTypeHelper("Email Sent", false));
        tmpEventTypes.put(EventType.EMAIL_ACTION_FAILED, new EventTypeHelper("Email Action failed", false));
        tmpEventTypes.put(EventType.SMS_SENT, new EventTypeHelper("SMS Sent", false));
        tmpEventTypes.put(EventType.CONTROLLER_AGENT_VERSION_INCOMPATIBILITY, new EventTypeHelper("Agent Version is newer than Controller Version", false));
        tmpEventTypes.put(EventType.AGENT_CONFIGURATION_ERROR, new EventTypeHelper("Agent Configuration error", false));
        tmpEventTypes.put(EventType.LICENSE, new EventTypeHelper("License Issue", false));
        tmpEventTypes.put(EventType.DISK_SPACE, new EventTypeHelper("Disk Space Issue", false));
        tmpEventTypes.put(EventType.CONTROLLER_EVENT_UPLOAD_LIMIT_REACHED, new EventTypeHelper("Controller Side Agent Event Data Upload Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_RSD_UPLOAD_LIMIT_REACHED, new EventTypeHelper("Controller Side Agent Request Data Upload Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_PSD_UPLOAD_LIMIT_REACHED, new EventTypeHelper("Controller Side Agent Process Snapshot Data Upload Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_METRIC_REG_LIMIT_REACHED, new EventTypeHelper("Controller Side Metric Registration Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_METRIC_DATA_BUFFER_OVERFLOW, new EventTypeHelper("Controller metric data buffer overflow (dropping metric data)", false));
        tmpEventTypes.put(EventType.CONTROLLER_ERROR_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Controller Side Error ADD Registration Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_ASYNC_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Controller Side Async ADD Registration Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_STACKTRACE_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Controller Side StackTrace ADD Registration Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_MEMORY_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Controller Side Memory ADD Registration Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_TRACKED_OBJECT_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Controller Side Tracked Object ADD Registration Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_COLLECTIONS_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Controller Side Collection ADD Registration Limited", false));
        tmpEventTypes.put(EventType.CONTROLLER_SEP_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Controller Side Service Endpoint ADD Registration Limited", false));
        tmpEventTypes.put(EventType.AGENT_METRIC_REG_LIMIT_REACHED, new EventTypeHelper("Agent Side Metric Registration Limited", false));
        tmpEventTypes.put(EventType.AGENT_ERROR_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Agent Side Error ADD Registration Limited", false));
        tmpEventTypes.put(EventType.AGENT_ASYNC_ADD_REG_LIMIT_REACHED, new EventTypeHelper("Agent Side Async ADD Registration Limited", false));
        tmpEventTypes.put(EventType.AGENT_METRIC_BLACKLIST_REG_LIMIT_REACHED, new EventTypeHelper("Agent Side Metric Blacklisting Limited", false));
        tmpEventTypes.put(EventType.AGENT_ADD_BLACKLIST_REG_LIMIT_REACHED, new EventTypeHelper("Agent Side ADD Blacklisting Limited", false));
        tmpEventTypes.put(EventType.SNOOZE_END, new EventTypeHelper("Snooze Ended", false));
        tmpEventTypes.put(EventType.SNOOZE_START, new EventTypeHelper("Snooze Started", false));
        tmpEventTypes.put(EventType.APPLICATION_CRASH, new EventTypeHelper("Application Crashed", false));
        tmpEventTypes.put(EventType.APPLICATION_DISCOVERED, new EventTypeHelper("New Application Discovered", false));
        tmpEventTypes.put(EventType.TIER_DISCOVERED, new EventTypeHelper("New Tier Discovered", false));
        tmpEventTypes.put(EventType.NODE_DISCOVERED, new EventTypeHelper("New Node Discovered", false));
        tmpEventTypes.put(EventType.MACHINE_DISCOVERED, new EventTypeHelper("New Machine Discovered", false));
        tmpEventTypes.put(EventType.BT_DISCOVERED, new EventTypeHelper("New Business Transaction Discovered", false));
        tmpEventTypes.put(EventType.SERVICE_ENDPOINT_DISCOVERED, new EventTypeHelper("New Service Endpoint Discovered", false));
        tmpEventTypes.put(EventType.BACKEND_DISCOVERED, new EventTypeHelper("New Backend Discovered", false));
        tmpEventTypes.put(EventType.WARROOM_NOTE, new EventTypeHelper("War Room Note", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_HEALTHY_EVENT, new EventTypeHelper("Synthetic Availability Problem Ended", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_WARNING_EVENT, new EventTypeHelper("Synthetic Availability Warning Started", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_CONFIRMED_WARNING_EVENT, new EventTypeHelper("Synthetic Availability Warning Confirmed", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_ONGOING_WARNING_EVENT, new EventTypeHelper("Synthetic Availability Warning Continues", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_ERROR_EVENT, new EventTypeHelper("Synthetic Availability Error Started", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_CONFIRMED_ERROR_EVENT, new EventTypeHelper("Synthetic Availability Error Confirmed", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_ONGOING_ERROR_EVENT, new EventTypeHelper("Synthetic Availability Error Continues", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_HEALTHY_EVENT, new EventTypeHelper("Synthetic Performance Problem Ended", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_WARNING_EVENT, new EventTypeHelper("Synthetic Performance Warning Started", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_CONFIRMED_WARNING_EVENT, new EventTypeHelper("Synthetic Performance Warning Confirmed", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_ONGOING_WARNING_EVENT, new EventTypeHelper("Synthetic Performance Warning Continues", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_CRITICAL_EVENT, new EventTypeHelper("Synthetic Performance Critical Started", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_CONFIRMED_CRITICAL_EVENT, new EventTypeHelper("Synthetic Performance Critical Confirmed", false));
        tmpEventTypes.put(EventType.EUM_CLOUD_SYNTHETIC_PERF_ONGOING_CRITICAL_EVENT, new EventTypeHelper("Synthetic Performance Critical Continues", false));
        tmpEventTypes.put(EventType.MOBILE_NEW_CRASH_EVENT, new EventTypeHelper("EUM Mobile New Crash", false));
        tmpEventTypes.put(EventType.HTTP_REQUEST_ACTION_FAILED, new EventTypeHelper("HTTP Action Failed", false));
        tmpEventTypes.put(EventType.CUSTOM_ACTION_FAILED, new EventTypeHelper("Custom Action Failed", false));
        tmpEventTypes.put(EventType.CUSTOM_EMAIL_ACTION_FAILED, new EventTypeHelper("Custom Email Action Failed", false));
        tmpEventTypes.put(EventType.ANOMALY_OPEN_WARNING, new EventTypeHelper("New Warning Anomaly", false));
        tmpEventTypes.put(EventType.ANOMALY_OPEN_CRITICAL, new EventTypeHelper("New Critical Anomaly", false));
        tmpEventTypes.put(EventType.ANOMALY_UPGRADED, new EventTypeHelper("Anomaly state changed from Warning to Critical", false));
        tmpEventTypes.put(EventType.ANOMALY_DOWNGRADED, new EventTypeHelper("Anomaly state changed from Critical to Warning", false));
        tmpEventTypes.put(EventType.ANOMALY_CANCELED_CRITICAL, new EventTypeHelper("Anomaly Canceled", false));
        tmpEventTypes.put(EventType.ANOMALY_CANCELED_WARNING, new EventTypeHelper("Anomaly Canceled", false));
        tmpEventTypes.put(EventType.ANOMALY_CLOSE_CRITICAL, new EventTypeHelper("Anomaly Ended", false));
        tmpEventTypes.put(EventType.ANOMALY_CLOSE_WARNING, new EventTypeHelper("Anomaly Ended", false));
        eventTypes = CollectionHelper.unmodifiableMap(tmpEventTypes);
    }
}

