/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import com.singularity.ee.controller.api.constants.EventSubType;
import com.singularity.ee.controller.api.constants.EventType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@UiCodeGen
@TSCodeGen(exclude=true)
public class EventTypeCategoryConstants {
    private static final Map<EventType, String> eventTypeCategoryMap;
    private static final Map<EventSubType, String> eventSubTypeCategoryMap;
    private static final Set<String> eventSubTypeValues;
    private static final String TOTAL_ANOMALIES = "TOTAL_ANOMALIES";

    public static Map<EventType, String> getEventTypeCategoryMap() {
        return eventTypeCategoryMap;
    }

    public static Map<EventSubType, String> getEventSubTypeCategoryMap() {
        return eventSubTypeCategoryMap;
    }

    public static boolean isValidSubType(String subType) {
        return eventSubTypeValues.contains(subType);
    }

    public static String getTypeCategory(EventType eventType) {
        return eventTypeCategoryMap.get((Object)eventType);
    }

    public static String getSubTypeCategory(EventSubType eventSubType) {
        return eventSubTypeCategoryMap.get((Object)eventSubType);
    }

    static {
        HashMap<EventType, String> eventTypeStringMap = new HashMap<EventType, String>();
        eventTypeStringMap.put(EventType.POLICY_OPEN_WARNING, "TOTAL_POLICY_VIOLATIONS");
        eventTypeStringMap.put(EventType.POLICY_OPEN_CRITICAL, "TOTAL_POLICY_VIOLATIONS");
        eventTypeStringMap.put(EventType.APPLICATION_ERROR, "ERROR_EVENTS");
        eventTypeStringMap.put(EventType.DEADLOCK, "CODE_PROBLEMS");
        eventTypeStringMap.put(EventType.RESOURCE_POOL_LIMIT, "CODE_PROBLEMS");
        eventTypeStringMap.put(EventType.APPLICATION_DEPLOYMENT, "APPLICATION_CHANGES");
        eventTypeStringMap.put(EventType.APP_SERVER_RESTART, "APPLICATION_CHANGES");
        eventTypeStringMap.put(EventType.APPLICATION_CONFIG_CHANGE, "APPLICATION_CHANGES");
        eventTypeStringMap.put(EventType.AGENT_STATUS, "INTERNAL_DIAGNOSTICS");
        eventTypeStringMap.put(EventType.INFO_INSTRUMENTATION_VISIBILITY, "INTERNAL_DIAGNOSTICS");
        eventTypeStringMap.put(EventType.DIAGNOSTIC_SESSION, "INTERNAL_DIAGNOSTICS");
        eventTypeStringMap.put(EventType.INTERNAL_UI_EVENT, "INTERNAL_DIAGNOSTICS");
        eventTypeStringMap.put(EventType.AGENT_EVENT, "INTERNAL_DIAGNOSTICS");
        eventTypeStringMap.put(EventType.APPDYNAMICS_INTERNAL_DIAGNOSTICS, "INTERNAL_DIAGNOSTICS");
        eventTypeStringMap.put(EventType.EUM_INTERNAL_ERROR, "INTERNAL_DIAGNOSTICS");
        eventTypeStringMap.put(EventType.LICENSE, "CONFIGURATION_WARNINGS");
        eventTypeStringMap.put(EventType.DISK_SPACE, "CONFIGURATION_WARNINGS");
        eventTypeStringMap.put(EventType.CONTROLLER_AGENT_VERSION_INCOMPATIBILITY, "CONFIGURATION_WARNINGS");
        eventTypeStringMap.put(EventType.AGENT_CONFIGURATION_ERROR, "CONFIGURATION_WARNINGS");
        eventTypeStringMap.put(EventType.DEV_MODE_CONFIG_UPDATE, "CONFIGURATION_WARNINGS");
        eventTypeStringMap.put(EventType.CONTROLLER_METRIC_REG_LIMIT_REACHED, "CONFIGURATION_WARNINGS");
        eventTypeStringMap.put(EventType.AGENT_METRIC_REG_LIMIT_REACHED, "CONFIGURATION_WARNINGS");
        eventTypeStringMap.put(EventType.APPLICATION_CRASH, "INFRASTRUCTURE_EVENTS");
        eventTypeStringMap.put(EventType.CLR_CRASH, "INFRASTRUCTURE_EVENTS");
        eventTypeStringMap.put(EventType.CUSTOM, "CUSTOM_EVENTS");
        eventTypeStringMap.put(EventType.APPLICATION_DISCOVERED, "DISCOVERY_EVENTS");
        eventTypeStringMap.put(EventType.NODE_DISCOVERED, "DISCOVERY_EVENTS");
        eventTypeStringMap.put(EventType.TIER_DISCOVERED, "DISCOVERY_EVENTS");
        eventTypeStringMap.put(EventType.MACHINE_DISCOVERED, "DISCOVERY_EVENTS");
        eventTypeStringMap.put(EventType.BT_DISCOVERED, "DISCOVERY_EVENTS");
        eventTypeStringMap.put(EventType.SERVICE_ENDPOINT_DISCOVERED, "DISCOVERY_EVENTS");
        eventTypeStringMap.put(EventType.BACKEND_DISCOVERED, "DISCOVERY_EVENTS");
        eventTypeStringMap.put(EventType.NETWORK, "NETWORK_EVENTS");
        eventTypeStringMap.put(EventType.ANOMALY_OPEN_CRITICAL, TOTAL_ANOMALIES);
        eventTypeStringMap.put(EventType.ANOMALY_OPEN_WARNING, TOTAL_ANOMALIES);
        eventTypeCategoryMap = Collections.unmodifiableMap(eventTypeStringMap);
        HashMap<EventSubType, String> eventSubTypeStringMap = new HashMap<EventSubType, String>();
        eventSubTypeStringMap.put(EventSubType.OVERALL_APPLICATION, "OVERALL_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.BUSINESS_TRANSACTION, "BUSINESS_TRANSACTION_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.NODE_HEALTH_TRANSACTION_PERFORMANCE, "NODE_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.INFRASTRUCTURE, "NODE_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.JMX, "NODE_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.ERROR, "ERROR_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.BACKEND, "BACKEND_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.DB_SERVER, "DB_SERVER_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.INFORMATION_POINT, "INFORMATION_POINT_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.MOBILE_APPLICATION, "MOBILE_APPLICATION_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.OTHER, "CUSTOM_POLICY_VIOLATIONS");
        eventSubTypeStringMap.put(EventSubType.NULL_EVENT_SUBTYPE, "");
        eventSubTypeCategoryMap = Collections.unmodifiableMap(eventSubTypeStringMap);
        HashSet<String> eventSubTypeNamesSet = new HashSet<String>();
        for (EventSubType eventSubType : EventSubType.values()) {
            eventSubTypeNamesSet.add(eventSubType.name());
        }
        eventSubTypeValues = Collections.unmodifiableSet(eventSubTypeNamesSet);
    }
}

