/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.constants;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.appdynamics.ui.codegen.annotations.UiCodeGen;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@UiCodeGen
@TSCodeGen(exclude=true)
public enum ApplicationDiagnosticDataType {
    ERROR,
    MEMORY,
    CACHE,
    TRACKED_OBJECT,
    COLLECTIONS,
    STACK_TRACE,
    THREAD_TASK,
    BASE_PAGE,
    IFRAME,
    AJAX_REQUEST,
    SYNTH_JOB_REF,
    MOBILE_REQUEST,
    SERVICE_ENDPOINT,
    VIRTUAL_PAGE;

    private static final List<ApplicationDiagnosticDataType> APPLICATION_DIAGNOSTIC_DATA_TYPES;

    public static boolean contains(String addType) {
        try {
            ApplicationDiagnosticDataType.valueOf(addType.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public static String buildString(String[] addTypes, String delim) {
        if (addTypes == null || addTypes.length == 0) {
            throw new IllegalArgumentException("Null or empty ApplicationDiagnosticTypes specified");
        }
        StringBuilder sb = new StringBuilder();
        for (String addType : addTypes) {
            if (!ApplicationDiagnosticDataType.contains(addType)) {
                throw new IllegalArgumentException("Invalid ApplicationDiagnosticType specified : " + addType);
            }
            sb.append(delim + addType);
        }
        return sb.substring(1);
    }

    public static boolean isHealthRuleSupportedOnADDType(ApplicationDiagnosticDataType applicationDiagnosticDataType) {
        return applicationDiagnosticDataType == ERROR || applicationDiagnosticDataType == BASE_PAGE || applicationDiagnosticDataType == IFRAME || applicationDiagnosticDataType == AJAX_REQUEST || applicationDiagnosticDataType == VIRTUAL_PAGE || applicationDiagnosticDataType == SERVICE_ENDPOINT || applicationDiagnosticDataType == MOBILE_REQUEST || applicationDiagnosticDataType == SYNTH_JOB_REF;
    }

    public static boolean isHealthRuleSupportedOnADDType(String[] applicationDiagnosticDataType) {
        for (String addType : applicationDiagnosticDataType) {
            if (ApplicationDiagnosticDataType.isHealthRuleSupportedOnADDType(ApplicationDiagnosticDataType.valueOf(addType))) continue;
            return false;
        }
        return true;
    }

    public static ApplicationDiagnosticDataType fromOrdinal(int ordinal) {
        if (ordinal >= APPLICATION_DIAGNOSTIC_DATA_TYPES.size() || ordinal < 0) {
            return null;
        }
        return APPLICATION_DIAGNOSTIC_DATA_TYPES.get(ordinal);
    }

    public static List<ApplicationDiagnosticDataType> getApplicationDiagnosticDataTypes() {
        return APPLICATION_DIAGNOSTIC_DATA_TYPES;
    }

    static {
        APPLICATION_DIAGNOSTIC_DATA_TYPES = Collections.unmodifiableList(Arrays.asList(ApplicationDiagnosticDataType.values()));
    }
}

