/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.bt;

import com.singularity.ee.util.collections.ArrayUtilsHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class TimestampedObject<T> {
    private volatile long lastModifiedTimestamp;
    private volatile T object;
    private final ReentrantLock lock = new ReentrantLock();

    public TimestampedObject() {
    }

    public TimestampedObject(T object, long lastModifiedTimestamp) {
        this.object = object;
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public void setLastModifiedTimestamp(long lastModifiedTimestamp) {
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setObject(T object, long lastModifiedTimestamp) {
        this.object = object;
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    public void lock() {
        this.lock.lock();
    }

    public boolean lock(long timeout, TimeUnit timeUnit) {
        try {
            return this.lock.tryLock(timeout, timeUnit);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public void unlock() {
        this.lock.unlock();
    }

    public String toString() {
        String output = "null";
        if (this.object != null) {
            output = this.object.getClass().isArray() ? ArrayUtilsHelper.arrayOfCustomObjectsToString(this.object) : this.object.toString();
        }
        return String.format("{ lastModifiedTimestamp:%s , object:%s }", this.lastModifiedTimestamp, output);
    }
}

