/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.io.IOException;
import java.io.OutputStream;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.MessageLoggers;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;
import org.zeroturnaround.process.PidProcess;

public class WindowsProcess
extends PidProcess {
    private static final int EXIT_CODE_COULD_NOT_BE_TERMINATED = 1;
    private static final int EXIT_CODE_NO_SUCH_PROCESS = 128;
    private boolean gracefulDestroyEnabled;
    private boolean includeChildren;

    public WindowsProcess(int pid) {
        super(pid);
    }

    public boolean isGracefulDestroyEnabled() {
        return this.gracefulDestroyEnabled;
    }

    public void setGracefulDestroyEnabled(boolean gracefulDestroyEnabled) {
        this.gracefulDestroyEnabled = gracefulDestroyEnabled;
    }

    public boolean isIncludeChildren() {
        return this.includeChildren;
    }

    public void setIncludeChildren(boolean includeChildren) {
        this.includeChildren = includeChildren;
    }

    @Override
    public boolean isAlive() throws IOException, InterruptedException {
        String out = new ProcessExecutor().commandSplit(String.format("wmic process where ProcessId=%d get ProcessId", this.pid)).readOutput(true).redirectOutput((OutputStream)Slf4jStream.ofCaller().asTrace()).setMessageLogger(MessageLoggers.TRACE).exitValueNormal().executeNoTimeout().outputString();
        return out.contains(String.valueOf(this.pid));
    }

    @Override
    public void destroy(boolean forceful) throws IOException, InterruptedException {
        if (!forceful && !this.gracefulDestroyEnabled) {
            throw new UnsupportedOperationException();
        }
        this.taskkill(forceful);
    }

    public boolean taskkill(boolean forceful) throws IOException, InterruptedException {
        try {
            new ProcessExecutor().commandSplit(String.format("taskkill%s%s /PID %d", this.includeChildren ? " /T" : "", forceful ? " /F" : "", this.pid)).redirectOutput((OutputStream)Slf4jStream.ofCaller().asDebug()).exitValueNormal().executeNoTimeout();
            return true;
        }
        catch (InvalidExitValueException e) {
            if (e.getExitValue() == 1) {
                if (this.isAlive()) {
                    throw e;
                }
                return false;
            }
            if (e.getExitValue() == 128) {
                return false;
            }
            throw e;
        }
    }
}

