/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore.impl;

import com.singularity.ee.util.security.credentialstore.impl.AEncryptionScheme;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Base64;

public class EncryptionSchemeCBCWithPKCS5Padding
extends AEncryptionScheme {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final String CBC_PKCS5_PADDING = "/CBC/PKCS5Padding";

    public EncryptionSchemeCBCWithPKCS5Padding(String prefix) {
        super(prefix);
    }

    public String decrypt(String fullCipherText, SecretKey secretKey) throws GeneralSecurityException {
        if (fullCipherText == null) {
            return null;
        }
        String remainingCipherText = fullCipherText;
        String prefix = null;
        try {
            prefix = fullCipherText.substring(0, this.getPrefix().length());
        }
        catch (RuntimeException runtimeException) {
            throw new GeneralSecurityException("Failed to decrypt:  Incorrectly formatted cipherText: " + fullCipherText);
        }
        int ivLength = 0;
        String ivLengthString = null;
        if (this.getPrefix().equals(prefix) && remainingCipherText.length() > this.getPrefix().length()) {
            int ivLengthEndIdx = (remainingCipherText = remainingCipherText.substring(this.getPrefix().length())).indexOf("-");
            if (ivLengthEndIdx > 0) {
                try {
                    ivLengthString = remainingCipherText.substring(0, ivLengthEndIdx);
                    remainingCipherText = remainingCipherText.substring(ivLengthEndIdx + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new GeneralSecurityException("Failed to decrypt:  Incorrectly formatted cipherText prefix(00): " + fullCipherText);
                }
            } else {
                throw new GeneralSecurityException("Failed to decrypt:  Incorrectly formatted cipherText prefix(01): " + fullCipherText);
            }
            try {
                ivLength = Integer.parseInt(ivLengthString);
            }
            catch (NumberFormatException nfe) {
                throw new GeneralSecurityException("Failed to decrypt:  Incorrectly formatted cipherText prefix(02): " + fullCipherText);
            }
            if (ivLength < 1) {
                throw new GeneralSecurityException("Failed to decrypt:  Incorrectly formatted cipherText prefix(03): " + fullCipherText);
            }
        } else {
            throw new GeneralSecurityException("Failed to decrypt:  Incorrectly formatted cipherText prefix(04): " + fullCipherText);
        }
        int separatorIndex = ivLength;
        String cipherText = null;
        String ivText = null;
        try {
            if (separatorIndex <= 0) {
                throw new GeneralSecurityException("Unsupported cipher-text - Cannot decrypt(00) - CipherText: " + fullCipherText + " Idx: " + separatorIndex);
            }
            cipherText = remainingCipherText.substring(separatorIndex);
            ivText = remainingCipherText.substring(0, separatorIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new GeneralSecurityException("Unsupported cipher-text - Cannot decrypt(01) - CipherText: " + fullCipherText + " Idx: " + separatorIndex + " - ", indexOutOfBoundsException);
        }
        byte[] cipherTextBytes = null;
        byte[] cipherTextIVBytes = null;
        try {
            cipherTextBytes = cipherText.getBytes(DEFAULT_CHARSET_NAME);
            cipherTextIVBytes = ivText.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException("Unsupported encoding(01). CipherText: " + fullCipherText + " - ", unsupportedEncodingException);
        }
        byte[] base64Bytes = Base64.decodeBase64((byte[])cipherTextBytes);
        byte[] base64IVBytes = Base64.decodeBase64((byte[])cipherTextIVBytes);
        IvParameterSpec dps = new IvParameterSpec(base64IVBytes);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm() + CBC_PKCS5_PADDING);
        cipher.init(2, (Key)secretKey, dps);
        byte[] plainTextBytes = cipher.doFinal(base64Bytes);
        String plainTextString = null;
        try {
            plainTextString = new String(plainTextBytes, DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException("Unsupported encoding.", unsupportedEncodingException);
        }
        return plainTextString;
    }

    public String encrypt(String plainText, SecretKey secretKey) throws GeneralSecurityException {
        if (plainText == null) {
            throw new GeneralSecurityException("NULL Plaintext - Nothing to encrypt.");
        }
        byte[] plainTextBytes = null;
        try {
            plainTextBytes = plainText.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException("Unsupported encoding.", unsupportedEncodingException);
        }
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm() + CBC_PKCS5_PADDING);
        cipher.init(1, secretKey);
        byte[] cipherTextBytes = cipher.doFinal(plainTextBytes);
        byte[] iv = cipher.getIV();
        byte[] base64EncodedBytes = Base64.encodeBase64((byte[])cipherTextBytes);
        byte[] base64EncodedIVBytes = Base64.encodeBase64((byte[])iv);
        String cipherTextString = null;
        String cipherTextIVString = null;
        try {
            cipherTextString = new String(base64EncodedBytes, DEFAULT_CHARSET_NAME);
            cipherTextIVString = new String(base64EncodedIVBytes, DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException("Unsupported encoding.", unsupportedEncodingException);
        }
        return this.getPrefix() + Integer.toString(cipherTextIVString.length()) + "-" + cipherTextIVString + cipherTextString;
    }
}

