/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore;

import com.singularity.ee.util.security.credentialstore.EncryptionCommon;
import com.singularity.ee.util.security.credentialstore.KeyStoreHelper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class KeyStoreManager {
    private final SecretKey secretKey;
    private static final String TEST_PLAINTEXT = "PlainText_00";
    private static final String[] SUPPORTED_CIPHERS = new String[]{"AES", "AES", "DESede", "DESede", "DES"};
    private static final int[] SUPPORTED_KEY_LENGTH = new int[]{256, 128, 168, 112, 56};

    KeyStoreManager(String keyStoreFilename, char[] keyStorePassword, String keyStoreFormat) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStoreHelper.loadKeyStore(keyStoreFilename, keyStorePassword, keyStoreFormat);
        this.secretKey = this.fetchSecretKey("secretKeyAlias", keyStorePassword, keyStore);
    }

    private SecretKey fetchSecretKey(String secretKeyAlias, char[] secretKeyPassword, KeyStore keyStore) throws GeneralSecurityException {
        KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)keyStore.getEntry(secretKeyAlias, new KeyStore.PasswordProtection(secretKeyPassword));
        return secretKeyEntry.getSecretKey();
    }

    SecretKey getSecretKey() {
        return this.secretKey;
    }

    public static boolean checkIfValidKeyStoreExists(String keyStoreFilename, char[] keyStorePassword, String keyStoreFormat) throws IOException, GeneralSecurityException {
        KeyStoreManager keyStoreManager = new KeyStoreManager(keyStoreFilename, keyStorePassword, keyStoreFormat);
        return keyStoreManager.getSecretKey() != null;
    }

    private static SecretKey generateSecretKey(String algorithm, int keyStrength) {
        SecureRandom random = new SecureRandom();
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            keyGenerator.init(keyStrength, random);
            SecretKey localSecretKey = keyGenerator.generateKey();
            String cipherText = EncryptionCommon.encryptPlainTextString(TEST_PLAINTEXT, localSecretKey);
            String plainText = EncryptionCommon.decryptCipherTextString(cipherText, localSecretKey);
            return plainText.equals(TEST_PLAINTEXT) ? localSecretKey : null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }

    private static SecretKey generateSecretKey() throws KeyStoreException {
        for (int i = 0; i < SUPPORTED_CIPHERS.length; ++i) {
            SecretKey localSecretKey = KeyStoreManager.generateSecretKey(SUPPORTED_CIPHERS[i], SUPPORTED_KEY_LENGTH[i]);
            if (localSecretKey == null) continue;
            return localSecretKey;
        }
        return null;
    }

    public static KeyStore createNewKeyStoreInstance(String keystoreFormat, char[] keyStorePassword) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(keystoreFormat);
            keyStore.load(null, keyStorePassword);
            return keyStore;
        }
        catch (IOException fileNotFoundException) {
            return null;
        }
    }

    public static SecretKey createNewSecretKeyInStoreInstance(KeyStore keyStore, char[] keyPassword) throws KeyStoreException {
        SecretKey secretKey = KeyStoreManager.generateSecretKey();
        keyStore.setEntry("secretKeyAlias", new KeyStore.SecretKeyEntry(secretKey), new KeyStore.PasswordProtection(keyPassword));
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveKeyStoreObjectInFileSystem(KeyStore keyStore, String keyStoreFilename, char[] keyStorePassword) throws IOException, GeneralSecurityException {
        boolean isKeyStoreSavedSuccessfully = false;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(keyStoreFilename);
            keyStore.store(outputStream, keyStorePassword);
            isKeyStoreSavedSuccessfully = true;
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
        return isKeyStoreSavedSuccessfully;
    }
}

