/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.security.credentialstore;

import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.ObfuscationWrapper;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class KeyStoreBasedEncryptionWrapperFactory {
    public KeyStoreBasedEncryptionWrapper createWithObfuscatedPassword(String credentialStoreFilename, String obfuscatedPassword) throws GeneralSecurityException, IOException {
        return this.createWithObfuscatedPassword(credentialStoreFilename, obfuscatedPassword, "JCEKS");
    }

    public KeyStoreBasedEncryptionWrapper createWithObfuscatedPassword(String credentialStoreFilename, String obfuscatedPassword, String keystoreFormat) throws GeneralSecurityException, IOException {
        String credentialStorePassword = ObfuscationWrapper.deobfuscateString(obfuscatedPassword);
        KeyStoreBasedEncryptionWrapper encryptionWrapper = new KeyStoreBasedEncryptionWrapper(credentialStoreFilename, credentialStorePassword, keystoreFormat);
        return encryptionWrapper;
    }

    public KeyStoreBasedEncryptionWrapper createWithClearTextPassword(String credentialStoreFilename, String password) throws GeneralSecurityException, IOException {
        return this.createWithClearTextPassword(credentialStoreFilename, password, "JCEKS");
    }

    public KeyStoreBasedEncryptionWrapper createWithClearTextPassword(String credentialStoreFilename, String password, String format) throws GeneralSecurityException, IOException {
        KeyStoreBasedEncryptionWrapper encryptionWrapper = new KeyStoreBasedEncryptionWrapper(credentialStoreFilename, password, format);
        return encryptionWrapper;
    }
}

