/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Single;
import rx.SingleSubscriber;
import rx.exceptions.Exceptions;
import rx.functions.FuncN;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.CompositeSubscription;

public class SingleOperatorZip {
    public static <T, R> Single<R> zip(final Single<? extends T>[] singles, final FuncN<? extends R> zipper) {
        return Single.create(new Single.OnSubscribe<R>(){

            @Override
            public void call(final SingleSubscriber<? super R> subscriber) {
                final AtomicInteger wip = new AtomicInteger(singles.length);
                final AtomicBoolean once = new AtomicBoolean();
                final Object[] values = new Object[singles.length];
                CompositeSubscription compositeSubscription = new CompositeSubscription();
                subscriber.add(compositeSubscription);
                for (int i = 0; i < singles.length && !compositeSubscription.isUnsubscribed() && !once.get(); ++i) {
                    final int j = i;
                    SingleSubscriber singleSubscriber = new SingleSubscriber<T>(){

                        @Override
                        public void onSuccess(T value) {
                            values[j] = value;
                            if (wip.decrementAndGet() == 0) {
                                Object r;
                                try {
                                    r = zipper.call(values);
                                }
                                catch (Throwable e) {
                                    Exceptions.throwIfFatal(e);
                                    this.onError(e);
                                    return;
                                }
                                subscriber.onSuccess(r);
                            }
                        }

                        @Override
                        public void onError(Throwable error) {
                            if (once.compareAndSet(false, true)) {
                                subscriber.onError(error);
                            } else {
                                RxJavaPlugins.getInstance().getErrorHandler().handleError(error);
                            }
                        }
                    };
                    compositeSubscription.add(singleSubscriber);
                    if (compositeSubscription.isUnsubscribed() || once.get()) break;
                    singles[i].subscribe(singleSubscriber);
                }
            }
        });
    }
}

