/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.internal.producers.ProducerArbiter;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.SerialSubscription;

public final class OperatorSwitch<T>
implements Observable.Operator<T, Observable<? extends T>> {
    final boolean delayError;

    public static <T> OperatorSwitch<T> instance(boolean delayError) {
        if (delayError) {
            return HolderDelayError.INSTANCE;
        }
        return Holder.INSTANCE;
    }

    OperatorSwitch(boolean delayError) {
        this.delayError = delayError;
    }

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        SwitchSubscriber<T> sws = new SwitchSubscriber<T>(child, this.delayError);
        child.add(sws);
        sws.init();
        return sws;
    }

    private static final class InnerSubscriber<T>
    extends Subscriber<T> {
        private final long id;
        private final SwitchSubscriber<T> parent;

        InnerSubscriber(long id, SwitchSubscriber<T> parent) {
            this.id = id;
            this.parent = parent;
        }

        @Override
        public void setProducer(Producer p) {
            this.parent.arbiter.setProducer(p);
        }

        @Override
        public void onNext(T t) {
            this.parent.emit(t, this.id);
        }

        @Override
        public void onError(Throwable e) {
            this.parent.error(e, this.id);
        }

        @Override
        public void onCompleted() {
            this.parent.complete(this.id);
        }
    }

    private static final class SwitchSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final Subscriber<? super T> child;
        final SerialSubscription ssub;
        final ProducerArbiter arbiter;
        final boolean delayError;
        long index;
        Throwable error;
        boolean mainDone;
        List<T> queue;
        boolean innerActive;
        boolean emitting;
        boolean missed;

        SwitchSubscriber(Subscriber<? super T> child, boolean delayError) {
            this.child = child;
            this.arbiter = new ProducerArbiter();
            this.ssub = new SerialSubscription();
            this.delayError = delayError;
        }

        void init() {
            this.child.add(this.ssub);
            this.child.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    if (n > 0L) {
                        SwitchSubscriber.this.arbiter.request(n);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Observable<? extends T> t) {
            InnerSubscriber inner;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                long id = ++this.index;
                inner = new InnerSubscriber(id, this);
                this.innerActive = true;
            }
            this.ssub.set(inner);
            t.unsafeSubscribe(inner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                e = this.updateError(e);
                this.mainDone = true;
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                if (this.delayError && this.innerActive) {
                    return;
                }
                this.emitting = true;
            }
            this.child.onError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            Throwable ex;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                this.mainDone = true;
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                if (this.innerActive) {
                    return;
                }
                this.emitting = true;
                ex = this.error;
            }
            if (ex == null) {
                this.child.onCompleted();
            } else {
                this.child.onError(ex);
            }
        }

        Throwable updateError(Throwable e) {
            Throwable ex = this.error;
            if (ex == null) {
                this.error = e;
            } else if (ex instanceof CompositeException) {
                CompositeException ce = (CompositeException)ex;
                ArrayList<Throwable> list = new ArrayList<Throwable>(ce.getExceptions());
                list.add(e);
                this.error = e = new CompositeException(list);
            } else {
                this.error = e = new CompositeException(Arrays.asList(ex, e));
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emit(T value, long id) {
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                if (id != this.index) {
                    return;
                }
                if (this.emitting) {
                    List<T> q = this.queue;
                    if (q == null) {
                        q = new ArrayList<T>(4);
                        this.queue = q;
                    }
                    q.add(value);
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            this.child.onNext(value);
            this.arbiter.produced(1L);
            while (!this.child.isUnsubscribed()) {
                boolean localActive;
                List<T> localQueue;
                boolean localMainDone;
                Throwable localError;
                SwitchSubscriber switchSubscriber2 = this;
                synchronized (switchSubscriber2) {
                    if (!this.missed) {
                        this.emitting = false;
                        return;
                    }
                    localError = this.error;
                    localMainDone = this.mainDone;
                    localQueue = this.queue;
                    localActive = this.innerActive;
                }
                if (!this.delayError && localError != null) {
                    this.child.onError(localError);
                    return;
                }
                if (localQueue == null && !localActive && localMainDone) {
                    if (localError != null) {
                        this.child.onError(localError);
                    } else {
                        this.child.onCompleted();
                    }
                    return;
                }
                if (localQueue == null) continue;
                int n = 0;
                for (T v : localQueue) {
                    if (this.child.isUnsubscribed()) {
                        return;
                    }
                    this.child.onNext(v);
                    ++n;
                }
                this.arbiter.produced(n);
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void error(Throwable e, long id) {
            boolean drop;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                if (id == this.index) {
                    this.innerActive = false;
                    e = this.updateError(e);
                    if (this.emitting) {
                        this.missed = true;
                        return;
                    }
                    if (this.delayError && !this.mainDone) {
                        return;
                    }
                    this.emitting = true;
                    drop = false;
                } else {
                    drop = true;
                }
            }
            if (drop) {
                this.pluginError(e);
            } else {
                this.child.onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete(long id) {
            Throwable ex;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                if (id != this.index) {
                    return;
                }
                this.innerActive = false;
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                ex = this.error;
                if (!this.mainDone) {
                    return;
                }
            }
            if (ex != null) {
                this.child.onError(ex);
            } else {
                this.child.onCompleted();
            }
        }

        void pluginError(Throwable e) {
            RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
        }
    }

    private static final class HolderDelayError {
        static final OperatorSwitch<Object> INSTANCE = new OperatorSwitch(true);

        private HolderDelayError() {
        }
    }

    private static final class Holder {
        static final OperatorSwitch<Object> INSTANCE = new OperatorSwitch(false);

        private Holder() {
        }
    }
}

